/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.google.gwt.maps.client.base.LatLng;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.impl.DegreeBearingImpl;

public class RotatedCoordinateSystem
implements CoordinateSystem {
    private final Bearing rotationAngle;
    private final double rotationAngleInDegrees;

    public RotatedCoordinateSystem(Bearing equator) {
        this.rotationAngle = equator.getDifferenceTo((Bearing)new DegreeBearingImpl(90.0));
        this.rotationAngleInDegrees = this.rotationAngle.getDegrees();
    }

    public Position getPosition(LatLng p) {
        return new DegreePosition(p.getLatitude(), p.getLongitude());
    }

    public Bearing map(Bearing bearing) {
        return bearing;
    }

    public double mapDegreeBearing(double trueBearingInDegrees) {
        return (trueBearingInDegrees + this.rotationAngleInDegrees) % 360.0;
    }

    public LatLng toLatLng(Position position) {
        return LatLng.newInstance((double)position.getLatDeg(), (double)position.getLngDeg());
    }
}

