/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.base.Point;
import com.google.gwt.maps.client.base.Size;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.domain.common.dto.BoatClassDTO;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.gwt.ui.client.shared.racemap.BoatClassVectorGraphicsResolver;
import com.sap.sailing.gwt.ui.client.shared.racemap.BoatOverlay;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.shared.GPSFixDTOWithSpeedWindTackAndLegType;
import com.sap.sailing.gwt.ui.shared.racemap.BoatClassVectorGraphics;
import com.sap.sailing.gwt.ui.shared.racemap.CanvasOverlayV3;
import com.sap.sse.common.Color;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Util;
import java.util.HashMap;
import java.util.Map;

public class BoatOverlay
extends CanvasOverlayV3 {
    private final BoatClassDTO boatClass;
    private GPSFixDTOWithSpeedWindTackAndLegType boatFix;
    private static double ORIGINAL_BOAT_IMAGE_ROTATIION_ANGLE = 90.0;
    private int canvasWidth;
    private int canvasHeight;
    private Color color;
    private Map<Long, Util.Pair<Size, Size>> boatScaleAndSizePerWorldWidthCache;
    private final BoatClassVectorGraphics boatVectorGraphics;
    private LegType lastLegType;
    private Tack lastTack;
    private Boolean lastSelected;
    private Integer lastWidth;
    private Integer lastHeight;
    private Size lastScale;
    private Color lastColor;
    private DisplayMode lastDisplayMode;
    private DisplayMode displayMode;

    public BoatOverlay(MapWidget map, int zIndex, BoatDTO boatDTO, Color color, CoordinateSystem coordinateSystem) {
        super(map, zIndex, coordinateSystem);
        this.boatClass = boatDTO.getBoatClass();
        this.color = color;
        this.boatScaleAndSizePerWorldWidthCache = new HashMap();
        this.boatVectorGraphics = BoatClassVectorGraphicsResolver.resolveBoatClassVectorGraphics((String)this.boatClass.getName());
    }

    protected void draw() {
        if (this.getMapProjection() != null && this.boatFix != null) {
            long worldWidth = (long)this.getMapProjection().getWorldWidth();
            Util.Pair boatScaleAndSize = this.boatScaleAndSizePerWorldWidthCache.computeIfAbsent(worldWidth, z -> this.getBoatScaleAndSize(this.boatClass));
            Size boatSizeScaleFactor = (Size)boatScaleAndSize.getA();
            this.canvasWidth = (int)((Size)boatScaleAndSize.getB()).getWidth();
            this.canvasHeight = (int)((Size)boatScaleAndSize.getB()).getHeight();
            if (this.lastWidth == null || this.canvasWidth != this.lastWidth || this.lastHeight == null || this.canvasHeight != this.lastHeight) {
                this.setCanvasSize(this.canvasWidth, this.canvasHeight);
            }
            if (this.needToDraw(this.boatFix.legType, this.boatFix.tack, this.isSelected(), (double)this.canvasWidth, (double)this.canvasHeight, boatSizeScaleFactor, this.color, this.displayMode)) {
                this.boatVectorGraphics.drawBoatToCanvas(this.getCanvas().getContext2d(), this.boatFix.legType, this.boatFix.tack, this.getDisplayMode(), (double)this.canvasWidth, (double)this.canvasHeight, boatSizeScaleFactor, this.color);
                this.lastLegType = this.boatFix.legType;
                this.lastTack = this.boatFix.tack;
                this.lastSelected = this.isSelected();
                this.lastWidth = this.canvasWidth;
                this.lastHeight = this.canvasHeight;
                this.lastScale = boatSizeScaleFactor;
                this.lastColor = this.color;
                this.lastDisplayMode = this.displayMode;
            }
            LatLng latLngPosition = this.coordinateSystem.toLatLng(this.boatFix.position);
            Point boatPositionInPx = this.getMapProjection().fromLatLngToDivPixel(latLngPosition);
            this.setCanvasPosition(boatPositionInPx.getX() - (double)(this.getCanvas().getCoordinateSpaceWidth() / 2), boatPositionInPx.getY() - (double)(this.getCanvas().getCoordinateSpaceHeight() / 2));
            double trueHeadingInDegrees = this.boatFix.optionalTrueHeading != null ? this.boatFix.optionalTrueHeading.getDegrees() : (this.boatFix.speedWithBearing == null ? 0.0 : this.boatFix.speedWithBearing.bearingInDegrees);
            this.updateDrawingAngleAndSetCanvasRotation(this.coordinateSystem.mapDegreeBearing(trueHeadingInDegrees - ORIGINAL_BOAT_IMAGE_ROTATIION_ANGLE));
        }
    }

    private boolean needToDraw(LegType legType, Tack tack, boolean isSelected, double width, double height, Size scaleFactor, Color color, DisplayMode displayMode) {
        return this.lastLegType == null || this.lastLegType != legType || this.lastTack == null || this.lastTack != tack || this.lastSelected == null || this.lastSelected != isSelected || this.lastWidth == null || (double)this.lastWidth.intValue() != width || this.lastHeight == null || (double)this.lastHeight.intValue() != height || this.lastScale == null || !this.lastScale.equals(scaleFactor) || this.lastColor == null || !this.lastColor.equals(color) || this.lastDisplayMode == null || !this.lastDisplayMode.equals((Object)displayMode);
    }

    public void setBoatFix(GPSFixDTOWithSpeedWindTackAndLegType boatFix, long timeForPositionTransitionMillis) {
        this.updateTransition(timeForPositionTransitionMillis);
        this.boatFix = boatFix;
    }

    public Util.Pair<Size, Size> getBoatScaleAndSize(BoatClassDTO boatClass) {
        Size boatSizeInPixels = this.getCorrelatedBoatSize(boatClass.getHullLength(), boatClass.getHullBeam());
        double boatHullScaleFactor = boatSizeInPixels.getWidth() / this.boatVectorGraphics.getHullLengthInPx();
        double boatBeamScaleFactor = boatSizeInPixels.getHeight() / this.boatVectorGraphics.getBeamInPx();
        double scaledWidthSize = this.boatVectorGraphics.getOverallLengthInPx() * boatHullScaleFactor;
        double scaledBeamSize = this.boatVectorGraphics.getOverallLengthInPx() * boatBeamScaleFactor;
        return new Util.Pair((Object)Size.newInstance((double)boatHullScaleFactor, (double)boatBeamScaleFactor), (Object)Size.newInstance((double)(scaledWidthSize + scaledWidthSize / 2.0), (double)(scaledBeamSize + scaledBeamSize / 2.0)));
    }

    private Size getCorrelatedBoatSize(Distance hullLength, Distance hullBeam) {
        Size boatSizeInPixel = this.calculateBoundingBox(this.getMapProjection(), this.boatFix.position, hullLength, hullBeam);
        this.changeBoatSizeIfTooShortHull(boatSizeInPixel, hullLength, hullBeam);
        this.changeBoatSizeIfTooNarrowBeam(boatSizeInPixel, hullLength, hullBeam);
        return boatSizeInPixel;
    }

    private void changeBoatSizeIfTooShortHull(Size boatSizeInPixel, Distance hullLength, Distance hullBeam) {
        double minBoatHullLengthInPx = this.boatVectorGraphics.getMinHullLengthInPx();
        if (boatSizeInPixel.getWidth() < minBoatHullLengthInPx) {
            double ratioBeamHullLength = hullBeam.divide(hullLength);
            boatSizeInPixel.setHeight(minBoatHullLengthInPx * ratioBeamHullLength);
            boatSizeInPixel.setWidth(minBoatHullLengthInPx);
        }
    }

    private void changeBoatSizeIfTooNarrowBeam(Size boatSizeInPixel, Distance hullLength, Distance hullBeam) {
        double minBoatBeamInPx = this.boatVectorGraphics.getMinBeamInPx();
        if (boatSizeInPixel.getHeight() < minBoatBeamInPx) {
            double ratioHullBeamLength = hullLength.divide(hullBeam);
            boatSizeInPixel.setWidth(minBoatBeamInPx * ratioHullBeamLength);
            boatSizeInPixel.setHeight(minBoatBeamInPx);
        }
    }

    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(DisplayMode displayMode) {
        this.displayMode = displayMode;
    }
}

