/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole.places.refresher;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sailing.gwt.ui.adminconsole.places.refresher.AbstractRefresher;
import com.sap.sailing.gwt.ui.client.Displayer;
import com.sap.sailing.gwt.ui.client.Refresher;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;

public abstract class AbstractRefresher<T>
implements Refresher<T> {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private final Set<Displayer<T>> displayers = new HashSet();
    private List<T> dtos;
    private boolean loading;

    public void addDisplayerAndCallFillOnInit(Displayer<T> displayer) {
        if (displayer == null) {
            throw new IllegalArgumentException("Displayer cannot be null.");
        }
        this.displayers.add(displayer);
        if (this.dtos == null) {
            this.reloadAndCallFillAll();
        } else {
            this.logger.fine("Call fill methods from displayers with data from cache.");
            this.fill((Iterable)this.dtos, displayer);
        }
    }

    public void removeDisplayer(Displayer<T> displayer) {
        this.displayers.remove(displayer);
    }

    public void reloadAndCallFillOnly(Displayer<T> fillOnlyDisplayer) {
        this.reloadAndCallFillOnly(fillOnlyDisplayer, null);
    }

    public void reloadAndCallFillOnly(Displayer<T> fillOnlyDisplayer, Displayer<T> fillAdditionally) {
        1 callback = new /* Unavailable Anonymous Inner Class!! */;
        if (!this.loading) {
            this.logger.fine("Start loading data from service.");
            this.loading = true;
            this.reload((AsyncCallback)callback);
        } else {
            this.logger.fine("Data is already loading. Skip reload.");
        }
    }

    public void reloadAndCallFillAll() {
        this.reloadAndCallFillOnly(null);
    }

    public void updateAndCallFillForAll(Iterable<T> dtos, Displayer<T> origin) {
        this.callAllFill(dtos, origin);
    }

    public void callFillAndReloadInitially(Displayer<T> displayer) {
        if (this.dtos == null) {
            this.reloadAndCallFillOnly(null, displayer);
        } else if (displayer != null) {
            this.fill((Iterable)this.dtos, displayer);
        }
    }

    private void callAllFill(Iterable<T> dtos, Displayer<T> origin) {
        this.displayers.stream().filter(displayer2 -> !Objects.equals(displayer2, origin)).forEach(displayer -> this.fill(dtos, displayer));
    }

    public void callAllFill() {
        this.displayers.stream().forEach(displayer -> this.fill((Iterable)this.dtos, displayer));
    }

    public abstract void reload(AsyncCallback<Iterable<T>> var1);

    protected void fill(Iterable<T> dtos, Displayer<T> displayer) {
        displayer.fill(dtos);
    }

    public void addIfNotContainedElseReplace(T dto, EntityIdentityComparator<T> comp) {
        if (dto != null && this.dtos != null) {
            Optional<Object> existingDtoOption = this.dtos.stream().filter(listDto -> comp.representSameEntity(listDto, dto)).findFirst();
            if (existingDtoOption.isPresent()) {
                int index = this.dtos.indexOf(existingDtoOption.get());
                this.dtos.set(index, dto);
            } else {
                this.add(dto);
            }
        }
    }

    public void add(T dto) {
        if (dto != null && this.dtos != null) {
            this.dtos.add(dto);
        }
    }

    public void remove(T dto) {
        if (dto != null && this.dtos != null) {
            this.dtos.remove(dto);
        }
    }

    public void removeAll(Predicate<T> filter) {
        if (this.dtos != null) {
            Iterator i = this.dtos.iterator();
            while (i.hasNext()) {
                Object dto = i.next();
                if (!filter.test(dto)) continue;
                i.remove();
            }
        }
    }

    static /* synthetic */ void access$0(AbstractRefresher abstractRefresher, List list) {
        abstractRefresher.dtos = list;
    }

    static /* synthetic */ List access$1(AbstractRefresher abstractRefresher) {
        return abstractRefresher.dtos;
    }

    static /* synthetic */ void access$2(AbstractRefresher abstractRefresher, boolean bl) {
        abstractRefresher.loading = bl;
    }

    static /* synthetic */ Logger access$3(AbstractRefresher abstractRefresher) {
        return abstractRefresher.logger;
    }

    static /* synthetic */ void access$4(AbstractRefresher abstractRefresher, Iterable iterable, Displayer displayer) {
        abstractRefresher.callAllFill(iterable, displayer);
    }

    static /* synthetic */ Set access$5(AbstractRefresher abstractRefresher) {
        return abstractRefresher.displayers;
    }
}

