/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole.coursecreation;

import com.google.gwt.text.shared.Renderer;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.ValueListBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.MarkType;
import com.sap.sailing.gwt.ui.adminconsole.coursecreation.InvalidColor;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.courseCreation.MarkPropertiesDTO;
import com.sap.sailing.gwt.ui.shared.racemap.Pattern;
import com.sap.sailing.gwt.ui.shared.racemap.Shape;
import com.sap.sse.gwt.client.ColorTextBox;
import com.sap.sse.gwt.client.IconResources;
import com.sap.sse.gwt.client.controls.listedit.StringListEditorComposite;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;

public class MarkPropertiesEditDialog
extends DataEntryDialog<MarkPropertiesDTO> {
    private final TextBox nameTextBox;
    private final ColorTextBox displayColorTextBox;
    private final TextBox shortNameTextBox;
    private final ValueListBox<MarkType> markTypeValueListBox;
    private final ValueListBox<Pattern> patternValueListBox;
    private final ValueListBox<Shape> shapeValueListBox;
    final StringMessages stringMessages;
    private final Label labelShape;
    private final Label labelPattern;
    private final StringListEditorComposite tagsEditor;
    private final UUID id;

    public MarkPropertiesEditDialog(StringMessages stringMessages, MarkPropertiesDTO markPropertiesToEdit, DataEntryDialog.DialogCallback<MarkPropertiesDTO> callback) {
        super(String.valueOf(stringMessages.edit()) + " " + stringMessages.markProperties(), null, stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new /* Unavailable Anonymous Inner Class!! */, true, callback);
        this.ensureDebugId("MarkPropertiesToEditEditDialog");
        this.id = markPropertiesToEdit.getUuid();
        this.stringMessages = stringMessages;
        this.markTypeValueListBox = new ValueListBox((Renderer)new /* Unavailable Anonymous Inner Class!! */);
        this.labelPattern = new Label(stringMessages.pattern());
        this.patternValueListBox = new ValueListBox((Renderer)new /* Unavailable Anonymous Inner Class!! */);
        this.labelShape = new Label(stringMessages.shape());
        this.shapeValueListBox = new ValueListBox((Renderer)new /* Unavailable Anonymous Inner Class!! */);
        this.nameTextBox = this.createTextBox(markPropertiesToEdit.getName());
        this.shortNameTextBox = this.createTextBox(markPropertiesToEdit.getCommonMarkProperties().getShortName());
        this.markTypeValueListBox.setValue((Object)(markPropertiesToEdit.getCommonMarkProperties().getType() != null ? markPropertiesToEdit.getCommonMarkProperties().getType() : MarkType.values()[0]));
        this.markTypeValueListBox.setAcceptableValues(Arrays.asList(MarkType.values()));
        this.markTypeValueListBox.addValueChangeHandler(v -> this.handleMarkTypeChange());
        this.displayColorTextBox = this.createColorTextBox(markPropertiesToEdit.getCommonMarkProperties().getColor());
        String loadedShape = markPropertiesToEdit.getCommonMarkProperties().getShape();
        if (loadedShape != null && !loadedShape.isEmpty()) {
            this.shapeValueListBox.setValue((Object)Shape.valueOf((String)loadedShape));
        }
        ArrayList<Shape> shapeValues = new ArrayList<Shape>(Arrays.asList(Shape.values()));
        shapeValues.add(null);
        this.shapeValueListBox.setAcceptableValues(shapeValues);
        String loadedPattern = markPropertiesToEdit.getCommonMarkProperties().getPattern();
        if (loadedPattern != null && !loadedPattern.isEmpty()) {
            this.patternValueListBox.setValue((Object)Pattern.valueOf((String)loadedPattern));
        }
        ArrayList<Pattern> patternValues = new ArrayList<Pattern>(Arrays.asList(Pattern.values()));
        patternValues.add(null);
        this.patternValueListBox.setAcceptableValues(patternValues);
        this.tagsEditor = new StringListEditorComposite(markPropertiesToEdit.getTags(), (com.sap.sse.gwt.client.StringMessages)stringMessages, stringMessages.edit(stringMessages.tags()), IconResources.INSTANCE.removeIcon(), Collections.emptyList(), stringMessages.tag());
        this.handleMarkTypeChange();
    }

    private void handleMarkTypeChange() {
        boolean isBuoy = this.markTypeValueListBox.getValue() == MarkType.BUOY;
        this.shapeValueListBox.setVisible(isBuoy);
        this.patternValueListBox.setVisible(isBuoy);
        this.labelShape.setVisible(isBuoy);
        this.labelPattern.setVisible(isBuoy);
        if (!isBuoy) {
            this.shapeValueListBox.setValue(null);
            this.patternValueListBox.setValue(null);
        }
        this.validateAndUpdate();
    }

    protected Focusable getInitialFocusWidget() {
        return this.nameTextBox;
    }

    protected MarkPropertiesDTO getResult() {
        Object color = !this.displayColorTextBox.isValid() ? new InvalidColor(this.stringMessages, this.displayColorTextBox.getValue()) : this.displayColorTextBox.getColor();
        MarkPropertiesDTO markProperties = new MarkPropertiesDTO(this.id, this.nameTextBox.getValue(), (Iterable)this.tagsEditor.getValue(), this.shortNameTextBox.getValue(), color, this.shapeValueListBox.getValue() == null ? "" : ((Shape)this.shapeValueListBox.getValue()).name(), this.patternValueListBox.getValue() == null ? "" : ((Pattern)this.patternValueListBox.getValue()).name(), (MarkType)this.markTypeValueListBox.getValue(), null);
        return markProperties;
    }

    protected Widget getAdditionalWidget() {
        Grid result = new Grid(7, 2);
        result.setWidget(0, 0, (Widget)new Label(this.stringMessages.name()));
        result.setWidget(0, 1, (Widget)this.nameTextBox);
        result.setWidget(1, 0, (Widget)new Label(this.stringMessages.shortName()));
        result.setWidget(1, 1, (Widget)this.shortNameTextBox);
        result.setWidget(2, 0, (Widget)new Label(this.stringMessages.color()));
        result.setWidget(2, 1, (Widget)this.displayColorTextBox);
        result.setWidget(3, 0, (Widget)this.labelShape);
        result.setWidget(3, 1, (Widget)this.shapeValueListBox);
        result.setWidget(4, 0, (Widget)this.labelPattern);
        result.setWidget(4, 1, (Widget)this.patternValueListBox);
        result.setWidget(5, 0, (Widget)new Label(this.stringMessages.type()));
        result.setWidget(5, 1, (Widget)this.markTypeValueListBox);
        result.setWidget(6, 0, (Widget)new Label(this.stringMessages.tags()));
        result.setWidget(6, 1, (Widget)this.tagsEditor);
        return result;
    }
}

