/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.shared.partials.statistics;

import com.sap.sailing.gwt.home.communication.event.statistics.EventStatisticsDTO;
import com.sap.sailing.gwt.home.shared.partials.statistics.AbstractStatisticsBoxPresenter;
import com.sap.sailing.gwt.home.shared.partials.statistics.StatisticsBoxResources;
import com.sap.sailing.gwt.home.shared.partials.statistics.StatisticsBoxView;
import com.sap.sailing.gwt.home.shared.refresh.RefreshableWidget;
import com.sap.sailing.gwt.ui.client.StringMessages;

public class EventStatisticsBoxPresenter
extends AbstractStatisticsBoxPresenter
implements RefreshableWidget<EventStatisticsDTO> {
    private static final StringMessages MSG = StringMessages.INSTANCE;
    private final boolean showRegattaInformation;

    public EventStatisticsBoxPresenter(boolean showRegattaInformation, StatisticsBoxView view) {
        super(view);
        this.showRegattaInformation = showRegattaInformation;
    }

    public void setData(EventStatisticsDTO statistics) {
        this.clear();
        if (this.showRegattaInformation) {
            this.addItem(StatisticsBoxResources.INSTANCE.regattasFought(), MSG.regattas(), (Object)statistics.getRegattasFoughtCount());
        }
        this.addItemIfNotNull(StatisticsBoxResources.INSTANCE.averageSpeed(), MSG.competitors(), (Object)statistics.getCompetitorsCount());
        this.addItem(StatisticsBoxResources.INSTANCE.racesCount(), MSG.races(), (Object)statistics.getRacesRunCount());
        this.addItem(StatisticsBoxResources.INSTANCE.trackedCount(), MSG.trackedRaces(), (Object)statistics.getTrackedRacesCount());
        this.addItemWithCompactFormat(StatisticsBoxResources.INSTANCE.gpsFixes(), MSG.numberOfGPSFixes(), statistics.getNumberOfGPSFixes());
        this.addItemWithCompactFormat(StatisticsBoxResources.INSTANCE.strongestWind(), MSG.numberWindFixes(), statistics.getNumberOfWindFixes());
        this.addItemWithCompactFormat(StatisticsBoxResources.INSTANCE.sumMiles(), MSG.sailedMiles(), statistics.getTotalDistanceTraveled() == null ? null : Double.valueOf(statistics.getTotalDistanceTraveled().getSeaMiles()));
        this.addCompetitorItem(StatisticsBoxResources.INSTANCE.fastestSailor(), MSG.fastestSailor(), statistics.getFastestCompetitor());
        this.addKnotsItem(StatisticsBoxResources.INSTANCE.maxSpeed(), MSG.highestSpeed(), statistics.getFastestCompetitorSpeedInKnots());
    }
}

