/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.autoplay.client.places.autoplaystart;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.autoplay.client.configs.AutoPlayConfiguration;
import com.sap.sailing.gwt.autoplay.client.configs.AutoPlayContextDefinition;
import com.sap.sailing.gwt.autoplay.client.configs.AutoPlayContextDefinitionImpl;
import com.sap.sailing.gwt.autoplay.client.configs.AutoPlayType;
import com.sap.sailing.gwt.autoplay.client.places.autoplaystart.AutoPlayStartView;
import com.sap.sailing.gwt.autoplay.client.places.autoplaystart.AutoPlayStartViewImpl;
import com.sap.sailing.gwt.common.client.SharedResources;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sailing.gwt.ui.shared.LeaderboardGroupDTO;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.GWTLocaleUtil;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveCompositeSettings;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import com.sap.sse.security.ui.client.premium.PaywallResolverImpl;
import java.util.ArrayList;
import java.util.List;

public class AutoPlayStartViewImpl
extends Composite
implements AutoPlayStartView {
    private static StartPageViewUiBinder uiBinder = (StartPageViewUiBinder)GWT.create(StartPageViewUiBinder.class);
    @UiField(provided=true)
    ListBox localeSelectionBox;
    @UiField(provided=true)
    ListBox eventSelectionBox;
    @UiField(provided=true)
    ListBox configurationSelectionBox;
    @UiField(provided=true)
    ListBox leaderboardSelectionBox;
    @UiField
    Button startAutoPlayButton;
    @UiField
    Button settingsButton;
    @UiField
    DivElement leaderboardSelectionUi;
    @UiField
    Anchor configStarter;
    private final List<EventDTO> events = new ArrayList();
    private AutoPlayType selectedAutoPlayType = null;
    private EventDTO selectedEvent;
    private StrippedLeaderboardDTO selectedLeaderboard;
    private AutoPlayStartView.Presenter currentPresenter;
    private AutoPlayContextDefinitionImpl apcd;
    private PerspectiveCompositeSettings<?> settings;
    private String configuratedUrl;

    public AutoPlayStartViewImpl() {
        this.eventSelectionBox = new ListBox();
        this.eventSelectionBox.setMultipleSelect(false);
        this.eventSelectionBox.ensureDebugId("eventSelectionBox");
        this.leaderboardSelectionBox = new ListBox();
        this.leaderboardSelectionBox.setMultipleSelect(false);
        this.leaderboardSelectionBox.ensureDebugId("leaderboardSelectionBox");
        this.localeSelectionBox = new ListBox();
        this.localeSelectionBox.setMultipleSelect(false);
        this.configurationSelectionBox = new ListBox();
        this.configurationSelectionBox.addItem("--", "");
        this.configurationSelectionBox.ensureDebugId("configurationSelectionBox");
        AutoPlayType[] autoPlayTypeArray = AutoPlayType.values();
        int n = autoPlayTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AutoPlayType apt = autoPlayTypeArray[n2];
            this.configurationSelectionBox.addItem(apt.getName(), apt.name());
            ++n2;
        }
        LocaleInfo currentLocale = LocaleInfo.getCurrentLocale();
        int i = 0;
        for (String localeName : GWTLocaleUtil.getAvailableLocales()) {
            String displayName = GWTLocaleUtil.getDecoratedLanguageDisplayNameWithDefaultLocaleSupport((String)localeName);
            this.localeSelectionBox.addItem(displayName, localeName);
            if (currentLocale.getLocaleName().equals(localeName)) {
                this.localeSelectionBox.setSelectedIndex(i);
            }
            ++i;
        }
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.ensureDebugId("AutoPlayStartView");
        this.configStarter.getElement().getStyle().setDisplay(Style.Display.BLOCK);
        this.configStarter.ensureDebugId("startURL");
        this.validate();
    }

    public void setCurrentPresenter(AutoPlayStartView.Presenter currentPresenter) {
        this.currentPresenter = currentPresenter;
    }

    public void setEvents(List<EventDTO> events) {
        this.events.clear();
        this.events.addAll(events);
        this.eventSelectionBox.addItem(StringMessages.INSTANCE.pleaseSelectAnEvent());
        for (EventDTO event : Util.sortNamedCollection(events)) {
            this.eventSelectionBox.addItem(event.getName());
        }
    }

    @UiHandler(value={"configurationSelectionBox"})
    void onConfigChange(ChangeEvent event) {
        String selectedConfigType = this.configurationSelectionBox.getSelectedValue();
        this.selectedAutoPlayType = AutoPlayType.valueOf((String)selectedConfigType);
        this.validate();
    }

    @UiHandler(value={"eventSelectionBox"})
    void onEventSelectionChange(ChangeEvent event) {
        this.selectedEvent = this.getSelectedEvent();
        if (this.selectedEvent != null) {
            this.leaderboardSelectionBox.clear();
            this.leaderboardSelectionBox.addItem(StringMessages.INSTANCE.selectALeaderboard());
            for (LeaderboardGroupDTO leaderboardGroup : this.selectedEvent.getLeaderboardGroups()) {
                for (StrippedLeaderboardDTO leaderboard : leaderboardGroup.getLeaderboards()) {
                    this.leaderboardSelectionBox.addItem(leaderboard.getName());
                }
            }
        }
        this.validate();
    }

    @UiHandler(value={"leaderboardSelectionBox"})
    void onLeaderboardSelectionChange(ChangeEvent event) {
        this.selectedLeaderboard = this.getSelectedLeaderboard();
        this.validate();
    }

    @UiHandler(value={"settingsButton"})
    void onOpenSettings(ClickEvent event) {
        PaywallResolverImpl paywallResolver = new PaywallResolverImpl(this.currentPresenter.getUserService(), this.currentPresenter.getSubscriptionServiceFactory());
        this.selectedAutoPlayType.getConfig().openSettingsDialog(this.selectedEvent, this.selectedLeaderboard, (AutoPlayConfiguration.OnSettingsCallback)new /* Unavailable Anonymous Inner Class!! */, this.settings, (AutoPlayContextDefinition)this.apcd, this.currentPresenter.getUserService(), this.currentPresenter.getSubscriptionServiceFactory(), (PaywallResolver)paywallResolver);
    }

    private boolean validate() {
        boolean readyToGo = true;
        if (readyToGo && this.selectedAutoPlayType == null) {
            readyToGo = false;
            this.eventSelectionBox.setEnabled(false);
            this.eventSelectionBox.getElement().getStyle().setOpacity(0.2);
        } else {
            this.eventSelectionBox.setEnabled(true);
            this.eventSelectionBox.getElement().getStyle().setOpacity(1.0);
        }
        EventDTO selectedEvent = this.getSelectedEvent();
        if (selectedEvent == null) {
            readyToGo = false;
            this.leaderboardSelectionBox.setEnabled(false);
            this.leaderboardSelectionBox.getElement().getStyle().setOpacity(0.2);
        } else {
            this.leaderboardSelectionBox.setEnabled(true);
            this.leaderboardSelectionBox.getElement().getStyle().setOpacity(1.0);
        }
        String selectedLeaderboardName = this.getSelectedLeaderboardName();
        if (readyToGo && selectedLeaderboardName == null) {
            readyToGo = false;
        }
        this.startAutoPlayButton.setEnabled(readyToGo);
        this.settingsButton.setEnabled(readyToGo);
        if (!readyToGo) {
            this.configuratedUrl = null;
            this.startAutoPlayButton.addStyleName(SharedResources.INSTANCE.mainCss().buttoninactive());
            this.settingsButton.addStyleName(SharedResources.INSTANCE.mainCss().buttoninactive());
            this.configStarter.setText(StringMessages.INSTANCE.invalidSelection());
            this.configStarter.setEnabled(false);
        } else {
            this.configStarter.setEnabled(true);
            this.configStarter.setText(StringMessages.INSTANCE.loading());
            this.settingsButton.removeStyleName(SharedResources.INSTANCE.mainCss().buttoninactive());
            this.startAutoPlayButton.removeStyleName(SharedResources.INSTANCE.mainCss().buttoninactive());
            this.apcd = new AutoPlayContextDefinitionImpl(this.selectedAutoPlayType, selectedEvent.id, selectedLeaderboardName);
            this.apcd.getType().getConfig().loadSettingsDefault((AutoPlayContextDefinition)this.apcd, this.selectedLeaderboard, this.currentPresenter.getUserService(), this.currentPresenter.getSubscriptionServiceFactory(), (AutoPlayConfiguration.OnSettingsCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        return readyToGo;
    }

    private void updateURL(String urlWithSettings) {
        this.configuratedUrl = urlWithSettings;
        this.configStarter.setText(urlWithSettings);
        this.configStarter.setHref(urlWithSettings);
    }

    @UiHandler(value={"localeSelectionBox"})
    void onLocaleSelectionChange(ChangeEvent event) {
        this.currentPresenter.handleLocaleChange(this.getSelectedLocale());
    }

    @UiHandler(value={"startAutoPlayButton"})
    void startAutoPlayClicked(ClickEvent event) {
        this.settingsButton.setEnabled(false);
        this.startAutoPlayButton.addStyleName(SharedResources.INSTANCE.mainCss().buttoninactive());
        this.settingsButton.addStyleName(SharedResources.INSTANCE.mainCss().buttoninactive());
        Window.Location.assign((String)this.configuratedUrl);
    }

    private String getSelectedLocale() {
        String result = null;
        int selectedIndex = this.localeSelectionBox.getSelectedIndex();
        if (selectedIndex >= 0) {
            String selectedLocale = this.localeSelectionBox.getValue(selectedIndex);
            for (String localeName : GWTLocaleUtil.getAvailableLocales()) {
                if (!selectedLocale.equals(localeName)) continue;
                result = localeName;
                break;
            }
        }
        return result;
    }

    private String getSelectedLeaderboardName() {
        String result = null;
        int selectedIndex = this.leaderboardSelectionBox.getSelectedIndex();
        if (selectedIndex > 0) {
            result = this.leaderboardSelectionBox.getItemText(selectedIndex);
        }
        return result;
    }

    private StrippedLeaderboardDTO getSelectedLeaderboard() {
        EventDTO selectedEvent = this.getSelectedEvent();
        String selectedLeaderboardName = this.getSelectedLeaderboardName();
        for (LeaderboardGroupDTO leaderboardGroup : selectedEvent.getLeaderboardGroups()) {
            for (StrippedLeaderboardDTO leaderboard : leaderboardGroup.getLeaderboards()) {
                if (!leaderboard.getName().equals(selectedLeaderboardName)) continue;
                return leaderboard;
            }
        }
        return null;
    }

    private EventDTO getSelectedEvent() {
        EventDTO result = null;
        int selectedIndex = this.eventSelectionBox.getSelectedIndex();
        if (this.events != null && selectedIndex > 0) {
            String selectedItemText = this.eventSelectionBox.getValue(selectedIndex);
            for (EventDTO event : this.events) {
                if (!event.getName().equals(selectedItemText)) continue;
                result = event;
                break;
            }
        }
        return result;
    }

    public void showLoading() {
        this.startAutoPlayButton.setEnabled(false);
    }

    static /* synthetic */ void access$0(AutoPlayStartViewImpl autoPlayStartViewImpl, PerspectiveCompositeSettings perspectiveCompositeSettings) {
        autoPlayStartViewImpl.settings = perspectiveCompositeSettings;
    }

    static /* synthetic */ void access$1(AutoPlayStartViewImpl autoPlayStartViewImpl, String string) {
        autoPlayStartViewImpl.updateURL(string);
    }
}

