/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.util;

import com.sap.sse.common.Util;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WildcardPermission;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.http.client.ClientProtocolException;
import org.json.simple.parser.ParseException;

public interface SecuredServer {
    public static final String SECURITY_API_PREFIX = "security/api";

    public URL getBaseUrl();

    public String getBearerToken();

    public UUID getUserGroupIdByName(String var1) throws MalformedURLException, ClientProtocolException, IOException, ParseException, IllegalAccessException;

    public Util.Pair<UUID, String> getGroupAndUserOwner(HasPermissions var1, TypeRelativeObjectIdentifier var2) throws ClientProtocolException, IOException, ParseException;

    public void setGroupAndUserOwner(HasPermissions var1, TypeRelativeObjectIdentifier var2, Optional<String> var3, Optional<UUID> var4, Optional<String> var5) throws MalformedURLException, ClientProtocolException, IOException, ParseException;

    public Iterable<Util.Pair<WildcardPermission, Boolean>> hasPermissions(Iterable<WildcardPermission> var1) throws UnsupportedEncodingException, MalformedURLException, ClientProtocolException, IOException, ParseException;

    public String getUsername() throws MalformedURLException, ClientProtocolException, IOException, ParseException;

    default public void addCurrentUserToGroup(UUID userGroupId) throws ClientProtocolException, IOException, ParseException {
        this.addUserToGroup(userGroupId, this.getUsername());
    }

    public void addUserToGroup(UUID var1, String var2) throws ClientProtocolException, IOException, ParseException;

    default public void removeCurrentUserFromGroup(UUID userGroupId) throws ClientProtocolException, MalformedURLException, IOException, ParseException {
        this.removeUserFromGroup(userGroupId, this.getUsername());
    }

    public void removeUserFromGroup(UUID var1, String var2) throws ClientProtocolException, IOException, ParseException;

    public UUID createUserGroupAndAddCurrentUser(String var1) throws ClientProtocolException, IOException, ParseException, IllegalAccessException;

    public Iterable<String> getNamesOfUsersInGroup(UUID var1) throws ClientProtocolException, IOException, ParseException;

    public void addRoleToUser(UUID var1, String var2, UUID var3, String var4, boolean var5) throws MalformedURLException, ClientProtocolException, IOException, ParseException;

    public Iterable<RoleDescriptor> getRoles(String var1) throws ClientProtocolException, IOException, ParseException;

    public Map<UUID, Set<String>> getAccessControlLists(HasPermissions var1, TypeRelativeObjectIdentifier var2) throws ClientProtocolException, IOException, ParseException;

    public void setAccessControlLists(HasPermissions var1, TypeRelativeObjectIdentifier var2, Map<UUID, Set<String>> var3) throws ClientProtocolException, IOException, ParseException;

    public static interface RoleDescriptor {
        public UUID getRoleDefinitionId();

        public UUID getQualifiedForGroupWithId();

        public String getQualifiedForUserWithName();

        public Boolean isTransitive();
    }
}

