/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.subscription.chargebee;

import com.chargebee.models.Subscription;
import com.sap.sse.security.shared.subscription.chargebee.ChargebeeSubscription;
import com.sap.sse.security.subscription.SubscriptionApiBaseService;
import com.sap.sse.security.subscription.SubscriptionApiRequestProcessor;
import com.sap.sse.security.subscription.SubscriptionNonRenewingResult;
import com.sap.sse.security.subscription.chargebee.ChargebeeApiSubscriptionData;
import com.sap.sse.security.subscription.chargebee.ChargebeeNonRenewingSubscriptionRequest;
import com.sap.sse.security.subscription.chargebee.ChargebeeSubscriptionRequest;
import java.util.logging.Logger;

public class ChargebeeNonRenewingSubscriptionTask
implements ChargebeeSubscriptionRequest.OnResultListener,
ChargebeeNonRenewingSubscriptionRequest.OnResultListener {
    private static final Logger logger = Logger.getLogger(ChargebeeNonRenewingSubscriptionTask.class.getName());
    private final String subscriptionId;
    private final SubscriptionApiRequestProcessor requestProcessor;
    private final OnResultListener listener;
    private final SubscriptionApiBaseService chargebeeApiServiceParams;

    public ChargebeeNonRenewingSubscriptionTask(String subscriptionId, SubscriptionApiRequestProcessor requestProcessor, OnResultListener listener, SubscriptionApiBaseService chargebeeApiServiceParams) {
        this.subscriptionId = subscriptionId;
        this.requestProcessor = requestProcessor;
        this.listener = listener;
        this.chargebeeApiServiceParams = chargebeeApiServiceParams;
    }

    public void run() {
        logger.info(() -> "Schedule setting Chargebee subscription to non renewing, id: " + this.subscriptionId);
        this.requestProcessor.addRequest(new ChargebeeSubscriptionRequest(this.subscriptionId, this, this.requestProcessor, this.chargebeeApiServiceParams));
    }

    @Override
    public void onSubscriptionResult(Subscription subscription) {
        if (subscription != null) {
            ChargebeeSubscription sub = new ChargebeeApiSubscriptionData(subscription, null, null).toSubscription(this.chargebeeApiServiceParams.getSubscriptionPlanProvider());
            String status = subscription.status().name();
            if (status != null) {
                status = status.toLowerCase();
            }
            if (sub.getSubscriptionStatus().equals("non_renewing")) {
                this.onDone(new SubscriptionNonRenewingResult(true, (com.sap.sse.security.shared.subscription.Subscription)sub));
            } else {
                this.requestProcessor.addRequest(new ChargebeeNonRenewingSubscriptionRequest(this.subscriptionId, this, this.requestProcessor, this.chargebeeApiServiceParams));
            }
        } else {
            this.onDone(new SubscriptionNonRenewingResult(false, null, true));
        }
    }

    @Override
    public void onSubscriptionNonRenewingResult(Subscription subscription) {
        if (subscription != null) {
            ChargebeeSubscription sub = new ChargebeeApiSubscriptionData(subscription, null, null).toSubscription(this.chargebeeApiServiceParams.getSubscriptionPlanProvider());
            boolean success = sub.getSubscriptionStatus().equals("non_renewing");
            this.onDone(new SubscriptionNonRenewingResult(success, (com.sap.sse.security.shared.subscription.Subscription)sub, false));
        } else {
            this.onDone(new SubscriptionNonRenewingResult(false, null, true));
        }
    }

    private void onDone(SubscriptionNonRenewingResult result) {
        logger.info("Setting subscription to non renewing is done with success = " + result.isSuccess() + ", deleted = " + result.isDeleted() + ", subscription = " + result.getSubscription());
        if (this.listener != null) {
            this.listener.onNonRenewingResult(result);
        }
    }

    @FunctionalInterface
    public static interface OnResultListener {
        public void onNonRenewingResult(SubscriptionNonRenewingResult var1);
    }
}

