/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.subscription;

import com.sap.sse.common.TimePoint;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.UserManagementException;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.subscription.Subscription;
import com.sap.sse.security.shared.subscription.SubscriptionPlan;
import com.sap.sse.security.subscription.SubscriptionApiService;
import com.sap.sse.security.subscription.SubscriptionData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProviderSubscriptionUpdateTask
implements SubscriptionApiService.OnSubscriptionsResultListener {
    private static final Logger logger = Logger.getLogger(ProviderSubscriptionUpdateTask.class.getName());
    private final SubscriptionApiService apiService;
    private final Iterable<User> users;
    private final CompletableFuture<SecurityService> securityService;

    public ProviderSubscriptionUpdateTask(SubscriptionApiService apiService, Iterable<User> users, CompletableFuture<SecurityService> securityService) {
        this.apiService = apiService;
        this.users = users;
        this.securityService = securityService;
    }

    public void run() {
        try {
            this.apiService.getUserSubscriptions(this);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Fetch subscriptions failed, provider: " + this.apiService.getProviderName(), e);
        }
    }

    @Override
    public void onSubscriptionsResult(Map<String, List<Subscription>> subscriptions) {
        if (subscriptions != null) {
            for (User user : this.users) {
                try {
                    this.checkAndUpdateSubscriptions(user, (Iterable<Subscription>)subscriptions.get(user.getName()), this.apiService);
                }
                catch (UserManagementException e) {
                    logger.log(Level.SEVERE, "Update user subscriptions failed, provider: " + this.apiService.getProviderName() + ", user: " + user.getName(), e);
                }
            }
        } else {
            logger.log(Level.SEVERE, "Update user subscriptions failed, provider: " + this.apiService.getProviderName());
        }
    }

    private void checkAndUpdateSubscriptions(User user, Iterable<Subscription> userSubscriptions, SubscriptionApiService provider) throws UserManagementException {
        logger.info(() -> "Subscriptions from provider " + provider.getProviderName() + " for user " + user.getName() + ": " + (userSubscriptions == null ? "empty" : userSubscriptions));
        this.getSecurityService().lockSubscriptionsForUser(user);
        try {
            Iterable currentSubscriptions = user.getSubscriptions();
            if ((userSubscriptions == null || !userSubscriptions.iterator().hasNext()) && currentSubscriptions != null && currentSubscriptions.iterator().hasNext()) {
                Subscription emptySubscription = this.createEmptySubscription(provider, null);
                this.getSecurityService().updateUserSubscription(user.getName(), emptySubscription);
            } else if (userSubscriptions != null) {
                if (currentSubscriptions != null) {
                    Map<String, Boolean> existingPlans = this.getExistingPlans(userSubscriptions);
                    for (Subscription subscription : currentSubscriptions) {
                        if (!subscription.hasPlan() || existingPlans.containsKey(subscription.getPlanId())) continue;
                        Subscription emptySubscription = this.createEmptySubscription(provider, subscription.getPlanId());
                        this.getSecurityService().updateUserSubscription(user.getName(), emptySubscription);
                    }
                }
                HashSet<Subscription> skimmedSubscriptions = new HashSet<Subscription>();
                for (SubscriptionPlan subscriptionPlan : this.getSecurityService().getAllSubscriptionPlans().values()) {
                    Subscription planSubscription = null;
                    for (Subscription userSubscription : userSubscriptions) {
                        boolean isSamePlan = subscriptionPlan.getId().equals(userSubscription.getPlanId());
                        if ((!isSamePlan || planSubscription != null) && (!isSamePlan || !userSubscription.isUpdatedMoreRecently(planSubscription))) continue;
                        planSubscription = userSubscription;
                    }
                    if (planSubscription == null) continue;
                    skimmedSubscriptions.add(planSubscription);
                }
                for (Subscription subscription : skimmedSubscriptions) {
                    this.getSecurityService().updateUserSubscription(user.getName(), subscription);
                }
            }
        }
        finally {
            this.getSecurityService().unlockSubscriptionsForUser(user);
        }
    }

    private Subscription createEmptySubscription(SubscriptionApiService provider, String planId) {
        return provider.getDataHandler().toSubscription(SubscriptionData.createEmptySubscriptionDataWithUpdateTimes(planId, TimePoint.now(), TimePoint.now()));
    }

    private Map<String, Boolean> getExistingPlans(Iterable<Subscription> subscriptions) {
        HashMap<String, Boolean> existingPlans = new HashMap<String, Boolean>();
        for (Subscription subscription : subscriptions) {
            if (!subscription.hasPlan()) continue;
            existingPlans.put(subscription.getPlanId(), true);
        }
        return existingPlans;
    }

    private SecurityService getSecurityService() {
        try {
            return this.securityService.get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.log(Level.SEVERE, "Failure to get SecurityService", e);
            throw new RuntimeException(e);
        }
    }
}

