/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.jaxrs.api;

import com.sap.sse.common.Util;
import com.sap.sse.security.jaxrs.AbstractSecurityResource;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.RoleDefinition;
import com.sap.sse.security.shared.UserGroupManagementException;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.Ownership;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.impl.UserGroup;
import com.sap.sse.security.shared.impl.UserGroupImpl;
import com.sun.jersey.api.client.ClientResponse;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

@Path(value="/restsecurity/usergroup")
public class UserGroupResource
extends AbstractSecurityResource {
    public static final String RESTSECURITY_USERGROUP = "/restsecurity/usergroup";
    public static final String KEY_ROLE_NAME = "roleName";
    public static final String KEY_FOR_ALL = "forAll";
    public static final String KEY_ROLE_ID = "roleId";
    public static final String KEY_USERNAME = "username";
    public static final String KEY_ROLES = "roles";
    public static final String KEY_USERS = "users";
    public static final String KEY_GROUP_NAME = "groupName";
    public static final String KEY_GROUP_ID = "groupId";
    public static final String USER = "/user";

    @Path(value="{groupId}")
    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getUserGroup(@PathParam(value="groupId") String userGroupId) {
        Response response;
        try {
            UUID groupId = UUID.fromString(userGroupId);
            UserGroup usergroup = this.getSecurityService().getUserGroup(groupId);
            response = this.handleExistingUserGroup(usergroup);
        }
        catch (IllegalArgumentException e) {
            response = Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"Invalid group id.").build();
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getUserGroupByName(@QueryParam(value="groupName") String userGroupName) {
        Response response;
        if (userGroupName != null) {
            UserGroup usergroup = this.getSecurityService().getUserGroupByName(userGroupName);
            response = this.handleExistingUserGroup(usergroup);
        } else {
            response = Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"Please specify a groupname.").build();
        }
        return response;
    }

    @GET
    @Path(value="list/groupsUserIsPartOf")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getUserGroupsCurrentUserIsPartOf() throws ParseException {
        Response response = null;
        User user = this.getSecurityService().getCurrentUser();
        if (user != null) {
            JSONObject root = new JSONObject();
            JSONArray groups = new JSONArray();
            root.put((Object)"groupsUserIsPartOf", (Object)groups);
            for (UserGroup group : user.getUserGroups()) {
                groups.add((Object)this.convertUserGroupToJson(group, false, false));
            }
            response = Response.ok((Object)this.streamingOutput(root)).build();
        } else {
            response = Response.status((int)401).build();
        }
        return response;
    }

    @GET
    @Path(value="list/readable")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getReadableUserGroupsForCurrentUser(@QueryParam(value="userName") String userName) {
        User user;
        Response response = null;
        User user2 = user = userName != null ? this.getSecurityService().getUserByName(userName) : this.getSecurityService().getCurrentUser();
        if (user != null && this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)user)) {
            ArrayList userGroups = new ArrayList();
            this.getSecurityService().getUserGroupList().forEach(ug -> {
                if (this.getSecurityService().getSecurityManager().isPermitted((PrincipalCollection)new SimplePrincipalCollection((Object)user.getName(), user.getName()), ug.getIdentifier().getPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ).toString())) {
                    userGroups.add(ug);
                }
            });
            JSONObject root = new JSONObject();
            JSONArray userGroupsJson = new JSONArray();
            userGroups.forEach(ug -> {
                boolean bl = userGroupsJson.add((Object)this.convertUserGroupToJson((UserGroup)ug, false, true));
            });
            response = Response.ok((Object)root.toJSONString()).build();
            root.put((Object)"readableGroups", (Object)userGroupsJson);
            response = Response.ok().entity((Object)this.streamingOutput(root)).build();
        } else {
            response = Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).build();
        }
        return response;
    }

    private Response handleExistingUserGroup(UserGroup usergroup) {
        Response response;
        if (usergroup == null) {
            response = Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"Usergroup with this id does not exist.").build();
        } else if (this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)usergroup)) {
            JSONObject jsonResult = this.convertUserGroupToJson(usergroup, true, true);
            response = Response.ok((Object)this.streamingOutput(jsonResult)).build();
        } else {
            response = Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).build();
        }
        return response;
    }

    private JSONObject convertUserGroupToJson(UserGroup usergroup, boolean includingUsers, boolean includingRoles) {
        JSONObject jsonResult = new JSONObject();
        jsonResult.put((Object)KEY_GROUP_ID, (Object)usergroup.getId().toString());
        jsonResult.put((Object)KEY_GROUP_NAME, (Object)usergroup.getName());
        if (includingUsers) {
            JSONArray jsonUsersInGroup = new JSONArray();
            for (User user : usergroup.getUsers()) {
                if (!this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)user)) continue;
                jsonUsersInGroup.add((Object)user.getId());
            }
            jsonResult.put((Object)KEY_USERS, (Object)jsonUsersInGroup);
        }
        if (includingRoles) {
            JSONArray jsonRolesOfGroup = new JSONArray();
            for (Map.Entry entry : usergroup.getRoleDefinitionMap().entrySet()) {
                if (!this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)entry.getKey())) continue;
                JSONObject roleJson = new JSONObject();
                roleJson.put((Object)KEY_ROLE_ID, (Object)((RoleDefinition)entry.getKey()).getId().toString());
                roleJson.put((Object)KEY_ROLE_NAME, (Object)((RoleDefinition)entry.getKey()).getName());
                roleJson.put((Object)KEY_FOR_ALL, entry.getValue());
                jsonRolesOfGroup.add((Object)roleJson);
            }
            jsonResult.put((Object)KEY_ROLES, (Object)jsonRolesOfGroup);
        }
        return jsonResult;
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response createUserGroup(String jsonBody) {
        Response response;
        JSONObject json = (JSONObject)JSONValue.parse((String)jsonBody);
        String groupName = (String)json.get((Object)KEY_GROUP_NAME);
        UserGroup existingUserGroup = this.getSecurityService().getUserGroupByName(groupName);
        if (existingUserGroup != null) {
            response = Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"Usergroup with this name already exists.").build();
        } else {
            UUID newTenantId = UUID.randomUUID();
            UserGroup group = this.getSecurityService().setOwnershipWithoutCheckPermissionForObjectCreationAndRevertOnError(SecuredSecurityTypes.USER_GROUP, UserGroupImpl.getTypeRelativeObjectIdentifier((UUID)newTenantId), groupName, () -> {
                UserGroup userGroup;
                try {
                    userGroup = this.getSecurityService().createUserGroup(newTenantId, groupName);
                }
                catch (UserGroupManagementException e) {
                    throw new UserGroupManagementException(e.getMessage());
                }
                return userGroup;
            });
            response = group == null ? Response.status((Response.StatusType)ClientResponse.Status.INTERNAL_SERVER_ERROR).entity((Object)"Could not create user group.").build() : Response.status((Response.StatusType)ClientResponse.Status.CREATED).entity((Object)this.streamingOutput(this.convertUserGroupToJson(group, true, true))).build();
        }
        return response;
    }

    @Path(value="{groupId}")
    @DELETE
    @Produces(value={"application/json;charset=UTF-8"})
    public Response deleteUserGroup(@PathParam(value="groupId") String userGroupId) {
        Response response;
        try {
            UUID groupId = UUID.fromString(userGroupId);
            UserGroup usergroup = this.getSecurityService().getUserGroup(groupId);
            if (usergroup == null) {
                response = Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"Usergroup with this name does not exist.").build();
            } else {
                this.getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval((WithQualifiedObjectIdentifier)usergroup, () -> this.getSecurityService().deleteUserGroup(usergroup));
                response = Response.status((Response.StatusType)ClientResponse.Status.NO_CONTENT).build();
            }
        }
        catch (IllegalArgumentException e) {
            response = Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"Invalid group id.").build();
        }
        return response;
    }

    @Path(value="{groupId}/user/{username}")
    @PUT
    @Produces(value={"application/json;charset=UTF-8"})
    public Response addUserToUserGroup(@PathParam(value="groupId") String userGroupId, @PathParam(value="username") String username) {
        Response response;
        try {
            UUID groupId = UUID.fromString(userGroupId);
            UserGroup usergroup = this.getSecurityService().getUserGroup(groupId);
            if (usergroup == null) {
                response = Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"Usergroup with this name does not exist.").build();
            } else {
                User user = this.getSecurityService().getUserByName(username);
                if (user == null) {
                    response = Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"User with this name does not exist.").build();
                } else if (this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)usergroup)) {
                    if (Util.contains((Iterable)usergroup.getUsers(), (Object)user)) {
                        response = Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"User is already in this group.").build();
                    } else if (this.getSecurityService().hasCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)usergroup)) {
                        if (!this.getSecurityService().hasCurrentUserMetaPermissionsOfRoleDefinitionsWithQualification(usergroup.getRoleDefinitionMap().keySet(), new Ownership(null, usergroup))) {
                            response = Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).build();
                        } else {
                            this.getSecurityService().addUserToUserGroup(usergroup, user);
                            response = Response.ok().build();
                        }
                    } else {
                        response = Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).build();
                    }
                } else {
                    response = Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).build();
                }
            }
        }
        catch (IllegalArgumentException e) {
            response = Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"Invalid group id.").build();
        }
        return response;
    }

    @Path(value="{groupId}/user/{username}")
    @DELETE
    @Produces(value={"application/json;charset=UTF-8"})
    public Response deleteUserFromUserGroup(@PathParam(value="groupId") String userGroupId, @PathParam(value="username") String username) {
        Response response;
        try {
            UUID groupId = UUID.fromString(userGroupId);
            UserGroup usergroup = this.getSecurityService().getUserGroup(groupId);
            if (usergroup == null) {
                response = Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"Usergroup with this name does not exist.").build();
            } else {
                User user = this.getSecurityService().getUserByName(username);
                if (user == null) {
                    response = Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"User with this name does not exist.").build();
                } else if (this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)usergroup)) {
                    if (!Util.contains((Iterable)usergroup.getUsers(), (Object)user)) {
                        response = Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"User is not in this group.").build();
                    } else if (this.getSecurityService().hasCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)usergroup)) {
                        this.getSecurityService().removeUserFromUserGroup(usergroup, user);
                        response = Response.status((Response.StatusType)ClientResponse.Status.NO_CONTENT).build();
                    } else {
                        response = Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).build();
                    }
                } else {
                    response = Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).build();
                }
            }
        }
        catch (IllegalArgumentException e) {
            response = Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"Invalid group id.").build();
        }
        return response;
    }

    @Path(value="{groupId}/role/{roleId}")
    @PUT
    @Produces(value={"application/json;charset=UTF-8"})
    public Response addRoleToUserGroup(@PathParam(value="groupId") String userGroupId, @PathParam(value="roleId") String roleIdString, String body) {
        Response response;
        try {
            UUID groupId = UUID.fromString(userGroupId);
            UUID roleId = UUID.fromString(roleIdString);
            UserGroup usergroup = this.getSecurityService().getUserGroup(groupId);
            if (usergroup == null) {
                response = Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)String.format("Usergroup with ID %s does not exist.", userGroupId)).build();
            } else {
                RoleDefinition role = this.getSecurityService().getRoleDefinition(roleId);
                if (role == null) {
                    response = Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)String.format("Role with ID %s does not exist.", roleId)).build();
                } else if (this.getSecurityService().hasCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)usergroup) && this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)role)) {
                    Boolean forAll = usergroup.getRoleAssociation(role);
                    JSONObject jsonBody = (JSONObject)JSONValue.parse((String)body);
                    boolean roleForAll = Boolean.valueOf((String)jsonBody.get((Object)KEY_FOR_ALL));
                    if (forAll == null || forAll != roleForAll) {
                        if (!this.getSecurityService().hasCurrentUserMetaPermissionsOfRoleDefinitionWithQualification(role, new Ownership(null, usergroup))) {
                            response = Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).entity((Object)String.format("Not permitted to add role %s to group %s", role.getName(), usergroup.getName())).build();
                        } else {
                            this.getSecurityService().putRoleDefinitionToUserGroup(usergroup, role, roleForAll);
                            response = Response.ok().build();
                        }
                    } else {
                        response = Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)String.format("Role %s was already added to group %s.", role.getName(), usergroup.getName())).build();
                    }
                } else {
                    response = Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).build();
                }
            }
        }
        catch (IllegalArgumentException e) {
            response = Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"Invalid role or group id.").build();
        }
        return response;
    }

    @Path(value="{groupId}/role/{roleId}")
    @DELETE
    @Produces(value={"application/json;charset=UTF-8"})
    public Response deleteRoleFromUserGroup(@PathParam(value="groupId") String userGroupId, @PathParam(value="roleId") String roleIdString) {
        Response response;
        try {
            UUID groupId = UUID.fromString(userGroupId);
            UserGroup usergroup = this.getSecurityService().getUserGroup(groupId);
            UUID roleId = UUID.fromString(roleIdString);
            if (usergroup == null) {
                response = Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"Usergroup with this name does not exist.").build();
            } else {
                RoleDefinition role = this.getSecurityService().getRoleDefinition(roleId);
                if (role == null) {
                    response = Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"Role with this id does not exist.").build();
                } else if (this.getSecurityService().hasCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)usergroup) && this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)role)) {
                    if (usergroup.getRoleAssociation(role) != null) {
                        if (!this.getSecurityService().hasCurrentUserMetaPermissionsOfRoleDefinitionWithQualification(role, new Ownership(null, usergroup))) {
                            response = Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).entity((Object)String.format("Not permitted to remove role %s from group", role.getName())).build();
                        } else {
                            this.getSecurityService().removeRoleDefintionFromUserGroup(usergroup, role);
                            response = Response.status((Response.StatusType)ClientResponse.Status.NO_CONTENT).build();
                        }
                    } else {
                        response = Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"Role is currently not added to the group.").build();
                    }
                } else {
                    response = Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).build();
                }
            }
        }
        catch (IllegalArgumentException e) {
            response = Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"Invalid role or group id.").build();
        }
        return response;
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="setDefaultTenantForCurrentServerAndUser")
    public Response setDefaultTenantForCurrentServerAndUser(@QueryParam(value="tenantGroup") UUID tenantId) throws ParseException {
        Response response = null;
        User user = this.getSecurityService().getCurrentUser();
        if (user != null) {
            this.getSecurityService().setDefaultTenantForCurrentServerForUser(user.getName(), tenantId);
            response = Response.ok().build();
        } else {
            response = Response.status((int)401).build();
        }
        return response;
    }

    @POST
    @Path(value="addAnyUserToGroup")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response addGroupToUserWithoutPermissionOnUser(@QueryParam(value="userName") String userName, @QueryParam(value="groupId") UUID userGroupId) {
        Response response = null;
        User user = this.getSecurityService().getUserByName(userName);
        if (user != null) {
            UserGroup userGroup = this.getSecurityService().getUserGroup(userGroupId);
            if (userGroup != null) {
                if (!Util.contains((Iterable)userGroup.getUsers(), (Object)user)) {
                    if (this.getSecurityService().hasCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)userGroup)) {
                        if (!this.getSecurityService().hasCurrentUserMetaPermissionsOfRoleDefinitionsWithQualification(userGroup.getRoleDefinitionMap().keySet(), new Ownership(null, userGroup))) {
                            response = Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).build();
                        } else {
                            this.getSecurityService().addUserToUserGroup(userGroup, user);
                            response = Response.ok().build();
                        }
                    } else {
                        response = Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).build();
                    }
                } else {
                    response = Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"User is already in this group.").build();
                }
            } else {
                response = Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"User Group does not exist.").build();
            }
        } else {
            response = Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"User does not exist.").build();
        }
        return response;
    }
}

