/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.userstore.mongodb.impl.sessionwrapper;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.ListSearchIndexesIterable;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropCollectionOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.SearchIndexModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertManyResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import java.util.List;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public class MongoCollectionWrapperWithClientSession<TDocument>
implements MongoCollection<TDocument> {
    private final MongoCollection<TDocument> delegate;
    private final ClientSession clientSession;

    public MongoCollectionWrapperWithClientSession(ClientSession clientSession, MongoCollection<TDocument> delegate) {
        this.delegate = delegate;
        this.clientSession = clientSession;
    }

    public MongoNamespace getNamespace() {
        return this.delegate.getNamespace();
    }

    public Class<TDocument> getDocumentClass() {
        return this.delegate.getDocumentClass();
    }

    public CodecRegistry getCodecRegistry() {
        return this.delegate.getCodecRegistry();
    }

    public ReadPreference getReadPreference() {
        return this.delegate.getReadPreference();
    }

    public WriteConcern getWriteConcern() {
        return this.delegate.getWriteConcern();
    }

    public ReadConcern getReadConcern() {
        return this.delegate.getReadConcern();
    }

    public <NewTDocument> MongoCollection<NewTDocument> withDocumentClass(Class<NewTDocument> clazz) {
        return this.wrap(this.delegate.withDocumentClass(clazz));
    }

    public MongoCollection<TDocument> withCodecRegistry(CodecRegistry codecRegistry) {
        return this.wrap(this.delegate.withCodecRegistry(codecRegistry));
    }

    public MongoCollection<TDocument> withReadPreference(ReadPreference readPreference) {
        return this.wrap(this.delegate.withReadPreference(readPreference));
    }

    public MongoCollection<TDocument> withWriteConcern(WriteConcern writeConcern) {
        return this.wrap(this.delegate.withWriteConcern(writeConcern));
    }

    public MongoCollection<TDocument> withReadConcern(ReadConcern readConcern) {
        return this.wrap(this.delegate.withReadConcern(readConcern));
    }

    public long countDocuments() {
        return this.delegate.countDocuments(this.clientSession);
    }

    public long countDocuments(Bson filter) {
        return this.delegate.countDocuments(this.clientSession, filter);
    }

    public long countDocuments(Bson filter, CountOptions options) {
        return this.delegate.countDocuments(this.clientSession, filter, options);
    }

    public long countDocuments(ClientSession clientSession) {
        return this.delegate.countDocuments(clientSession);
    }

    public long countDocuments(ClientSession clientSession, Bson filter) {
        return this.delegate.countDocuments(clientSession, filter);
    }

    public long countDocuments(ClientSession clientSession, Bson filter, CountOptions options) {
        return this.delegate.countDocuments(clientSession, filter, options);
    }

    public long estimatedDocumentCount() {
        return this.delegate.estimatedDocumentCount();
    }

    public long estimatedDocumentCount(EstimatedDocumentCountOptions options) {
        return this.delegate.estimatedDocumentCount(options);
    }

    public <TResult> DistinctIterable<TResult> distinct(String fieldName, Class<TResult> resultClass) {
        return this.delegate.distinct(this.clientSession, fieldName, resultClass);
    }

    public <TResult> DistinctIterable<TResult> distinct(String fieldName, Bson filter, Class<TResult> resultClass) {
        return this.delegate.distinct(this.clientSession, fieldName, filter, resultClass);
    }

    public <TResult> DistinctIterable<TResult> distinct(ClientSession clientSession, String fieldName, Class<TResult> resultClass) {
        return this.delegate.distinct(clientSession, fieldName, resultClass);
    }

    public <TResult> DistinctIterable<TResult> distinct(ClientSession clientSession, String fieldName, Bson filter, Class<TResult> resultClass) {
        return this.delegate.distinct(clientSession, fieldName, filter, resultClass);
    }

    public FindIterable<TDocument> find() {
        return this.delegate.find(this.clientSession);
    }

    public <TResult> FindIterable<TResult> find(Class<TResult> resultClass) {
        return this.delegate.find(this.clientSession, resultClass);
    }

    public FindIterable<TDocument> find(Bson filter) {
        return this.delegate.find(this.clientSession, filter);
    }

    public <TResult> FindIterable<TResult> find(Bson filter, Class<TResult> resultClass) {
        return this.delegate.find(this.clientSession, filter, resultClass);
    }

    public FindIterable<TDocument> find(ClientSession clientSession) {
        return this.delegate.find(clientSession);
    }

    public <TResult> FindIterable<TResult> find(ClientSession clientSession, Class<TResult> resultClass) {
        return this.delegate.find(clientSession, resultClass);
    }

    public FindIterable<TDocument> find(ClientSession clientSession, Bson filter) {
        return this.delegate.find(clientSession, filter);
    }

    public <TResult> FindIterable<TResult> find(ClientSession clientSession, Bson filter, Class<TResult> resultClass) {
        return this.delegate.find(clientSession, filter, resultClass);
    }

    public AggregateIterable<TDocument> aggregate(List<? extends Bson> pipeline) {
        return this.delegate.aggregate(this.clientSession, pipeline);
    }

    public <TResult> AggregateIterable<TResult> aggregate(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.delegate.aggregate(this.clientSession, pipeline, resultClass);
    }

    public AggregateIterable<TDocument> aggregate(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.delegate.aggregate(clientSession, pipeline);
    }

    public <TResult> AggregateIterable<TResult> aggregate(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.delegate.aggregate(clientSession, pipeline, resultClass);
    }

    public ChangeStreamIterable<TDocument> watch() {
        return this.delegate.watch(this.clientSession);
    }

    public <TResult> ChangeStreamIterable<TResult> watch(Class<TResult> resultClass) {
        return this.delegate.watch(this.clientSession, resultClass);
    }

    public ChangeStreamIterable<TDocument> watch(List<? extends Bson> pipeline) {
        return this.delegate.watch(this.clientSession, pipeline);
    }

    public <TResult> ChangeStreamIterable<TResult> watch(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.delegate.watch(this.clientSession, pipeline, resultClass);
    }

    public ChangeStreamIterable<TDocument> watch(ClientSession clientSession) {
        return this.delegate.watch(clientSession);
    }

    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, Class<TResult> resultClass) {
        return this.delegate.watch(clientSession, resultClass);
    }

    public ChangeStreamIterable<TDocument> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.delegate.watch(clientSession, pipeline);
    }

    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.delegate.watch(clientSession, pipeline, resultClass);
    }

    public MapReduceIterable<TDocument> mapReduce(String mapFunction, String reduceFunction) {
        return this.delegate.mapReduce(this.clientSession, mapFunction, reduceFunction);
    }

    public <TResult> MapReduceIterable<TResult> mapReduce(String mapFunction, String reduceFunction, Class<TResult> resultClass) {
        return this.delegate.mapReduce(this.clientSession, mapFunction, reduceFunction, resultClass);
    }

    public MapReduceIterable<TDocument> mapReduce(ClientSession clientSession, String mapFunction, String reduceFunction) {
        return this.delegate.mapReduce(clientSession, mapFunction, reduceFunction);
    }

    public <TResult> MapReduceIterable<TResult> mapReduce(ClientSession clientSession, String mapFunction, String reduceFunction, Class<TResult> resultClass) {
        return this.delegate.mapReduce(clientSession, mapFunction, reduceFunction, resultClass);
    }

    public BulkWriteResult bulkWrite(List<? extends WriteModel<? extends TDocument>> requests) {
        return this.delegate.bulkWrite(this.clientSession, requests);
    }

    public BulkWriteResult bulkWrite(List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options) {
        return this.delegate.bulkWrite(this.clientSession, requests, options);
    }

    public BulkWriteResult bulkWrite(ClientSession clientSession, List<? extends WriteModel<? extends TDocument>> requests) {
        return this.delegate.bulkWrite(clientSession, requests);
    }

    public BulkWriteResult bulkWrite(ClientSession clientSession, List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options) {
        return this.delegate.bulkWrite(clientSession, requests, options);
    }

    public InsertOneResult insertOne(TDocument document) {
        return this.delegate.insertOne(this.clientSession, document);
    }

    public InsertOneResult insertOne(TDocument document, InsertOneOptions options) {
        return this.delegate.insertOne(this.clientSession, document, options);
    }

    public InsertOneResult insertOne(ClientSession clientSession, TDocument document) {
        return this.delegate.insertOne(clientSession, document);
    }

    public InsertOneResult insertOne(ClientSession clientSession, TDocument document, InsertOneOptions options) {
        return this.delegate.insertOne(clientSession, document, options);
    }

    public InsertManyResult insertMany(List<? extends TDocument> documents) {
        return this.delegate.insertMany(this.clientSession, documents);
    }

    public InsertManyResult insertMany(List<? extends TDocument> documents, InsertManyOptions options) {
        return this.delegate.insertMany(this.clientSession, documents, options);
    }

    public InsertManyResult insertMany(ClientSession clientSession, List<? extends TDocument> documents) {
        return this.delegate.insertMany(clientSession, documents);
    }

    public InsertManyResult insertMany(ClientSession clientSession, List<? extends TDocument> documents, InsertManyOptions options) {
        return this.delegate.insertMany(clientSession, documents, options);
    }

    public DeleteResult deleteOne(Bson filter) {
        return this.delegate.deleteOne(this.clientSession, filter);
    }

    public DeleteResult deleteOne(Bson filter, DeleteOptions options) {
        return this.delegate.deleteOne(this.clientSession, filter, options);
    }

    public DeleteResult deleteOne(ClientSession clientSession, Bson filter) {
        return this.delegate.deleteOne(clientSession, filter);
    }

    public DeleteResult deleteOne(ClientSession clientSession, Bson filter, DeleteOptions options) {
        return this.delegate.deleteOne(clientSession, filter, options);
    }

    public DeleteResult deleteMany(Bson filter) {
        return this.delegate.deleteMany(this.clientSession, filter);
    }

    public DeleteResult deleteMany(Bson filter, DeleteOptions options) {
        return this.delegate.deleteMany(this.clientSession, filter, options);
    }

    public DeleteResult deleteMany(ClientSession clientSession, Bson filter) {
        return this.delegate.deleteMany(clientSession, filter);
    }

    public DeleteResult deleteMany(ClientSession clientSession, Bson filter, DeleteOptions options) {
        return this.delegate.deleteMany(clientSession, filter, options);
    }

    public UpdateResult replaceOne(Bson filter, TDocument replacement) {
        return this.delegate.replaceOne(this.clientSession, filter, replacement);
    }

    public UpdateResult replaceOne(Bson filter, TDocument replacement, ReplaceOptions replaceOptions) {
        return this.delegate.replaceOne(this.clientSession, filter, replacement, replaceOptions);
    }

    public UpdateResult replaceOne(ClientSession clientSession, Bson filter, TDocument replacement) {
        return this.delegate.replaceOne(clientSession, filter, replacement);
    }

    public UpdateResult replaceOne(ClientSession clientSession, Bson filter, TDocument replacement, ReplaceOptions replaceOptions) {
        return this.delegate.replaceOne(clientSession, filter, replacement, replaceOptions);
    }

    public UpdateResult updateOne(Bson filter, Bson update) {
        return this.delegate.updateOne(this.clientSession, filter, update);
    }

    public UpdateResult updateOne(Bson filter, Bson update, UpdateOptions updateOptions) {
        return this.delegate.updateOne(this.clientSession, filter, update, updateOptions);
    }

    public UpdateResult updateOne(ClientSession clientSession, Bson filter, Bson update) {
        return this.delegate.updateOne(clientSession, filter, update);
    }

    public UpdateResult updateOne(ClientSession clientSession, Bson filter, Bson update, UpdateOptions updateOptions) {
        return this.delegate.updateOne(clientSession, filter, update, updateOptions);
    }

    public UpdateResult updateOne(Bson filter, List<? extends Bson> update) {
        return this.delegate.updateOne(this.clientSession, filter, update);
    }

    public UpdateResult updateOne(Bson filter, List<? extends Bson> update, UpdateOptions updateOptions) {
        return this.delegate.updateOne(this.clientSession, filter, update, updateOptions);
    }

    public UpdateResult updateOne(ClientSession clientSession, Bson filter, List<? extends Bson> update) {
        return this.delegate.updateOne(clientSession, filter, update);
    }

    public UpdateResult updateOne(ClientSession clientSession, Bson filter, List<? extends Bson> update, UpdateOptions updateOptions) {
        return this.delegate.updateOne(clientSession, filter, update, updateOptions);
    }

    public UpdateResult updateMany(Bson filter, Bson update) {
        return this.delegate.updateMany(this.clientSession, filter, update);
    }

    public UpdateResult updateMany(Bson filter, Bson update, UpdateOptions updateOptions) {
        return this.delegate.updateMany(this.clientSession, filter, update, updateOptions);
    }

    public UpdateResult updateMany(ClientSession clientSession, Bson filter, Bson update) {
        return this.delegate.updateMany(clientSession, filter, update);
    }

    public UpdateResult updateMany(ClientSession clientSession, Bson filter, Bson update, UpdateOptions updateOptions) {
        return this.delegate.updateMany(clientSession, filter, update, updateOptions);
    }

    public UpdateResult updateMany(Bson filter, List<? extends Bson> update) {
        return this.delegate.updateMany(this.clientSession, filter, update);
    }

    public UpdateResult updateMany(Bson filter, List<? extends Bson> update, UpdateOptions updateOptions) {
        return this.delegate.updateMany(this.clientSession, filter, update, updateOptions);
    }

    public UpdateResult updateMany(ClientSession clientSession, Bson filter, List<? extends Bson> update) {
        return this.delegate.updateMany(clientSession, filter, update);
    }

    public UpdateResult updateMany(ClientSession clientSession, Bson filter, List<? extends Bson> update, UpdateOptions updateOptions) {
        return this.delegate.updateMany(clientSession, filter, update, updateOptions);
    }

    public TDocument findOneAndDelete(Bson filter) {
        return (TDocument)this.delegate.findOneAndDelete(this.clientSession, filter);
    }

    public TDocument findOneAndDelete(Bson filter, FindOneAndDeleteOptions options) {
        return (TDocument)this.delegate.findOneAndDelete(this.clientSession, filter, options);
    }

    public TDocument findOneAndDelete(ClientSession clientSession, Bson filter) {
        return (TDocument)this.delegate.findOneAndDelete(clientSession, filter);
    }

    public TDocument findOneAndDelete(ClientSession clientSession, Bson filter, FindOneAndDeleteOptions options) {
        return (TDocument)this.delegate.findOneAndDelete(clientSession, filter, options);
    }

    public TDocument findOneAndReplace(Bson filter, TDocument replacement) {
        return (TDocument)this.delegate.findOneAndReplace(this.clientSession, filter, replacement);
    }

    public TDocument findOneAndReplace(Bson filter, TDocument replacement, FindOneAndReplaceOptions options) {
        return (TDocument)this.delegate.findOneAndReplace(this.clientSession, filter, replacement, options);
    }

    public TDocument findOneAndReplace(ClientSession clientSession, Bson filter, TDocument replacement) {
        return (TDocument)this.delegate.findOneAndReplace(clientSession, filter, replacement);
    }

    public TDocument findOneAndReplace(ClientSession clientSession, Bson filter, TDocument replacement, FindOneAndReplaceOptions options) {
        return (TDocument)this.delegate.findOneAndReplace(clientSession, filter, replacement, options);
    }

    public TDocument findOneAndUpdate(Bson filter, Bson update) {
        return (TDocument)this.delegate.findOneAndUpdate(this.clientSession, filter, update);
    }

    public TDocument findOneAndUpdate(Bson filter, Bson update, FindOneAndUpdateOptions options) {
        return (TDocument)this.delegate.findOneAndUpdate(this.clientSession, filter, update, options);
    }

    public TDocument findOneAndUpdate(ClientSession clientSession, Bson filter, Bson update) {
        return (TDocument)this.delegate.findOneAndUpdate(clientSession, filter, update);
    }

    public TDocument findOneAndUpdate(ClientSession clientSession, Bson filter, Bson update, FindOneAndUpdateOptions options) {
        return (TDocument)this.delegate.findOneAndUpdate(clientSession, filter, update, options);
    }

    public TDocument findOneAndUpdate(Bson filter, List<? extends Bson> update) {
        return (TDocument)this.delegate.findOneAndUpdate(this.clientSession, filter, update);
    }

    public TDocument findOneAndUpdate(Bson filter, List<? extends Bson> update, FindOneAndUpdateOptions options) {
        return (TDocument)this.delegate.findOneAndUpdate(this.clientSession, filter, update, options);
    }

    public TDocument findOneAndUpdate(ClientSession clientSession, Bson filter, List<? extends Bson> update) {
        return (TDocument)this.delegate.findOneAndUpdate(clientSession, filter, update);
    }

    public TDocument findOneAndUpdate(ClientSession clientSession, Bson filter, List<? extends Bson> update, FindOneAndUpdateOptions options) {
        return (TDocument)this.delegate.findOneAndUpdate(clientSession, filter, update, options);
    }

    public void drop() {
        this.delegate.drop(this.clientSession);
    }

    public void drop(ClientSession clientSession) {
        this.delegate.drop(clientSession);
    }

    public void drop(DropCollectionOptions dropCollectionOptions) {
        this.delegate.drop(this.clientSession, dropCollectionOptions);
    }

    public void drop(ClientSession clientSession, DropCollectionOptions dropCollectionOptions) {
        this.delegate.drop(clientSession, dropCollectionOptions);
    }

    public String createSearchIndex(String indexName, Bson definition) {
        return this.delegate.createSearchIndex(indexName, definition);
    }

    public String createSearchIndex(Bson definition) {
        return this.delegate.createSearchIndex(definition);
    }

    public List<String> createSearchIndexes(List<SearchIndexModel> searchIndexModels) {
        return this.delegate.createSearchIndexes(searchIndexModels);
    }

    public void updateSearchIndex(String indexName, Bson definition) {
        this.delegate.updateSearchIndex(indexName, definition);
    }

    public void dropSearchIndex(String indexName) {
        this.delegate.dropSearchIndex(indexName);
    }

    public ListSearchIndexesIterable<Document> listSearchIndexes() {
        return this.delegate.listSearchIndexes();
    }

    public <TResult> ListSearchIndexesIterable<TResult> listSearchIndexes(Class<TResult> resultClass) {
        return this.delegate.listSearchIndexes(resultClass);
    }

    public String createIndex(Bson keys) {
        return this.delegate.createIndex(this.clientSession, keys);
    }

    public String createIndex(Bson keys, IndexOptions indexOptions) {
        return this.delegate.createIndex(this.clientSession, keys, indexOptions);
    }

    public String createIndex(ClientSession clientSession, Bson keys) {
        return this.delegate.createIndex(clientSession, keys);
    }

    public String createIndex(ClientSession clientSession, Bson keys, IndexOptions indexOptions) {
        return this.delegate.createIndex(clientSession, keys, indexOptions);
    }

    public List<String> createIndexes(List<IndexModel> indexes) {
        return this.delegate.createIndexes(this.clientSession, indexes);
    }

    public List<String> createIndexes(List<IndexModel> indexes, CreateIndexOptions createIndexOptions) {
        return this.delegate.createIndexes(this.clientSession, indexes, createIndexOptions);
    }

    public List<String> createIndexes(ClientSession clientSession, List<IndexModel> indexes) {
        return this.delegate.createIndexes(clientSession, indexes);
    }

    public List<String> createIndexes(ClientSession clientSession, List<IndexModel> indexes, CreateIndexOptions createIndexOptions) {
        return this.delegate.createIndexes(clientSession, indexes, createIndexOptions);
    }

    public ListIndexesIterable<Document> listIndexes() {
        return this.delegate.listIndexes(this.clientSession);
    }

    public <TResult> ListIndexesIterable<TResult> listIndexes(Class<TResult> resultClass) {
        return this.delegate.listIndexes(this.clientSession, resultClass);
    }

    public ListIndexesIterable<Document> listIndexes(ClientSession clientSession) {
        return this.delegate.listIndexes(clientSession);
    }

    public <TResult> ListIndexesIterable<TResult> listIndexes(ClientSession clientSession, Class<TResult> resultClass) {
        return this.delegate.listIndexes(clientSession, resultClass);
    }

    public void dropIndex(String indexName) {
        this.delegate.dropIndex(this.clientSession, indexName);
    }

    public void dropIndex(String indexName, DropIndexOptions dropIndexOptions) {
        this.delegate.dropIndex(this.clientSession, indexName, dropIndexOptions);
    }

    public void dropIndex(Bson keys) {
        this.delegate.dropIndex(this.clientSession, keys);
    }

    public void dropIndex(Bson keys, DropIndexOptions dropIndexOptions) {
        this.delegate.dropIndex(this.clientSession, keys, dropIndexOptions);
    }

    public void dropIndex(ClientSession clientSession, String indexName) {
        this.delegate.dropIndex(clientSession, indexName);
    }

    public void dropIndex(ClientSession clientSession, Bson keys) {
        this.delegate.dropIndex(clientSession, keys);
    }

    public void dropIndex(ClientSession clientSession, String indexName, DropIndexOptions dropIndexOptions) {
        this.delegate.dropIndex(clientSession, indexName, dropIndexOptions);
    }

    public void dropIndex(ClientSession clientSession, Bson keys, DropIndexOptions dropIndexOptions) {
        this.delegate.dropIndex(clientSession, keys, dropIndexOptions);
    }

    public void dropIndexes() {
        this.delegate.dropIndexes(this.clientSession);
    }

    public void dropIndexes(ClientSession clientSession) {
        this.delegate.dropIndexes(clientSession);
    }

    public void dropIndexes(DropIndexOptions dropIndexOptions) {
        this.delegate.dropIndexes(this.clientSession, dropIndexOptions);
    }

    public void dropIndexes(ClientSession clientSession, DropIndexOptions dropIndexOptions) {
        this.delegate.dropIndexes(clientSession, dropIndexOptions);
    }

    public void renameCollection(MongoNamespace newCollectionNamespace) {
        this.delegate.renameCollection(this.clientSession, newCollectionNamespace);
    }

    public void renameCollection(MongoNamespace newCollectionNamespace, RenameCollectionOptions renameCollectionOptions) {
        this.delegate.renameCollection(this.clientSession, newCollectionNamespace, renameCollectionOptions);
    }

    public void renameCollection(ClientSession clientSession, MongoNamespace newCollectionNamespace) {
        this.delegate.renameCollection(clientSession, newCollectionNamespace);
    }

    public void renameCollection(ClientSession clientSession, MongoNamespace newCollectionNamespace, RenameCollectionOptions renameCollectionOptions) {
        this.delegate.renameCollection(clientSession, newCollectionNamespace, renameCollectionOptions);
    }

    private <T> MongoCollection<T> wrap(MongoCollection<T> collection) {
        return new MongoCollectionWrapperWithClientSession<T>(this.clientSession, collection);
    }
}

