/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.userstore.mongodb;

import com.sap.sse.common.Util;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import com.sap.sse.concurrent.RunnableWithResult;
import com.sap.sse.security.interfaces.AccessControlStore;
import com.sap.sse.security.interfaces.UserStore;
import com.sap.sse.security.shared.AccessControlListAnnotation;
import com.sap.sse.security.shared.OwnershipAnnotation;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.SecurityUserGroup;
import com.sap.sse.security.shared.impl.AccessControlList;
import com.sap.sse.security.shared.impl.Ownership;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.impl.UserGroup;
import com.sap.sse.security.shared.impl.UserGroupImpl;
import com.sap.sse.security.userstore.mongodb.DomainObjectFactory;
import com.sap.sse.security.userstore.mongodb.MongoObjectFactory;
import com.sap.sse.security.userstore.mongodb.PersistenceFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AccessControlStoreImpl
implements AccessControlStore {
    private static final long serialVersionUID = 2165649781000936074L;
    private String name = "Access control store";
    private final ConcurrentHashMap<QualifiedObjectIdentifier, AccessControlListAnnotation> accessControlLists = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Map<UserGroup, Set<QualifiedObjectIdentifier>>> accessControlListsWithDenials = new ConcurrentHashMap();
    private final ConcurrentHashMap<QualifiedObjectIdentifier, OwnershipAnnotation> ownerships = new ConcurrentHashMap();
    private final ConcurrentHashMap<User, Set<OwnershipAnnotation>> userToOwnership = new ConcurrentHashMap();
    private final ConcurrentHashMap<UserGroup, Set<OwnershipAnnotation>> userGroupToOwnership = new ConcurrentHashMap();
    private final ConcurrentHashMap<UserGroup, Set<AccessControlListAnnotation>> userGroupToAccessControlListAnnotation = new ConcurrentHashMap();
    private static final UserGroupImpl NULL_GROUP = new UserGroupImpl(null, "<null group>");
    private final NamedReentrantReadWriteLock lockForManagementMappings = new NamedReentrantReadWriteLock("ownershipLock", true);
    private final transient MongoObjectFactory mongoObjectFactory;
    private final transient DomainObjectFactory domainObjectFactory;
    private final transient UserStore userStore;

    public AccessControlStoreImpl(UserStore userStore) {
        this(PersistenceFactory.INSTANCE.getDefaultDomainObjectFactory(), PersistenceFactory.INSTANCE.getDefaultMongoObjectFactory(), userStore);
    }

    public AccessControlStoreImpl(DomainObjectFactory domainObjectFactory, MongoObjectFactory mongoObjectFactory, UserStore userStore) {
        this.mongoObjectFactory = mongoObjectFactory;
        this.domainObjectFactory = domainObjectFactory;
        this.userStore = userStore;
    }

    public void loadACLsAndOwnerships() {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.lockForManagementMappings, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (AccessControlStoreImpl.this.domainObjectFactory != null) {
                    for (AccessControlListAnnotation acl : AccessControlStoreImpl.this.domainObjectFactory.loadAllAccessControlLists(AccessControlStoreImpl.this.userStore)) {
                        AccessControlStoreImpl.this.internalAddACL(acl);
                    }
                    for (OwnershipAnnotation ownership : AccessControlStoreImpl.this.domainObjectFactory.loadAllOwnerships(AccessControlStoreImpl.this.userStore)) {
                        AccessControlStoreImpl.this.internalSetOwnershipAndMapUserAndUserGroupToOwnership(ownership);
                    }
                }
            }
        });
    }

    private void internalAddACL(AccessControlListAnnotation acl) {
        assert (this.lockForManagementMappings.isWriteLockedByCurrentThread());
        this.accessControlLists.put(acl.getIdOfAnnotatedObject(), acl);
        for (UserGroup owner : ((AccessControlList)acl.getAnnotation()).getActionsByUserGroup().keySet()) {
            this.internalMapUserGroupToACL(owner, acl);
        }
    }

    public Iterable<AccessControlListAnnotation> getAccessControlLists() {
        return (Iterable)LockUtil.executeWithReadLockAndResult((NamedReentrantReadWriteLock)this.lockForManagementMappings, (RunnableWithResult)new RunnableWithResult<Iterable<AccessControlListAnnotation>>(){

            public Iterable<AccessControlListAnnotation> run() {
                return new ArrayList<AccessControlListAnnotation>(AccessControlStoreImpl.this.accessControlLists.values());
            }
        });
    }

    public AccessControlListAnnotation getAccessControlList(final QualifiedObjectIdentifier idOfAccessControlledObjectAsString) {
        return (AccessControlListAnnotation)LockUtil.executeWithReadLockAndResult((NamedReentrantReadWriteLock)this.lockForManagementMappings, (RunnableWithResult)new RunnableWithResult<AccessControlListAnnotation>(){

            public AccessControlListAnnotation run() {
                return (AccessControlListAnnotation)AccessControlStoreImpl.this.accessControlLists.get(idOfAccessControlledObjectAsString);
            }
        });
    }

    public AccessControlListAnnotation setEmptyAccessControlList(final QualifiedObjectIdentifier idOfAccessControlledObject, final String displayNameOfAccessControlledObject) {
        return (AccessControlListAnnotation)LockUtil.executeWithWriteLockAndResult((NamedReentrantReadWriteLock)this.lockForManagementMappings, (RunnableWithResult)new RunnableWithResult<AccessControlListAnnotation>(){

            public AccessControlListAnnotation run() {
                AccessControlStoreImpl.this.removeAccessControlList(idOfAccessControlledObject);
                AccessControlListAnnotation acl = new AccessControlListAnnotation(new AccessControlList(), idOfAccessControlledObject, displayNameOfAccessControlledObject);
                AccessControlStoreImpl.this.accessControlLists.put(idOfAccessControlledObject, acl);
                AccessControlStoreImpl.this.mongoObjectFactory.storeAccessControlList(acl);
                return acl;
            }
        });
    }

    public void setAclPermissions(final QualifiedObjectIdentifier idOfAccessControlledObject, final UserGroup userGroup, final Set<String> actions) {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.lockForManagementMappings, (Runnable)new Runnable(){

            @Override
            public void run() {
                AccessControlListAnnotation acl = AccessControlStoreImpl.this.getOrCreateAclInternal(idOfAccessControlledObject);
                ((AccessControlList)acl.getAnnotation()).setPermissions((SecurityUserGroup)userGroup, actions);
                AccessControlStoreImpl.this.mongoObjectFactory.storeAccessControlList(acl);
                AccessControlStoreImpl.this.internalMapUserGroupToACL(userGroup, acl);
            }
        });
    }

    private AccessControlListAnnotation getOrCreateAclInternal(QualifiedObjectIdentifier idOfAccessControlledObject) {
        assert (this.lockForManagementMappings.isWriteLockedByCurrentThread());
        return this.accessControlLists.computeIfAbsent(idOfAccessControlledObject, id -> new AccessControlListAnnotation(new AccessControlList(), id, null));
    }

    public AccessControlListAnnotation getOrCreateAcl(QualifiedObjectIdentifier idOfAccessControlledObject) {
        return (AccessControlListAnnotation)LockUtil.executeWithWriteLockAndResult((NamedReentrantReadWriteLock)this.lockForManagementMappings, () -> this.getOrCreateAclInternal(idOfAccessControlledObject));
    }

    public void addAclPermission(final QualifiedObjectIdentifier idOfAccessControlledObject, final UserGroup userGroup, final String action) {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.lockForManagementMappings, (Runnable)new Runnable(){

            @Override
            public void run() {
                AccessControlListAnnotation acl = AccessControlStoreImpl.this.getOrCreateAclInternal(idOfAccessControlledObject);
                ((AccessControlList)acl.getAnnotation()).addPermission((SecurityUserGroup)userGroup, action);
                AccessControlStoreImpl.this.internalMapUserGroupToACL(userGroup, acl);
                AccessControlStoreImpl.this.mongoObjectFactory.storeAccessControlList(acl);
            }
        });
    }

    public void removeAclPermission(final QualifiedObjectIdentifier idOfAccessControlledObjectAsString, final UserGroup userGroup, final String action) {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.lockForManagementMappings, (Runnable)new Runnable(){

            @Override
            public void run() {
                AccessControlListAnnotation acl = AccessControlStoreImpl.this.getOrCreateAclInternal(idOfAccessControlledObjectAsString);
                if (((AccessControlList)acl.getAnnotation()).removePermission((SecurityUserGroup)userGroup, action)) {
                    AccessControlStoreImpl.this.internalRemoveUserGroupToACLMapping(userGroup, acl);
                    AccessControlStoreImpl.this.mongoObjectFactory.storeAccessControlList(acl);
                }
            }
        });
    }

    private void internalMapUserGroupToACL(UserGroup userGroup, AccessControlListAnnotation acl) {
        if (!this.lockForManagementMappings.isWriteLockedByCurrentThread()) {
            throw new IllegalStateException("Current thread has no write lock!");
        }
        Object effectiveUserGroup = userGroup == null ? NULL_GROUP : userGroup;
        Set<Object> currentACLsContainingGroup = this.userGroupToAccessControlListAnnotation.get(effectiveUserGroup);
        if (currentACLsContainingGroup == null) {
            currentACLsContainingGroup = Collections.newSetFromMap(new ConcurrentHashMap());
            this.userGroupToAccessControlListAnnotation.put((UserGroup)effectiveUserGroup, currentACLsContainingGroup);
        }
        currentACLsContainingGroup.add(acl);
        String type = acl.getIdOfAnnotatedObject().getTypeIdentifier();
        Map<UserGroup, Set<QualifiedObjectIdentifier>> aclsByGroupForType = this.accessControlListsWithDenials.get(type);
        Set deniedActions = ((AccessControlList)acl.getAnnotation()).getDeniedActions(userGroup);
        if (deniedActions == null || deniedActions.isEmpty()) {
            if (aclsByGroupForType != null) {
                Util.removeFromValueSet(aclsByGroupForType, (Object)userGroup, (Object)acl.getIdOfAnnotatedObject());
            }
        } else if (aclsByGroupForType == null) {
            aclsByGroupForType = new HashMap<UserGroup, Set<QualifiedObjectIdentifier>>();
            this.accessControlListsWithDenials.put(type, aclsByGroupForType);
            Util.addToValueSet(aclsByGroupForType, (Object)userGroup, (Object)acl.getIdOfAnnotatedObject());
        }
    }

    private void internalRemoveUserGroupToACLMapping(UserGroup userGroup, AccessControlListAnnotation acl) {
        String typeIdentifier;
        Map<UserGroup, Set<QualifiedObjectIdentifier>> aclsByGroupForEvent;
        if (!this.lockForManagementMappings.isWriteLockedByCurrentThread()) {
            throw new IllegalStateException("Current thread has no write lock!");
        }
        Object effectiveUserGroup = userGroup == null ? NULL_GROUP : userGroup;
        Set<AccessControlListAnnotation> currentACLsContainingGroup = this.userGroupToAccessControlListAnnotation.get(effectiveUserGroup);
        if (currentACLsContainingGroup != null) {
            currentACLsContainingGroup.remove(acl);
            if (currentACLsContainingGroup.isEmpty()) {
                this.userGroupToAccessControlListAnnotation.remove(effectiveUserGroup);
            }
        }
        if ((aclsByGroupForEvent = this.accessControlListsWithDenials.get(typeIdentifier = acl.getIdOfAnnotatedObject().getTypeIdentifier())) != null) {
            aclsByGroupForEvent.remove(userGroup);
            if (aclsByGroupForEvent.isEmpty()) {
                this.accessControlListsWithDenials.remove(typeIdentifier);
            }
        }
    }

    public void removeAccessControlList(final QualifiedObjectIdentifier idOfAccessControlledObject) {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.lockForManagementMappings, (Runnable)new Runnable(){

            @Override
            public void run() {
                AccessControlListAnnotation acl = (AccessControlListAnnotation)AccessControlStoreImpl.this.accessControlLists.remove(idOfAccessControlledObject);
                if (acl != null) {
                    for (UserGroup userGroup : ((AccessControlList)acl.getAnnotation()).getActionsByUserGroup().keySet()) {
                        AccessControlStoreImpl.this.internalRemoveUserGroupToACLMapping(userGroup, acl);
                    }
                    AccessControlStoreImpl.this.mongoObjectFactory.deleteAccessControlList(idOfAccessControlledObject, (AccessControlList)acl.getAnnotation());
                }
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public OwnershipAnnotation setOwnership(QualifiedObjectIdentifier id, User userOwnerName, UserGroup tenantOwner, String displayNameOfOwnedObject) {
        final OwnershipAnnotation ownership = new OwnershipAnnotation(new Ownership(userOwnerName, tenantOwner), id, displayNameOfOwnedObject);
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.lockForManagementMappings, (Runnable)new Runnable(){

            @Override
            public void run() {
                AccessControlStoreImpl.this.removeUserAndUserGroupToOwnershipMapping(ownership);
                AccessControlStoreImpl.this.internalSetOwnershipAndMapUserAndUserGroupToOwnership(ownership);
            }
        });
        this.mongoObjectFactory.storeOwnership(ownership);
        return ownership;
    }

    private void internalSetOwnershipAndMapUserAndUserGroupToOwnership(OwnershipAnnotation ownership) {
        User userOwnerName;
        this.ownerships.put(ownership.getIdOfAnnotatedObject(), ownership);
        UserGroup tenantOwner = (UserGroup)((Ownership)ownership.getAnnotation()).getTenantOwner();
        if (tenantOwner != null) {
            Set<Object> currentGroupOwnerships = this.userGroupToOwnership.get(tenantOwner);
            if (currentGroupOwnerships == null) {
                currentGroupOwnerships = Collections.newSetFromMap(new ConcurrentHashMap());
                this.userGroupToOwnership.put(tenantOwner, currentGroupOwnerships);
            }
            currentGroupOwnerships.add(ownership);
        }
        if ((userOwnerName = (User)((Ownership)ownership.getAnnotation()).getUserOwner()) != null) {
            Set<Object> currentUserOwnerships = this.userToOwnership.get(userOwnerName);
            if (currentUserOwnerships == null) {
                currentUserOwnerships = Collections.newSetFromMap(new ConcurrentHashMap());
                this.userToOwnership.put(userOwnerName, currentUserOwnerships);
            }
            currentUserOwnerships.add(ownership);
        }
    }

    public void removeOwnership(final QualifiedObjectIdentifier id) {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.lockForManagementMappings, (Runnable)new Runnable(){

            @Override
            public void run() {
                OwnershipAnnotation ownership = (OwnershipAnnotation)AccessControlStoreImpl.this.ownerships.remove(id);
                if (ownership != null) {
                    AccessControlStoreImpl.this.removeUserAndUserGroupToOwnershipMapping(ownership);
                    AccessControlStoreImpl.this.mongoObjectFactory.deleteOwnership(id, (Ownership)ownership.getAnnotation());
                }
            }
        });
    }

    private void removeUserAndUserGroupToOwnershipMapping(OwnershipAnnotation ownership) {
        Set<OwnershipAnnotation> currentUserOwnerships;
        User userKey;
        Set<OwnershipAnnotation> currentGroupOwnerships;
        UserGroup userGroupKey = (UserGroup)((Ownership)ownership.getAnnotation()).getTenantOwner();
        if (userGroupKey != null && (currentGroupOwnerships = this.userGroupToOwnership.get(userGroupKey)) != null) {
            currentGroupOwnerships.remove(ownership);
            if (currentGroupOwnerships.isEmpty()) {
                this.userGroupToOwnership.remove(((Ownership)ownership.getAnnotation()).getTenantOwner());
            }
        }
        if ((userKey = (User)((Ownership)ownership.getAnnotation()).getUserOwner()) != null && (currentUserOwnerships = this.userToOwnership.get(((Ownership)ownership.getAnnotation()).getUserOwner())) != null) {
            currentUserOwnerships.remove(ownership);
            if (currentUserOwnerships.isEmpty()) {
                this.userToOwnership.remove(((Ownership)ownership.getAnnotation()).getUserOwner());
            }
        }
    }

    public Iterable<OwnershipAnnotation> getOwnerhipsWithGroupOwner(UserGroup owningUserGroup) {
        Set<OwnershipAnnotation> ownerships = this.userGroupToOwnership.get(owningUserGroup);
        return ownerships == null ? Collections.emptySet() : Collections.unmodifiableCollection(ownerships);
    }

    public OwnershipAnnotation getOwnership(final QualifiedObjectIdentifier idOfOwnedObjectAsString) {
        return (OwnershipAnnotation)LockUtil.executeWithReadLockAndResult((NamedReentrantReadWriteLock)this.lockForManagementMappings, (RunnableWithResult)new RunnableWithResult<OwnershipAnnotation>(){

            public OwnershipAnnotation run() {
                return (OwnershipAnnotation)AccessControlStoreImpl.this.ownerships.get(idOfOwnedObjectAsString);
            }
        });
    }

    public Iterable<OwnershipAnnotation> getOwnerships() {
        return (Iterable)LockUtil.executeWithReadLockAndResult((NamedReentrantReadWriteLock)this.lockForManagementMappings, (RunnableWithResult)new RunnableWithResult<Iterable<OwnershipAnnotation>>(){

            public Iterable<OwnershipAnnotation> run() {
                return new ArrayList<OwnershipAnnotation>(AccessControlStoreImpl.this.ownerships.values());
            }
        });
    }

    public void clear() {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.lockForManagementMappings, (Runnable)new Runnable(){

            @Override
            public void run() {
                AccessControlStoreImpl.this.mongoObjectFactory.deleteAllOwnerships();
                AccessControlStoreImpl.this.mongoObjectFactory.deleteAllAccessControlLists();
                AccessControlStoreImpl.this.removeAll();
            }
        });
    }

    private void removeAll() {
        this.accessControlLists.clear();
        this.accessControlListsWithDenials.clear();
        this.ownerships.clear();
        this.userGroupToAccessControlListAnnotation.clear();
        this.userGroupToOwnership.clear();
        this.userToOwnership.clear();
    }

    public void replaceContentsFrom(final AccessControlStore newAccessControlStore) {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.lockForManagementMappings, (Runnable)new Runnable(){

            @Override
            public void run() {
                AccessControlStoreImpl.this.clear();
                for (AccessControlListAnnotation acl : newAccessControlStore.getAccessControlLists()) {
                    AccessControlStoreImpl.this.internalAddACL(acl);
                }
                for (OwnershipAnnotation ownership : newAccessControlStore.getOwnerships()) {
                    AccessControlStoreImpl.this.internalSetOwnershipAndMapUserAndUserGroupToOwnership(ownership);
                }
            }
        });
    }

    public Set<AccessControlListAnnotation> getAccessControlListsForGroup(UserGroup group) {
        Set<AccessControlListAnnotation> aclsForGroup = this.userGroupToAccessControlListAnnotation.get(group);
        return aclsForGroup == null ? null : Collections.unmodifiableSet(aclsForGroup);
    }

    public Map<UserGroup, Set<QualifiedObjectIdentifier>> getAccessControlListsWithDenials(String typeIdentifier) {
        Map<UserGroup, Set<QualifiedObjectIdentifier>> aclsForType = this.accessControlListsWithDenials.get(typeIdentifier);
        return aclsForType == null ? null : Collections.unmodifiableMap(aclsForType);
    }

    public void removeAllOwnershipsFor(UserGroup userGroup) {
        UserGroupImpl effectiveUserGroup = userGroup == null ? NULL_GROUP : userGroup;
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.lockForManagementMappings, (Runnable)new Runnable((UserGroup)effectiveUserGroup){
            private final /* synthetic */ UserGroup val$effectiveUserGroup;
            {
                this.val$effectiveUserGroup = userGroup;
            }

            @Override
            public void run() {
                Set knownACLEntries;
                Set knownOwnerships = (Set)AccessControlStoreImpl.this.userGroupToOwnership.get(this.val$effectiveUserGroup);
                if (knownOwnerships != null) {
                    for (OwnershipAnnotation ownership : knownOwnerships) {
                        OwnershipAnnotation groupLessOwnership = new OwnershipAnnotation(new Ownership((User)((Ownership)ownership.getAnnotation()).getUserOwner(), null), ownership.getIdOfAnnotatedObject(), ownership.getDisplayNameOfAnnotatedObject());
                        AccessControlStoreImpl.this.ownerships.put(ownership.getIdOfAnnotatedObject(), groupLessOwnership);
                        AccessControlStoreImpl.this.mongoObjectFactory.storeOwnership(groupLessOwnership);
                    }
                    AccessControlStoreImpl.this.userGroupToOwnership.remove(this.val$effectiveUserGroup);
                }
                if ((knownACLEntries = (Set)AccessControlStoreImpl.this.userGroupToAccessControlListAnnotation.get(this.val$effectiveUserGroup)) != null) {
                    for (AccessControlListAnnotation accessControlListAnnotation : knownACLEntries) {
                        ((AccessControlList)accessControlListAnnotation.getAnnotation()).setPermissions((SecurityUserGroup)this.val$effectiveUserGroup, Collections.emptySet());
                        AccessControlStoreImpl.this.internalRemoveUserGroupToACLMapping(this.val$effectiveUserGroup, accessControlListAnnotation);
                        AccessControlStoreImpl.this.mongoObjectFactory.storeAccessControlList(accessControlListAnnotation);
                    }
                    AccessControlStoreImpl.this.userGroupToAccessControlListAnnotation.remove(this.val$effectiveUserGroup);
                    for (Map.Entry entry : AccessControlStoreImpl.this.accessControlListsWithDenials.entrySet()) {
                        ((Map)entry.getValue()).remove(this.val$effectiveUserGroup);
                    }
                }
            }
        });
    }

    public void removeAllOwnershipsFor(final User user) {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.lockForManagementMappings, (Runnable)new Runnable(){

            @Override
            public void run() {
                Set knownOwnerships = (Set)AccessControlStoreImpl.this.userToOwnership.get(user);
                if (knownOwnerships != null) {
                    for (OwnershipAnnotation ownership : knownOwnerships) {
                        OwnershipAnnotation userLessOwnership = new OwnershipAnnotation(new Ownership(null, (UserGroup)((Ownership)ownership.getAnnotation()).getTenantOwner()), ownership.getIdOfAnnotatedObject(), ownership.getDisplayNameOfAnnotatedObject());
                        AccessControlStoreImpl.this.ownerships.put(ownership.getIdOfAnnotatedObject(), userLessOwnership);
                        AccessControlStoreImpl.this.mongoObjectFactory.storeOwnership(userLessOwnership);
                    }
                    AccessControlStoreImpl.this.userToOwnership.remove(user);
                }
            }
        });
    }
}

