/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.persistence.impl;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.security.persistence.DomainObjectFactory;
import com.sap.sse.security.persistence.impl.CollectionNames;
import com.sap.sse.security.persistence.impl.FieldNames;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.bson.Document;
import org.bson.conversions.Bson;

public class DomainObjectFactoryImpl
implements DomainObjectFactory {
    private static final Logger logger = Logger.getLogger(DomainObjectFactoryImpl.class.getName());
    private final MongoCollection<Document> sessionsCollection;
    private final MongoCollection<Document> corsFilterConfigurationsCollection;

    public DomainObjectFactoryImpl(MongoDatabase mongoDatabase) {
        this.sessionsCollection = mongoDatabase.getCollection(CollectionNames.SESSIONS.name());
        this.corsFilterConfigurationsCollection = mongoDatabase.getCollection(CollectionNames.CORS_FILTER_CONFIGURATIONS.name());
    }

    @Override
    public Map<String, Set<Session>> loadSessionsByCacheName() {
        HashMap<String, Set<Session>> sessionsByCacheName = new HashMap<String, Set<Session>>();
        HashSet expiredSessionIds = new HashSet();
        this.sessionsCollection.find().forEach(sessionDocument -> {
            String cacheName = sessionDocument.getString((Object)FieldNames.CACHE_NAME.name());
            Session session = this.loadSession((Document)sessionDocument);
            if (!session.getAttributeKeys().isEmpty()) {
                if (new MillisecondsTimePoint(session.getLastAccessTime()).plus((Duration)new MillisecondsDurationImpl(session.getTimeout())).before(MillisecondsTimePoint.now())) {
                    logger.info("Session " + session + " expired");
                    expiredSessionIds.add(session.getId());
                } else {
                    Util.addToValueSet((Map)sessionsByCacheName, (Object)cacheName, (Object)session);
                }
            }
        });
        Document filter = new Document("$in", (Object)Util.map(expiredSessionIds, id -> id.toString()));
        this.sessionsCollection.deleteMany((Bson)new Document(FieldNames.SESSION_ID.name(), (Object)filter));
        return sessionsByCacheName;
    }

    private Session loadSession(Document sessionDocument) {
        SimpleSession result;
        if (sessionDocument == null) {
            result = null;
        } else {
            result = new SimpleSession();
            result.setId((Serializable)sessionDocument.get((Object)FieldNames.SESSION_ID.name()));
            result.setHost(sessionDocument.getString((Object)FieldNames.SESSION_HOST.name()));
            result.setLastAccessTime(sessionDocument.getDate((Object)FieldNames.SESSION_LAST_ACCESS_TIME.name()));
            result.setStartTimestamp(sessionDocument.getDate((Object)FieldNames.SESSION_START_TIMESTAMP.name()));
            result.setTimeout(sessionDocument.getLong((Object)FieldNames.SESSION_TIMEOUT.name()).longValue());
            Iterable sessionAttributes = (Iterable)sessionDocument.get((Object)FieldNames.SESSION_ATTRIBUTES.name(), Iterable.class);
            for (Document sessionAttributeDocument : sessionAttributes) {
                Object value = sessionAttributeDocument.get((Object)FieldNames.SESSION_ATTRIBUTE_VALUE.name());
                if (value instanceof Iterable) {
                    SimplePrincipalCollection principalCollection = new SimplePrincipalCollection();
                    ((Iterable)value).forEach(realmDocument -> {
                        if (realmDocument instanceof Document) {
                            String realmName = ((Document)realmDocument).getString((Object)FieldNames.SESSION_PRINCIPAL_REALM_NAME.name());
                            Iterable principalList = (Iterable)((Document)realmDocument).get((Object)FieldNames.SESSION_PRINCIPAL_REALM_VALUE.name());
                            for (Object principal : principalList) {
                                principalCollection.add(principal, realmName);
                            }
                        }
                    });
                    result.setAttribute((Object)sessionAttributeDocument.getString((Object)FieldNames.SESSION_ATTRIBUTE_NAME.name()), (Object)principalCollection);
                    continue;
                }
                if (value instanceof Document) continue;
                result.setAttribute((Object)sessionAttributeDocument.getString((Object)FieldNames.SESSION_ATTRIBUTE_NAME.name()), value);
            }
        }
        return result;
    }

    @Override
    public Map<String, Util.Pair<Boolean, Set<String>>> loadCORSFilterConfigurationsForReplicaSetNames() {
        HashMap<String, Util.Pair<Boolean, Set<String>>> result = new HashMap<String, Util.Pair<Boolean, Set<String>>>();
        for (Document d : this.corsFilterConfigurationsCollection.find()) {
            String serverName = d.getString((Object)FieldNames.CORS_FILTER_CONFIGURATION_SERVER_NAME.name());
            boolean isWildcard = d.getBoolean((Object)FieldNames.CORS_FILTER_CONFIGURATION_IS_WILDCARD.name());
            List allowedOrigins = isWildcard ? Collections.emptyList() : d.getList((Object)FieldNames.CORS_FILTER_CONFIGURATION_ALLOWED_ORIGINS.name(), String.class);
            result.put(serverName, (Util.Pair<Boolean, Set<String>>)new Util.Pair((Object)isWildcard, (Object)Util.asNewSet((Iterable)allowedOrigins)));
        }
        return result;
    }
}

