/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.statistics;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindTrack;
import com.sap.sailing.server.statistics.TrackedRaceStatistics;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.Iterator;
import java.util.NavigableSet;

public class TrackedRaceStatisticsCalculator {
    private final boolean calculateMaxSpeed;
    private final boolean calculateDistanceTravelled;
    private long numberOfGPSFixes;
    private long numberOfWindFixes;
    private Distance totalDistanceTraveled = Distance.NULL;
    private Util.Triple<Competitor, Speed, TimePoint> maxSpeed = null;
    private final TimePoint now = MillisecondsTimePoint.now();

    public TrackedRaceStatisticsCalculator(TrackedRace trackedRace, boolean calculateMaxSpeed, boolean calculateDistanceTravelled) {
        this.calculateMaxSpeed = calculateMaxSpeed;
        this.calculateDistanceTravelled = calculateDistanceTravelled;
        for (Competitor competitor : trackedRace.getRace().getCompetitors()) {
            this.doForCompetitor(trackedRace, competitor);
        }
        for (Mark mark : trackedRace.getMarks()) {
            this.doForMark(trackedRace, mark);
        }
        for (WindSource windSource : trackedRace.getWindSources()) {
            this.doForWindSource(trackedRace, windSource);
        }
    }

    private void doForCompetitor(TrackedRace trackedRace, Competitor competitor) {
        GPSFixTrack competitorTrack = trackedRace.getTrack(competitor);
        this.numberOfGPSFixes += (long)competitorTrack.size();
        if ((this.calculateDistanceTravelled || this.calculateMaxSpeed) && trackedRace.hasStarted(this.now)) {
            NavigableSet competitorMarkPassings = trackedRace.getMarkPassings(competitor);
            MarkPassing lastMarkPassingBeforeNow = null;
            trackedRace.lockForRead((Iterable)competitorMarkPassings);
            try {
                MarkPassing next = null;
                Iterator i = competitorMarkPassings.descendingIterator();
                while (i.hasNext() && (next = (MarkPassing)i.next()).getTimePoint().after(this.now)) {
                }
                if (next != null) {
                    lastMarkPassingBeforeNow = next;
                }
            }
            finally {
                trackedRace.unlockAfterRead((Iterable)competitorMarkPassings);
            }
            if (lastMarkPassingBeforeNow != null) {
                TimePoint from = trackedRace.getStartOfRace();
                TimePoint to = lastMarkPassingBeforeNow.getTimePoint();
                this.doForCompetitorTrackAndTimeRange(competitor, (GPSFixTrack<Competitor, GPSFixMoving>)competitorTrack, from, to);
            }
        }
    }

    private void doForCompetitorTrackAndTimeRange(Competitor competitor, GPSFixTrack<Competitor, GPSFixMoving> competitorTrack, TimePoint from, TimePoint to) {
        Util.Pair competitorMaxSpeed;
        if (this.calculateDistanceTravelled) {
            this.totalDistanceTraveled = this.totalDistanceTraveled.add(competitorTrack.getDistanceTraveled(from, to));
        }
        if (this.calculateMaxSpeed && (competitorMaxSpeed = competitorTrack.getMaximumSpeedOverGround(from, to)) != null && (this.maxSpeed == null || ((Speed)competitorMaxSpeed.getB()).compareTo((Object)((Speed)this.maxSpeed.getB())) > 0)) {
            this.maxSpeed = new Util.Triple((Object)competitor, (Object)((Speed)competitorMaxSpeed.getB()), (Object)((GPSFixMoving)competitorMaxSpeed.getA()).getTimePoint());
        }
    }

    private void doForMark(TrackedRace trackedRace, Mark mark) {
        GPSFixTrack markTrack = trackedRace.getOrCreateTrack(mark);
        this.numberOfGPSFixes += (long)markTrack.size();
    }

    private void doForWindSource(TrackedRace trackedRace, WindSource windSource) {
        if (windSource.canBeStored() || windSource.getType() == WindSourceType.RACECOMMITTEE) {
            WindTrack windTrack = trackedRace.getOrCreateWindTrack(windSource);
            this.numberOfWindFixes += (long)windTrack.size();
        }
    }

    public long getNumberOfGPSFixes() {
        return this.numberOfGPSFixes;
    }

    public long getNumberOfWindFixes() {
        return this.numberOfWindFixes;
    }

    public Distance getTotalDistanceTraveled() {
        return this.totalDistanceTraveled;
    }

    public Util.Triple<Competitor, Speed, TimePoint> getMaxSpeed() {
        return this.maxSpeed;
    }

    public TrackedRaceStatistics getStatistics() {
        return new TrackedRaceStatistics(this.getNumberOfGPSFixes(), this.getNumberOfWindFixes(), this.getTotalDistanceTraveled(), this.getMaxSpeed());
    }
}

