/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.impl.RaceColumnListenerWithDefaultAction;
import com.sap.sailing.domain.racelog.RaceLogIdentifier;
import com.sap.sailing.domain.regattalike.FlexibleLeaderboardAsRegattaLikeIdentifier;
import com.sap.sailing.domain.regattalike.RegattaAsRegattaLikeIdentifier;
import com.sap.sailing.domain.regattalike.RegattaLikeIdentifierResolver;
import com.sap.sailing.server.Replicator;
import com.sap.sailing.server.operationaltransformation.RecordRaceLogEventOnLeaderboard;
import com.sap.sailing.server.operationaltransformation.RecordRaceLogEventOnRegatta;
import com.sap.sse.replication.OperationWithResult;

public class RaceLogReplicatorAndNotifier
implements RaceColumnListenerWithDefaultAction {
    private static final long serialVersionUID = 7190510926643574068L;
    private final Replicator service;

    public RaceLogReplicatorAndNotifier(Replicator service) {
        this.service = service;
    }

    public void raceLogEventAdded(final RaceColumn raceColumn, final RaceLogIdentifier identifier, final RaceLogEvent event) {
        identifier.getRegattaLikeParent().resolve(new RegattaLikeIdentifierResolver(){

            public void resolveOnRegattaIdentifier(RegattaAsRegattaLikeIdentifier regattaLikeParent) {
                RecordRaceLogEventOnRegatta operation = new RecordRaceLogEventOnRegatta(regattaLikeParent.getName(), raceColumn.getName(), identifier.getFleetName(), event);
                RaceLogReplicatorAndNotifier.this.service.replicate((OperationWithResult)operation);
            }

            public void resolveOnFlexibleLeaderboardIdentifier(FlexibleLeaderboardAsRegattaLikeIdentifier regattaLikeParent) {
                RecordRaceLogEventOnLeaderboard operation = new RecordRaceLogEventOnLeaderboard(regattaLikeParent.getName(), raceColumn.getName(), identifier.getFleetName(), event);
                RaceLogReplicatorAndNotifier.this.service.replicate((OperationWithResult)operation);
            }
        });
    }

    public boolean isTransient() {
        return true;
    }

    public void defaultAction() {
    }
}

