/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.impl;

import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.server.LeaderboardMXBean;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import java.util.Map;
import java.util.TreeMap;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class LeaderboardMXBeanImpl
implements LeaderboardMXBean {
    private static final long serialVersionUID = -8420830339429971378L;
    private final Leaderboard leaderboard;

    public LeaderboardMXBeanImpl(Leaderboard leaderboard) {
        this.leaderboard = leaderboard;
    }

    public Leaderboard getLeaderboard() {
        return this.leaderboard;
    }

    @Override
    public ObjectName getObjectName() throws MalformedObjectNameException {
        return new ObjectName("com.sap.sailing:type=Leaderboard,name=" + ObjectName.quote(this.leaderboard.getName()));
    }

    public String getName() {
        return this.leaderboard.getName();
    }

    @Override
    public int getNumberOfCompetitors() {
        return Util.size((Iterable)this.leaderboard.getCompetitors());
    }

    @Override
    public int getNumberOfAllCompetitors() {
        return Util.size((Iterable)this.leaderboard.getAllCompetitors());
    }

    @Override
    public String getDisplayName() {
        return this.leaderboard.getDisplayName();
    }

    @Override
    public String getType() {
        return this.leaderboard.getLeaderboardType().name();
    }

    @Override
    public long getDelayToLiveInMillis() {
        return this.leaderboard.getDelayToLiveInMillis() == null ? -1L : this.leaderboard.getDelayToLiveInMillis();
    }

    @Override
    public String getBoatClass() {
        return this.leaderboard.getBoatClass().getName();
    }

    @Override
    public LeaderboardMXBean.ComputationTimeAverage getComputationTimeAverageYoung() {
        return this.getComputationTimeAverages(0);
    }

    @Override
    public LeaderboardMXBean.ComputationTimeAverage getComputationTimeAverageMedium() {
        return this.getComputationTimeAverages(1);
    }

    @Override
    public LeaderboardMXBean.ComputationTimeAverage getComputationTimeAverageOld() {
        return this.getComputationTimeAverages(2);
    }

    private LeaderboardMXBean.ComputationTimeAverage getComputationTimeAverages(int indexInStatsSortedByAscendingSampleDuration) {
        TreeMap computationTimeStatistics = new TreeMap(this.getLeaderboard().getComputationTimeStatistics());
        Map.Entry e = (Map.Entry)Util.get(computationTimeStatistics.entrySet(), (int)indexInStatsSortedByAscendingSampleDuration);
        ComputationTimeAverageImpl result = new ComputationTimeAverageImpl(((Duration)e.getKey()).asMillis(), ((Util.Pair)e.getValue()).getA() == null ? -1L : ((Duration)((Util.Pair)e.getValue()).getA()).asMillis(), (Integer)((Util.Pair)e.getValue()).getB());
        return result;
    }

    public static class ComputationTimeAverageImpl
    implements LeaderboardMXBean.ComputationTimeAverage {
        private final long averageRangeInMillis;
        private final long averageComputeDurationInMillis;
        private final int numberOfComputations;

        public ComputationTimeAverageImpl(long averageRangeInMillis, long averageComputeDurationInMillis, int numberOfComputations) {
            this.averageRangeInMillis = averageRangeInMillis;
            this.averageComputeDurationInMillis = averageComputeDurationInMillis;
            this.numberOfComputations = numberOfComputations;
        }

        @Override
        public long getAverageRangeInMillis() {
            return this.averageRangeInMillis;
        }

        @Override
        public long getAverageComputeDurationInMillis() {
            return this.averageComputeDurationInMillis;
        }

        @Override
        public int getNumberOfComputations() {
            return this.numberOfComputations;
        }
    }
}

