/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.anniversary;

import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.TrackedRaceStatusEnum;
import com.sap.sailing.domain.tracking.AbstractTrackedRegattaAndRaceObserver;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.RaceChangeListener;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRaceStatus;
import com.sap.sailing.domain.tracking.impl.AbstractRaceChangeListener;
import com.sap.sailing.server.anniversary.AnniversaryRaceDeterminatorImpl;
import com.sap.sse.common.TimePoint;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class RaceChangeObserverForAnniversaryDetection
extends AbstractTrackedRegattaAndRaceObserver {
    private final Map<TrackedRace, Listener> listeners;
    private final AnniversaryRaceDeterminatorImpl anniversaryRaceDeterminator;
    private final AtomicBoolean stopped;

    public RaceChangeObserverForAnniversaryDetection(AnniversaryRaceDeterminatorImpl anniversaryRaceDeterminator) {
        this.anniversaryRaceDeterminator = anniversaryRaceDeterminator;
        this.listeners = new ConcurrentHashMap<TrackedRace, Listener>();
        this.stopped = new AtomicBoolean(!anniversaryRaceDeterminator.isEnabled());
    }

    protected void onRaceAdded(RegattaAndRaceIdentifier raceIdentifier, DynamicTrackedRegatta trackedRegatta, DynamicTrackedRace trackedRace) {
        if (!this.stopped.get() && !this.handleRaceChange((TrackedRace)trackedRace)) {
            Listener listener = new Listener((TrackedRace)trackedRace);
            this.listeners.put((TrackedRace)trackedRace, listener);
            trackedRace.addListener((RaceChangeListener)listener);
        }
    }

    protected void onRaceRemoved(DynamicTrackedRace trackedRace) {
        this.removeListener((TrackedRace)trackedRace);
        this.fireUpdateIfNotStopped();
    }

    private void removeListener(TrackedRace trackedRace) {
        Listener listener = this.listeners.remove(trackedRace);
        if (listener != null) {
            trackedRace.removeListener((RaceChangeListener)listener);
        }
    }

    private boolean handleRaceChange(TrackedRace trackedRace) {
        if (trackedRace.hasGPSData() && trackedRace.getStartOfRace() != null) {
            this.fireUpdateIfNotStopped();
            return true;
        }
        return false;
    }

    private void handleRaceChangeAndRemoveListenerIfNoLongerNeeded(TrackedRace trackedRace) {
        TrackedRaceStatusEnum trackedRaceStatus = trackedRace.getStatus().getStatus();
        if (this.handleRaceChange(trackedRace) || trackedRaceStatus == TrackedRaceStatusEnum.FINISHED || trackedRaceStatus == TrackedRaceStatusEnum.REMOVED) {
            this.removeListener(trackedRace);
        }
    }

    private void fireUpdateIfNotStopped() {
        if (!this.stopped.get()) {
            this.anniversaryRaceDeterminator.update();
        }
    }

    public void stop() {
        this.stopped.set(true);
        this.removeAll();
    }

    public void clear() {
        this.removeAll();
    }

    private class Listener
    extends AbstractRaceChangeListener {
        private final TrackedRace trackedRace;

        public Listener(TrackedRace trackedRace) {
            this.trackedRace = trackedRace;
        }

        public void statusChanged(TrackedRaceStatus newStatus, TrackedRaceStatus oldStatus) {
            RaceChangeObserverForAnniversaryDetection.this.handleRaceChangeAndRemoveListenerIfNoLongerNeeded(this.trackedRace);
        }

        public void startOfRaceChanged(TimePoint oldStartOfRace, TimePoint newStartOfRace) {
            RaceChangeObserverForAnniversaryDetection.this.handleRaceChangeAndRemoveListenerIfNoLongerNeeded(this.trackedRace);
        }

        public void firstGPSFixReceived() {
            RaceChangeObserverForAnniversaryDetection.this.handleRaceChangeAndRemoveListenerIfNoLongerNeeded(this.trackedRace);
        }
    }
}

