/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.replication.impl;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.ConsumerCancelledException;
import com.rabbitmq.client.QueueingConsumer;
import com.rabbitmq.client.ShutdownSignalException;
import com.sap.sse.common.impl.NamedImpl;
import com.sap.sse.replication.impl.RabbitOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RabbitInputStreamProvider
extends NamedImpl {
    private static final Logger logger = Logger.getLogger(RabbitInputStreamProvider.class.getName());
    private static final long serialVersionUID = 1342935135386887494L;
    private final PipedInputStream clientReadsFromThis;
    private final PipedOutputStream messagesAreWrittenToThis;

    public RabbitInputStreamProvider(Channel channel, String queueName) throws IOException {
        this(channel, queueName, UUID.randomUUID().toString());
    }

    public RabbitInputStreamProvider(Channel channel, String queueName, String name) throws IOException {
        super(name);
        assert (name != null);
        this.messagesAreWrittenToThis = new PipedOutputStream();
        this.clientReadsFromThis = new PipedInputStream(this.messagesAreWrittenToThis);
        final QueueingConsumer messageConsumer = new QueueingConsumer(channel);
        channel.basicConsume(queueName, true, (Consumer)messageConsumer);
        new Thread(((Object)((Object)this)).getClass().getSimpleName()){

            @Override
            public void run() {
                block4: while (true) {
                    try {
                        while (true) {
                            QueueingConsumer.Delivery delivery;
                            byte[] bytesFromMessage;
                            if (RabbitOutputStream.startsWithTerminationCommand(bytesFromMessage = (delivery = messageConsumer.nextDelivery()).getBody(), bytesFromMessage.length)) {
                                if (bytesFromMessage.length == RabbitOutputStream.TERMINATION_COMMAND.length) {
                                    RabbitInputStreamProvider.this.messagesAreWrittenToThis.close();
                                    break block4;
                                }
                                byte[] newBytesFromMessage = new byte[bytesFromMessage.length - 1];
                                System.arraycopy(bytesFromMessage, 0, newBytesFromMessage, 0, RabbitOutputStream.TERMINATION_COMMAND.length);
                                System.arraycopy(bytesFromMessage, RabbitOutputStream.TERMINATION_COMMAND.length + 1, newBytesFromMessage, RabbitOutputStream.TERMINATION_COMMAND.length, bytesFromMessage.length - RabbitOutputStream.TERMINATION_COMMAND.length - 1);
                                bytesFromMessage = newBytesFromMessage;
                            }
                            RabbitInputStreamProvider.this.messagesAreWrittenToThis.write(bytesFromMessage);
                        }
                    }
                    catch (ConsumerCancelledException | ShutdownSignalException e) {
                        logger.log(Level.INFO, "Problem with message queue " + this.getName(), e);
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.WARNING, "Reading of next message in stream " + this.getName() + " Interrupted; continuing", e);
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    public InputStream getInputStream() {
        return this.clientReadsFromThis;
    }
}

