/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.replication.impl;

import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.replication.OperationWithResult;
import com.sap.sse.replication.Replicable;
import com.sap.sse.replication.impl.OperationSerializerBuffer;
import com.sap.sse.replication.impl.OperationSerializerBufferImpl;
import com.sap.sse.replication.impl.ReplicationMessageSender;
import com.sap.sse.util.ThreadPoolUtil;
import java.io.IOException;
import java.util.Timer;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OperationSerializerBufferPool
implements OperationSerializerBuffer {
    private static final Logger logger = Logger.getLogger(Runner.class.getName());
    private ScheduledExecutorService executor;
    private final int size = ThreadPoolUtil.INSTANCE.getReasonableThreadPoolSize();
    private final BlockingDeque<Util.Pair<OperationWithResult<?, ?>, Replicable<?, ?>>> queue = new LinkedBlockingDeque();
    private final ReplicationMessageSender sender;
    private final Duration timeout;
    private final int maximumBufferSizeInBytes;
    private final Timer timer;
    private static final Util.Pair<OperationWithResult<?, ?>, Replicable<?, ?>> STOP = new Util.Pair(null, null);

    public OperationSerializerBufferPool(ReplicationMessageSender sender, Duration timeout, int maximumBufferSizeInBytes, Timer timer) throws IOException {
        logger.info("Creating operation serializer buffer pool for outbound replication of size " + this.size);
        this.sender = sender;
        this.timeout = timeout;
        this.maximumBufferSizeInBytes = maximumBufferSizeInBytes;
        this.timer = timer;
    }

    public synchronized void start() throws IOException {
        if (this.executor == null) {
            this.executor = ThreadPoolUtil.INSTANCE.createForegroundTaskThreadPoolExecutor(this.size, "OperationSerializerBufferPool thread pool");
            int i = 0;
            while (i < this.size) {
                this.executor.execute(new Runner(this.sender, this.timeout, this.maximumBufferSizeInBytes, this.timer));
                ++i;
            }
        }
    }

    @Override
    public <S, O extends OperationWithResult<S, ?>> void write(OperationWithResult<?, ?> operation, Replicable<S, O> replicable) throws IOException {
        this.queue.add(new Util.Pair(operation, replicable));
    }

    public synchronized void stop() {
        if (this.executor != null) {
            logger.info("Stopping operation serializer buffer pool");
            this.executor.shutdown();
            this.executor = null;
            int i = 0;
            while (i < this.size) {
                this.queue.add(STOP);
                ++i;
            }
        }
    }

    private class Runner
    implements Runnable {
        private final OperationSerializerBufferImpl buffer;

        private Runner(ReplicationMessageSender sender, Duration timeout, int maximumBufferSizeInBytes, Timer timer) throws IOException {
            this.buffer = new OperationSerializerBufferImpl(sender, timeout, maximumBufferSizeInBytes, timer);
        }

        @Override
        public void run() {
            boolean interrupted = false;
            while (!interrupted) {
                try {
                    Util.Pair operationAndReplicable = (Util.Pair)OperationSerializerBufferPool.this.queue.take();
                    if (operationAndReplicable == STOP) {
                        logger.fine("Read STOP; terminating one operation serializer buffer pool thread");
                        interrupted = true;
                        continue;
                    }
                    try {
                        this.buffer.write((OperationWithResult)operationAndReplicable.getA(), (Replicable)operationAndReplicable.getB());
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "Couldn't write operation for replicable " + operationAndReplicable, e);
                    }
                }
                catch (InterruptedException e1) {
                    logger.warning("Interrupted; terminating...");
                    interrupted = true;
                }
            }
        }
    }
}

