/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.tracking.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.tracking.impl.CompactionNotPossibleException;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;

public class CompactPositionHelper {
    private static final double LAT_SCALE = -4.190951585769653E-8;
    private static final double LNG_SCALE = -8.381903171539307E-8;
    private static final double KNOT_SPEED_SCALE = 0.0152587890625;
    private static final double DEGREE_BEARING_SCALE = 0.010986328125;

    public static double getLatDeg(int latDegScaled) {
        return -4.190951585769653E-8 * (double)latDegScaled;
    }

    public static double getLngDeg(int lngDegScaled) {
        return -8.381903171539307E-8 * (double)lngDegScaled;
    }

    public static int getLngDegScaled(Position position) {
        return (int)(position.getLngDeg() / -8.381903171539307E-8);
    }

    public static int getLatDegScaled(Position position) {
        return (int)(position.getLatDeg() / -4.190951585769653E-8);
    }

    public static double getKnotSpeed(short knotSpeedScaled) {
        return 0.0152587890625 * (double)knotSpeedScaled;
    }

    public static double getDegreeBearing(short degreeBearingScaled) {
        return 0.010986328125 * (double)degreeBearingScaled;
    }

    public static short getKnotSpeedScaled(Speed speed) throws CompactionNotPossibleException {
        double knotSpeedScaled = speed.getKnots() / 0.0152587890625;
        if (knotSpeedScaled > 32767.0 || knotSpeedScaled < -32768.0) {
            throw new CompactionNotPossibleException("Speed " + speed + " cannot be compacted; " + speed.getKnots() + " does not fit into a signed short value");
        }
        return (short)knotSpeedScaled;
    }

    public static short getDegreeBearingScaled(Bearing bearing) {
        return (short)(bearing.getDegrees() / 0.010986328125);
    }
}

