/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.confidence.impl;

import com.sap.sailing.domain.common.confidence.Weigher;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;

public class StandardDistributionTimeDifferenceWeigher
implements Weigher<TimePoint> {
    private static final long serialVersionUID = 4378168079868145134L;
    private final double standardDeviationAsMillis;
    private final double oneDividedByStandardDeviationTimesSquareRootOfTwoPi;

    public StandardDistributionTimeDifferenceWeigher(Duration standardDeviation) {
        this.standardDeviationAsMillis = standardDeviation.asMillis();
        this.oneDividedByStandardDeviationTimesSquareRootOfTwoPi = 1.0 / (this.standardDeviationAsMillis * Math.sqrt(Math.PI * 2));
    }

    @Override
    public double getConfidence(TimePoint fix, TimePoint request) {
        double xMinusMu = Math.abs(fix.asMillis() - request.asMillis());
        double xMinusMuDividedByStandardDeviation = xMinusMu / this.standardDeviationAsMillis;
        return this.oneDividedByStandardDeviationTimesSquareRootOfTwoPi * Math.exp(-0.5 * xMinusMuDividedByStandardDeviation * xMinusMuDividedByStandardDeviation);
    }
}

