/*
 * Decompiled with CFR 0.152.
 */
package smile.wavelet;

import smile.wavelet.Wavelet;

public class D4Wavelet
extends Wavelet {
    private static final double C0 = 0.4829629131445341;
    private static final double C1 = 0.8365163037378079;
    private static final double C2 = 0.2241438680420134;
    private static final double C3 = -0.1294095225512604;
    private double[] workspace = new double[1024];

    public D4Wavelet() {
        super(new double[]{0.4829629131445341, 0.8365163037378079, 0.2241438680420134, -0.1294095225512604});
    }

    @Override
    void forward(double[] a, int n) {
        if (n < 4) {
            return;
        }
        if (n > this.workspace.length) {
            this.workspace = new double[n];
        }
        int nh = n >> 1;
        int n3 = n - 3;
        int i = 0;
        int j = 0;
        while (j < n3) {
            this.workspace[i] = 0.4829629131445341 * a[j] + 0.8365163037378079 * a[j + 1] + 0.2241438680420134 * a[j + 2] + -0.1294095225512604 * a[j + 3];
            this.workspace[i + nh] = -0.1294095225512604 * a[j] - 0.2241438680420134 * a[j + 1] + 0.8365163037378079 * a[j + 2] - 0.4829629131445341 * a[j + 3];
            j += 2;
            ++i;
        }
        this.workspace[i] = 0.4829629131445341 * a[n - 2] + 0.8365163037378079 * a[n - 1] + 0.2241438680420134 * a[0] + -0.1294095225512604 * a[1];
        this.workspace[i + nh] = -0.1294095225512604 * a[n - 2] - 0.2241438680420134 * a[n - 1] + 0.8365163037378079 * a[0] - 0.4829629131445341 * a[1];
        System.arraycopy(this.workspace, 0, a, 0, n);
    }

    @Override
    void backward(double[] a, int n) {
        if (n < 4) {
            return;
        }
        if (n > this.workspace.length) {
            this.workspace = new double[n];
        }
        int nh = n >> 1;
        int nh1 = nh - 1;
        this.workspace[0] = 0.2241438680420134 * a[nh - 1] + 0.8365163037378079 * a[n - 1] + 0.4829629131445341 * a[0] + -0.1294095225512604 * a[nh];
        this.workspace[1] = -0.1294095225512604 * a[nh - 1] - 0.4829629131445341 * a[n - 1] + 0.8365163037378079 * a[0] - 0.2241438680420134 * a[nh];
        int j = 2;
        for (int i = 0; i < nh1; ++i) {
            this.workspace[j++] = 0.2241438680420134 * a[i] + 0.8365163037378079 * a[i + nh] + 0.4829629131445341 * a[i + 1] + -0.1294095225512604 * a[i + nh + 1];
            this.workspace[j++] = -0.1294095225512604 * a[i] - 0.4829629131445341 * a[i + nh] + 0.8365163037378079 * a[i + 1] - 0.2241438680420134 * a[i + nh + 1];
        }
        System.arraycopy(this.workspace, 0, a, 0, n);
    }
}

