/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.simulator.TimedPosition;

public class PathCandidate
implements Comparable<PathCandidate> {
    TimedPosition pos;
    Wind wind;
    boolean reached;
    double vrt;
    double hrz;
    int trn;
    String path;
    char sid;
    Position start;

    public PathCandidate(TimedPosition pos, boolean reached, double vrt, double hrz, int trn, String path, char sid, Wind wind, Position start) {
        this.pos = pos;
        this.wind = wind;
        this.reached = reached;
        this.vrt = vrt;
        this.hrz = hrz;
        this.trn = trn;
        this.path = path;
        this.sid = sid;
        this.start = start;
    }

    public int getIndexOfTurnLR() {
        String tmpPath = this.path;
        tmpPath = tmpPath.toUpperCase();
        tmpPath = tmpPath.replace('D', 'L');
        tmpPath = tmpPath.replace('E', 'R');
        return tmpPath.indexOf("LR");
    }

    public int getIndexOfTurnRL() {
        String tmpPath = this.path;
        tmpPath = tmpPath.toUpperCase();
        tmpPath = tmpPath.replace('D', 'L');
        tmpPath = tmpPath.replace('E', 'R');
        return tmpPath.indexOf("RL");
    }

    @Override
    public int compareTo(PathCandidate other) {
        if (Math.abs(this.pos.getTimePoint().asMillis() - other.pos.getTimePoint().asMillis()) <= 1000L) {
            if (this.trn == other.trn) {
                return 0;
            }
            return this.trn < other.trn ? -1 : 1;
        }
        return this.pos.getTimePoint().asMillis() < other.pos.getTimePoint().asMillis() ? -1 : 1;
    }
}

