/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.model.classifier.maneuver;

import java.io.Serializable;

public class ManeuverFeatures
implements Serializable {
    private static final long serialVersionUID = -695419180697024150L;
    private static final ManeuverFeatures[] values = new ManeuverFeatures[8];
    private final boolean polarsInformation;
    private final boolean scaledSpeed;
    private final boolean marksInformation;

    static {
        int i = 0;
        int polars = 0;
        while (polars <= 1) {
            int scaledSpeed = 0;
            while (scaledSpeed <= 1) {
                int marks = 0;
                while (marks <= 1) {
                    ManeuverFeatures.values[i++] = new ManeuverFeatures(polars == 0, scaledSpeed == 0, marks == 0);
                    ++marks;
                }
                ++scaledSpeed;
            }
            ++polars;
        }
    }

    public ManeuverFeatures(boolean polarsInformation, boolean scaledSpeed, boolean marksInformation) {
        this.polarsInformation = polarsInformation;
        this.scaledSpeed = scaledSpeed;
        this.marksInformation = marksInformation;
    }

    public boolean isPolarsInformation() {
        return this.polarsInformation;
    }

    public boolean isScaledSpeed() {
        return this.scaledSpeed;
    }

    public boolean isMarksInformation() {
        return this.marksInformation;
    }

    public boolean isSubset(ManeuverFeatures superSet) {
        return !(this.polarsInformation && !superSet.polarsInformation || this.scaledSpeed && !superSet.scaledSpeed || this.marksInformation && !superSet.marksInformation);
    }

    public String toString() {
        if (this.polarsInformation || this.scaledSpeed || this.marksInformation) {
            StringBuilder str = new StringBuilder();
            if (this.polarsInformation) {
                str.append("Polars");
            }
            if (this.scaledSpeed) {
                str.append("ScaledSpeed");
            }
            if (this.marksInformation) {
                str.append("Marks");
            }
            return str.toString();
        }
        return "Basic";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.marksInformation ? 1231 : 1237);
        result = 31 * result + (this.polarsInformation ? 1231 : 1237);
        result = 31 * result + (this.scaledSpeed ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ManeuverFeatures other = (ManeuverFeatures)obj;
        if (this.marksInformation != other.marksInformation) {
            return false;
        }
        if (this.polarsInformation != other.polarsInformation) {
            return false;
        }
        return this.scaledSpeed == other.scaledSpeed;
    }

    public static ManeuverFeatures[] values() {
        return values;
    }
}

