/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.hmm;

import com.sap.sailing.windestimation.aggregator.hmm.AbstractBestPathsPerLevel;
import com.sap.sailing.windestimation.aggregator.hmm.BestManeuverNodeInfo;
import com.sap.sailing.windestimation.aggregator.hmm.BestNodeInfo;
import com.sap.sailing.windestimation.aggregator.hmm.GraphLevel;
import com.sap.sailing.windestimation.aggregator.hmm.GraphNode;
import com.sap.sailing.windestimation.aggregator.hmm.IntersectedWindRange;

public class BestPathsPerLevel
extends AbstractBestPathsPerLevel<GraphLevel>
implements Comparable<BestPathsPerLevel> {
    private final BestManeuverNodeInfo<GraphLevel>[] bestPreviousNodeInfosPerManeuverNode;
    private final GraphLevel currentLevel;

    public BestPathsPerLevel(GraphLevel currentLevel) {
        this.currentLevel = currentLevel;
        BestManeuverNodeInfo[] typeSafeArray = new BestManeuverNodeInfo[currentLevel.getLevelNodes().size()];
        this.bestPreviousNodeInfosPerManeuverNode = typeSafeArray;
    }

    public BestManeuverNodeInfo<GraphLevel> getBestPreviousNodeInfo(GraphNode<GraphLevel> currentNode) {
        return this.bestPreviousNodeInfosPerManeuverNode[currentNode.getIndexInLevel()];
    }

    public BestManeuverNodeInfo<GraphLevel> addBestPreviousNodeInfo(GraphNode<GraphLevel> currentNode, GraphNode<GraphLevel> bestPreviousNode, double probabilityFromStart, IntersectedWindRange intersectedWindRange) {
        BestManeuverNodeInfo<GraphLevel> bestManeuverNodeInfo = new BestManeuverNodeInfo<GraphLevel>(bestPreviousNode, probabilityFromStart, intersectedWindRange);
        this.bestPreviousNodeInfosPerManeuverNode[currentNode.getIndexInLevel()] = bestManeuverNodeInfo;
        return bestManeuverNodeInfo;
    }

    @Override
    public GraphLevel getCurrentLevel() {
        return this.currentLevel;
    }

    @Override
    protected BestNodeInfo[] getPreviousNodeInfosPerManeuverNode() {
        return this.bestPreviousNodeInfosPerManeuverNode;
    }

    @Override
    public int compareTo(BestPathsPerLevel o) {
        return this.toString().compareTo(o.toString());
    }
}

