/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.NotThreadSafe;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

@NotThreadSafe
class ReaderFilter
extends Reader {
    private final Reader _reader;
    private final long _maxLength;
    private long _readLength;
    private long _markedLength;

    protected ReaderFilter(Reader reader, long maxLength) {
        this._reader = reader;
        this._maxLength = maxLength;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        return this._reader.read(target);
    }

    @Override
    public int read() throws IOException {
        return this._maxLength > this._readLength++ ? this._reader.read() : -1;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this._reader.read(cbuf);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (cbuf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > cbuf.length || len < 0 || off + len < 0 || off + len > cbuf.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this._readLength >= this._maxLength) {
            return -1;
        }
        if (this._readLength + (long)len > this._maxLength && (len = (int)(this._maxLength - this._readLength)) <= 0) {
            return 0;
        }
        len = this._reader.read(cbuf, off, len);
        this._readLength += (long)len;
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        return this._reader.skip(n);
    }

    @Override
    public boolean ready() throws IOException {
        return this._reader.ready();
    }

    @Override
    public boolean markSupported() {
        return this._reader.markSupported();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this._reader.mark(readAheadLimit);
        this._markedLength = this._readLength;
    }

    @Override
    public void reset() throws IOException {
        this._reader.reset();
        this._readLength = this._markedLength;
    }

    @Override
    public void close() throws IOException {
        this._reader.close();
    }
}

