/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.persistence.racelog.tracking.impl;

import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Timed;

public class MetadataUpdate<FixT extends Timed> {
    private final DeviceIdentifier device;
    private final Object dbDeviceId;
    private final int nrOfTotalFixes;
    private final TimeRange fixesTimeRange;
    private final FixT latestFix;

    public MetadataUpdate(DeviceIdentifier device, Object dbDeviceId, int nrOfTotalFixes, TimeRange fixesTimeRange, FixT latestFix) {
        this.device = device;
        this.dbDeviceId = dbDeviceId;
        this.nrOfTotalFixes = nrOfTotalFixes;
        this.fixesTimeRange = fixesTimeRange;
        this.latestFix = latestFix;
    }

    public DeviceIdentifier getDevice() {
        return this.device;
    }

    public Object getDbDeviceId() {
        return this.dbDeviceId;
    }

    public int getNrOfTotalFixes() {
        return this.nrOfTotalFixes;
    }

    public TimeRange getFixesTimeRange() {
        return this.fixesTimeRange;
    }

    public FixT getLatestFix() {
        return this.latestFix;
    }

    public MetadataUpdate<FixT> merge(MetadataUpdate<FixT> other) {
        MetadataUpdate<FixT> result;
        if (other == null) {
            result = this;
        } else {
            if (!other.getDevice().equals(this.getDevice())) {
                throw new IllegalArgumentException("Can only merge metadata updates for the same device: " + this.getDevice() + " vs. " + other.getDevice());
            }
            result = new MetadataUpdate<FixT>(this.getDevice(), this.getDbDeviceId(), this.getNrOfTotalFixes() + other.getNrOfTotalFixes(), this.getFixesTimeRange().extend(other.getFixesTimeRange()), other.getLatestFix());
        }
        return result;
    }

    public String toString() {
        return "MetadataUpdate [device=" + this.device + ", dbDeviceId=" + this.dbDeviceId + ", nrOfTotalFixes=" + this.nrOfTotalFixes + ", fixesTimeRange=" + this.fixesTimeRange + ", latestFix=" + this.latestFix + "]";
    }
}

