/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.persistence.media.impl;

import com.mongodb.BasicDBList;
import com.mongodb.DuplicateKeyException;
import com.mongodb.MongoWriteException;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaNameAndRaceName;
import com.sap.sailing.domain.common.media.MediaTrack;
import com.sap.sailing.domain.persistence.media.MediaDB;
import com.sap.sailing.domain.persistence.media.impl.DbNames;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.media.MimeType;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public class MediaDBImpl
implements MediaDB {
    private static final int SORT_ASCENDING = 1;
    private static final int SORT_DESSCENDING = -1;
    private final MongoDatabase database;
    private final Document sortByStartTimeAndTitle;

    public MediaDBImpl(MongoDatabase database) {
        this.database = database;
        this.sortByStartTimeAndTitle = new Document();
        this.sortByStartTimeAndTitle.put(DbNames.Fields.STARTTIME.name(), (Object)-1);
        this.sortByStartTimeAndTitle.put(DbNames.Fields.MEDIA_TITLE.name(), (Object)1);
    }

    @Override
    public String insertMediaTrack(String title, String url, TimePoint startTime, Duration duration, MimeType mimeType, Set<RegattaAndRaceIdentifier> assignedRaces) {
        Document dbMediaTrack = new Document();
        dbMediaTrack.put(DbNames.Fields.MEDIA_TITLE.name(), (Object)title);
        dbMediaTrack.put(DbNames.Fields.MEDIA_URL.name(), (Object)url);
        dbMediaTrack.put(DbNames.Fields.STARTTIME.name(), (Object)(startTime == null ? null : startTime.asDate()));
        dbMediaTrack.put(DbNames.Fields.DURATION_IN_MILLIS.name(), duration == null ? null : Long.valueOf(duration.asMillis()));
        dbMediaTrack.put(DbNames.Fields.MIME_TYPE.name(), (Object)(mimeType == null ? null : mimeType.name()));
        BasicDBList assignedRacesDb = new BasicDBList();
        if (assignedRaces != null) {
            for (RegattaAndRaceIdentifier assignedRace : assignedRaces) {
                Document object = new Document();
                object.put(DbNames.Fields.REGATTA_NAME.name(), (Object)assignedRace.getRegattaName());
                object.put(DbNames.Fields.RACE_NAME.name(), (Object)assignedRace.getRaceName());
                assignedRacesDb.add((Object)object);
            }
        }
        dbMediaTrack.put(DbNames.Fields.ASSIGNED_RACES.name(), (Object)assignedRacesDb);
        MongoCollection<Document> dbVideos = this.getVideoCollection();
        dbVideos.insertOne((Object)dbMediaTrack);
        return ((ObjectId)dbMediaTrack.get((Object)DbNames.Fields._id.name())).toHexString();
    }

    @Override
    public void insertMediaTrackWithId(String dbId, String title, String url, TimePoint startTime, Duration duration, MimeType mimeType, Set<RegattaAndRaceIdentifier> assignedRaces) {
        Document dbMediaTrack = new Document();
        dbMediaTrack.put(DbNames.Fields._id.name(), (Object)new ObjectId(dbId));
        dbMediaTrack.put(DbNames.Fields.MEDIA_TITLE.name(), (Object)title);
        dbMediaTrack.put(DbNames.Fields.MEDIA_URL.name(), (Object)url);
        dbMediaTrack.put(DbNames.Fields.STARTTIME.name(), (Object)(startTime == null ? null : startTime.asDate()));
        dbMediaTrack.put(DbNames.Fields.DURATION_IN_MILLIS.name(), duration == null ? null : Long.valueOf(duration.asMillis()));
        dbMediaTrack.put(DbNames.Fields.MIME_TYPE.name(), (Object)(mimeType == null ? null : mimeType.name()));
        BasicDBList assignedRacesDb = new BasicDBList();
        if (assignedRaces != null) {
            for (RegattaAndRaceIdentifier assignedRace : assignedRaces) {
                Document object = new Document();
                object.put(DbNames.Fields.REGATTA_NAME.name(), (Object)assignedRace.getRegattaName());
                object.put(DbNames.Fields.RACE_NAME.name(), (Object)assignedRace.getRaceName());
                assignedRacesDb.add((Object)object);
            }
        }
        dbMediaTrack.put(DbNames.Fields.ASSIGNED_RACES.name(), (Object)assignedRacesDb);
        MongoCollection<Document> dbVideos = this.getVideoCollection();
        try {
            dbVideos.insertOne((Object)dbMediaTrack);
        }
        catch (DuplicateKeyException | MongoWriteException e) {
            throw new IllegalArgumentException("Duplicate key '" + dbId + "' caused an error when importing media (title: '" + title + "')", e);
        }
    }

    private MongoCollection<Document> getVideoCollection() {
        MongoCollection dbVideos = this.database.getCollection(DbNames.Collections.VIDEOS.name());
        dbVideos.withWriteConcern(WriteConcern.JOURNALED).createIndex((Bson)new Document(DbNames.Collections.VIDEOS.name(), (Object)1));
        return dbVideos;
    }

    private MediaTrack createMediaTrackFromDb(Document dbObject) {
        String dbId = ((ObjectId)dbObject.get((Object)DbNames.Fields._id.name())).toHexString();
        String title = (String)dbObject.get((Object)DbNames.Fields.MEDIA_TITLE.name());
        String url = (String)dbObject.get((Object)DbNames.Fields.MEDIA_URL.name());
        Date startTime = (Date)dbObject.get((Object)DbNames.Fields.STARTTIME.name());
        Number duration = (Number)dbObject.get((Object)DbNames.Fields.DURATION_IN_MILLIS.name());
        String mimeTypeText = (String)dbObject.get((Object)DbNames.Fields.MIME_TYPE.name());
        MimeType mimeType = MimeType.byName((String)mimeTypeText);
        HashSet<RegattaNameAndRaceName> assignedRaces = new HashSet<RegattaNameAndRaceName>();
        Iterable assignedRacesDb = (Iterable)dbObject.get((Object)DbNames.Fields.ASSIGNED_RACES.name());
        if (assignedRacesDb != null) {
            for (Object assignedRace : assignedRacesDb) {
                Document object = (Document)assignedRace;
                String regattaName = (String)object.get((Object)DbNames.Fields.REGATTA_NAME.name());
                String raceName = (String)object.get((Object)DbNames.Fields.RACE_NAME.name());
                if (regattaName == null || raceName == null) continue;
                assignedRaces.add(new RegattaNameAndRaceName(regattaName, raceName));
            }
        }
        MediaTrack mediaTrack = new MediaTrack(dbId, title, url, (TimePoint)(startTime == null ? null : new MillisecondsTimePoint(startTime)), (Duration)(duration == null ? null : new MillisecondsDurationImpl(duration.longValue())), mimeType, assignedRaces);
        return mediaTrack;
    }

    @Override
    public List<MediaTrack> loadAllMediaTracks() {
        MongoCursor cursor = this.getVideoCollection().find().sort((Bson)this.sortByStartTimeAndTitle).iterator();
        ArrayList<MediaTrack> result = new ArrayList<MediaTrack>((int)this.getVideoCollection().estimatedDocumentCount());
        while (cursor.hasNext()) {
            result.add(this.createMediaTrackFromDb((Document)cursor.next()));
        }
        return result;
    }

    @Override
    public void deleteMediaTrack(String dbId) {
        Document dbObject = new Document();
        dbObject.put(DbNames.Fields._id.name(), (Object)new ObjectId(dbId));
        this.getVideoCollection().deleteOne((Bson)dbObject);
    }

    @Override
    public void updateTitle(String dbId, String title) {
        Document updateQuery = new Document();
        updateQuery.append(DbNames.Fields._id.name(), (Object)new ObjectId(dbId));
        Document updateCommand = new Document();
        updateCommand.append("$set", (Object)new Document(DbNames.Fields.MEDIA_TITLE.name(), (Object)title));
        this.getVideoCollection().updateOne((Bson)updateQuery, (Bson)updateCommand);
    }

    @Override
    public void updateUrl(String dbId, String url) {
        Document updateQuery = new Document();
        updateQuery.append(DbNames.Fields._id.name(), (Object)new ObjectId(dbId));
        Document updateCommand = new Document();
        updateCommand.append("$set", (Object)new Document(DbNames.Fields.MEDIA_URL.name(), (Object)url));
        this.getVideoCollection().updateOne((Bson)updateQuery, (Bson)updateCommand);
    }

    @Override
    public void updateStartTime(String dbId, TimePoint startTime) {
        Document updateQuery = new Document();
        updateQuery.append(DbNames.Fields._id.name(), (Object)new ObjectId(dbId));
        Document updateCommand = new Document();
        updateCommand.append("$set", (Object)new Document(DbNames.Fields.STARTTIME.name(), (Object)(startTime == null ? null : startTime.asDate())));
        this.getVideoCollection().updateOne((Bson)updateQuery, (Bson)updateCommand);
    }

    @Override
    public void updateDuration(String dbId, Duration duration) {
        Document updateQuery = new Document();
        updateQuery.append(DbNames.Fields._id.name(), (Object)new ObjectId(dbId));
        Document updateCommand = new Document();
        updateCommand.append("$set", (Object)new Document(DbNames.Fields.DURATION_IN_MILLIS.name(), duration == null ? null : Long.valueOf(duration.asMillis())));
        this.getVideoCollection().updateOne((Bson)updateQuery, (Bson)updateCommand);
    }

    @Override
    public void updateRace(String dbId, Set<RegattaAndRaceIdentifier> assignedRaces) {
        Document updateQuery = new Document();
        updateQuery.append(DbNames.Fields._id.name(), (Object)new ObjectId(dbId));
        BasicDBList assignedRacesDb = new BasicDBList();
        if (assignedRaces != null) {
            for (RegattaAndRaceIdentifier assignedRace : assignedRaces) {
                Document object = new Document();
                object.put(DbNames.Fields.REGATTA_NAME.name(), (Object)assignedRace.getRegattaName());
                object.put(DbNames.Fields.RACE_NAME.name(), (Object)assignedRace.getRaceName());
                assignedRacesDb.add((Object)object);
            }
        }
        Document updateCommand = new Document();
        updateCommand.append("$set", (Object)new Document(DbNames.Fields.ASSIGNED_RACES.name(), (Object)assignedRacesDb));
        this.getVideoCollection().updateOne((Bson)updateQuery, (Bson)updateCommand);
    }
}

