/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.persistence.impl;

import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.persistence.DomainObjectFactory;
import com.sap.sailing.domain.persistence.MongoObjectFactory;
import com.sap.sailing.domain.persistence.impl.MongoRegattaLogStoreVisitor;
import com.sap.sailing.domain.regattalike.RegattaLikeIdentifier;
import com.sap.sailing.domain.regattalog.RegattaLogStore;
import java.util.HashMap;
import java.util.Map;

public class MongoRegattaLogStoreImpl
implements RegattaLogStore {
    private final MongoObjectFactory mongoObjectFactory;
    private final DomainObjectFactory domainObjectFactory;
    private final Map<RegattaLikeIdentifier, RegattaLog> regattaLogCache;

    public MongoRegattaLogStoreImpl(MongoObjectFactory mongoObjectFactory, DomainObjectFactory domainObjectFactory) {
        this.mongoObjectFactory = mongoObjectFactory;
        this.domainObjectFactory = domainObjectFactory;
        this.regattaLogCache = new HashMap<RegattaLikeIdentifier, RegattaLog>();
    }

    public RegattaLog getRegattaLog(RegattaLikeIdentifier identifier, boolean ignoreCache) {
        RegattaLog result;
        if (!ignoreCache && this.regattaLogCache.containsKey(identifier)) {
            result = this.regattaLogCache.get(identifier);
        } else {
            result = this.domainObjectFactory.loadRegattaLog(identifier);
            this.addListener(identifier, result);
            this.regattaLogCache.put(identifier, result);
        }
        return result;
    }

    private void addListener(RegattaLikeIdentifier identifier, RegattaLog regattaLog) {
        MongoRegattaLogStoreVisitor listener = new MongoRegattaLogStoreVisitor(identifier, this.mongoObjectFactory);
        regattaLog.addListener((Object)listener);
    }

    public void removeRegattaLog(RegattaLikeIdentifier identifier) {
        this.regattaLogCache.remove(identifier);
        this.mongoObjectFactory.removeRegattaLog(identifier);
    }

    public void addImportedRegattaLog(RegattaLog regattaLog, RegattaLikeIdentifier identifier) {
        this.addListener(identifier, regattaLog);
        this.regattaLogCache.put(identifier, regattaLog);
    }

    public void clear() {
        this.mongoObjectFactory.removeAllRegattaLogs();
        this.regattaLogCache.clear();
    }
}

