/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.components;

import com.sap.sailing.datamining.data.HasLeaderboardContext;
import com.sap.sailing.datamining.data.HasLeaderboardGroupContext;
import com.sap.sailing.datamining.impl.data.LeaderboardWithContext;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.AbstractRetrievalProcessor;
import com.sap.sse.security.shared.HasPermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class LeaderboardRetrievalProcessor
extends AbstractRetrievalProcessor<HasLeaderboardGroupContext, HasLeaderboardContext> {
    public LeaderboardRetrievalProcessor(ExecutorService executor, Collection<Processor<HasLeaderboardContext, ?>> resultReceivers, int retrievalLevel, String retrievedDataTypeMessageKey) {
        super(HasLeaderboardGroupContext.class, HasLeaderboardContext.class, executor, resultReceivers, retrievalLevel, retrievedDataTypeMessageKey);
    }

    protected Iterable<HasLeaderboardContext> retrieveData(HasLeaderboardGroupContext element) {
        ArrayList<HasLeaderboardContext> leaderboardsWithContext = new ArrayList<HasLeaderboardContext>();
        for (Leaderboard leaderboard : element.getLeaderboardGroup().getLeaderboards()) {
            if (this.isAborted()) break;
            Subject subject = SecurityUtils.getSubject();
            if (!subject.isPermitted(leaderboard.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ))) continue;
            leaderboardsWithContext.add(new LeaderboardWithContext(leaderboard, element));
        }
        return leaderboardsWithContext;
    }
}

