package com.sap.sailing.routeconverter.changepreferences;

import java.util.prefs.Preferences;
import java.util.prefs.PreferencesFactory;

public class InMemoryPreferencesFactory implements PreferencesFactory {
    public static final InMemoryPreferencesFactory INSTANCE = new InMemoryPreferencesFactory();

    private static final Preferences system = new InMemoryPreferencesImpl(null, "");
    private static final Preferences user = new InMemoryPreferencesImpl(null, "");

    @Override
    public Preferences systemRoot() {
        return system;
    }

    @Override
    public Preferences userRoot() {
        return user;
    }

    public Preferences userNodeForPackage(Class<?> clazz) {
        return user.node(clazz.getName());
    }

}
