/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddTrustStoreRevocationsRequest extends ElasticLoadBalancingV2Request implements
        ToCopyableBuilder<AddTrustStoreRevocationsRequest.Builder, AddTrustStoreRevocationsRequest> {
    private static final SdkField<String> TRUST_STORE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrustStoreArn").getter(getter(AddTrustStoreRevocationsRequest::trustStoreArn))
            .setter(setter(Builder::trustStoreArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStoreArn").build()).build();

    private static final SdkField<List<RevocationContent>> REVOCATION_CONTENTS_FIELD = SdkField
            .<List<RevocationContent>> builder(MarshallingType.LIST)
            .memberName("RevocationContents")
            .getter(getter(AddTrustStoreRevocationsRequest::revocationContents))
            .setter(setter(Builder::revocationContents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevocationContents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RevocationContent> builder(MarshallingType.SDK_POJO)
                                            .constructor(RevocationContent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_STORE_ARN_FIELD,
            REVOCATION_CONTENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trustStoreArn;

    private final List<RevocationContent> revocationContents;

    private AddTrustStoreRevocationsRequest(BuilderImpl builder) {
        super(builder);
        this.trustStoreArn = builder.trustStoreArn;
        this.revocationContents = builder.revocationContents;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trust store.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trust store.
     */
    public final String trustStoreArn() {
        return trustStoreArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the RevocationContents property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRevocationContents() {
        return revocationContents != null && !(revocationContents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The revocation file to add.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRevocationContents} method.
     * </p>
     * 
     * @return The revocation file to add.
     */
    public final List<RevocationContent> revocationContents() {
        return revocationContents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trustStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasRevocationContents() ? revocationContents() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddTrustStoreRevocationsRequest)) {
            return false;
        }
        AddTrustStoreRevocationsRequest other = (AddTrustStoreRevocationsRequest) obj;
        return Objects.equals(trustStoreArn(), other.trustStoreArn()) && hasRevocationContents() == other.hasRevocationContents()
                && Objects.equals(revocationContents(), other.revocationContents());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddTrustStoreRevocationsRequest").add("TrustStoreArn", trustStoreArn())
                .add("RevocationContents", hasRevocationContents() ? revocationContents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrustStoreArn":
            return Optional.ofNullable(clazz.cast(trustStoreArn()));
        case "RevocationContents":
            return Optional.ofNullable(clazz.cast(revocationContents()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrustStoreArn", TRUST_STORE_ARN_FIELD);
        map.put("RevocationContents", REVOCATION_CONTENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddTrustStoreRevocationsRequest, T> g) {
        return obj -> g.apply((AddTrustStoreRevocationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElasticLoadBalancingV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, AddTrustStoreRevocationsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trust store.
         * </p>
         * 
         * @param trustStoreArn
         *        The Amazon Resource Name (ARN) of the trust store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustStoreArn(String trustStoreArn);

        /**
         * <p>
         * The revocation file to add.
         * </p>
         * 
         * @param revocationContents
         *        The revocation file to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revocationContents(Collection<RevocationContent> revocationContents);

        /**
         * <p>
         * The revocation file to add.
         * </p>
         * 
         * @param revocationContents
         *        The revocation file to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revocationContents(RevocationContent... revocationContents);

        /**
         * <p>
         * The revocation file to add.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.RevocationContent.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.RevocationContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.RevocationContent.Builder#build()} is
         * called immediately and its result is passed to {@link #revocationContents(List<RevocationContent>)}.
         * 
         * @param revocationContents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.RevocationContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revocationContents(java.util.Collection<RevocationContent>)
         */
        Builder revocationContents(Consumer<RevocationContent.Builder>... revocationContents);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Request.BuilderImpl implements Builder {
        private String trustStoreArn;

        private List<RevocationContent> revocationContents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddTrustStoreRevocationsRequest model) {
            super(model);
            trustStoreArn(model.trustStoreArn);
            revocationContents(model.revocationContents);
        }

        public final String getTrustStoreArn() {
            return trustStoreArn;
        }

        public final void setTrustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
        }

        @Override
        public final Builder trustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        public final List<RevocationContent.Builder> getRevocationContents() {
            List<RevocationContent.Builder> result = RevocationContentsCopier.copyToBuilder(this.revocationContents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRevocationContents(Collection<RevocationContent.BuilderImpl> revocationContents) {
            this.revocationContents = RevocationContentsCopier.copyFromBuilder(revocationContents);
        }

        @Override
        public final Builder revocationContents(Collection<RevocationContent> revocationContents) {
            this.revocationContents = RevocationContentsCopier.copy(revocationContents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revocationContents(RevocationContent... revocationContents) {
            revocationContents(Arrays.asList(revocationContents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revocationContents(Consumer<RevocationContent.Builder>... revocationContents) {
            revocationContents(Stream.of(revocationContents).map(c -> RevocationContent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddTrustStoreRevocationsRequest build() {
            return new AddTrustStoreRevocationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
