/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTransitGatewayMulticastDomainResponse extends Ec2Response implements
        ToCopyableBuilder<CreateTransitGatewayMulticastDomainResponse.Builder, CreateTransitGatewayMulticastDomainResponse> {
    private static final SdkField<TransitGatewayMulticastDomain> TRANSIT_GATEWAY_MULTICAST_DOMAIN_FIELD = SdkField
            .<TransitGatewayMulticastDomain> builder(MarshallingType.SDK_POJO)
            .memberName("TransitGatewayMulticastDomain")
            .getter(getter(CreateTransitGatewayMulticastDomainResponse::transitGatewayMulticastDomain))
            .setter(setter(Builder::transitGatewayMulticastDomain))
            .constructor(TransitGatewayMulticastDomain::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayMulticastDomain")
                    .unmarshallLocationName("transitGatewayMulticastDomain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRANSIT_GATEWAY_MULTICAST_DOMAIN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TransitGatewayMulticastDomain transitGatewayMulticastDomain;

    private CreateTransitGatewayMulticastDomainResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayMulticastDomain = builder.transitGatewayMulticastDomain;
    }

    /**
     * <p>
     * Information about the transit gateway multicast domain.
     * </p>
     * 
     * @return Information about the transit gateway multicast domain.
     */
    public final TransitGatewayMulticastDomain transitGatewayMulticastDomain() {
        return transitGatewayMulticastDomain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayMulticastDomain());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransitGatewayMulticastDomainResponse)) {
            return false;
        }
        CreateTransitGatewayMulticastDomainResponse other = (CreateTransitGatewayMulticastDomainResponse) obj;
        return Objects.equals(transitGatewayMulticastDomain(), other.transitGatewayMulticastDomain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTransitGatewayMulticastDomainResponse")
                .add("TransitGatewayMulticastDomain", transitGatewayMulticastDomain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayMulticastDomain":
            return Optional.ofNullable(clazz.cast(transitGatewayMulticastDomain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TransitGatewayMulticastDomain", TRANSIT_GATEWAY_MULTICAST_DOMAIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTransitGatewayMulticastDomainResponse, T> g) {
        return obj -> g.apply((CreateTransitGatewayMulticastDomainResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateTransitGatewayMulticastDomainResponse> {
        /**
         * <p>
         * Information about the transit gateway multicast domain.
         * </p>
         * 
         * @param transitGatewayMulticastDomain
         *        Information about the transit gateway multicast domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayMulticastDomain(TransitGatewayMulticastDomain transitGatewayMulticastDomain);

        /**
         * <p>
         * Information about the transit gateway multicast domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransitGatewayMulticastDomain.Builder}
         * avoiding the need to create one manually via {@link TransitGatewayMulticastDomain#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransitGatewayMulticastDomain.Builder#build()} is called
         * immediately and its result is passed to {@link #transitGatewayMulticastDomain(TransitGatewayMulticastDomain)}.
         * 
         * @param transitGatewayMulticastDomain
         *        a consumer that will call methods on {@link TransitGatewayMulticastDomain.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitGatewayMulticastDomain(TransitGatewayMulticastDomain)
         */
        default Builder transitGatewayMulticastDomain(
                Consumer<TransitGatewayMulticastDomain.Builder> transitGatewayMulticastDomain) {
            return transitGatewayMulticastDomain(TransitGatewayMulticastDomain.builder()
                    .applyMutation(transitGatewayMulticastDomain).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private TransitGatewayMulticastDomain transitGatewayMulticastDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransitGatewayMulticastDomainResponse model) {
            super(model);
            transitGatewayMulticastDomain(model.transitGatewayMulticastDomain);
        }

        public final TransitGatewayMulticastDomain.Builder getTransitGatewayMulticastDomain() {
            return transitGatewayMulticastDomain != null ? transitGatewayMulticastDomain.toBuilder() : null;
        }

        public final void setTransitGatewayMulticastDomain(TransitGatewayMulticastDomain.BuilderImpl transitGatewayMulticastDomain) {
            this.transitGatewayMulticastDomain = transitGatewayMulticastDomain != null ? transitGatewayMulticastDomain.build()
                    : null;
        }

        @Override
        public final Builder transitGatewayMulticastDomain(TransitGatewayMulticastDomain transitGatewayMulticastDomain) {
            this.transitGatewayMulticastDomain = transitGatewayMulticastDomain;
            return this;
        }

        @Override
        public CreateTransitGatewayMulticastDomainResponse build() {
            return new CreateTransitGatewayMulticastDomainResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
