/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tractracadapter.DomainFactory;
import com.sap.sailing.domain.tractracadapter.impl.AbstractReceiverWithQueue;
import com.sap.sailing.domain.tractracadapter.impl.Simulator;
import com.sap.sse.common.Util;
import com.tractrac.model.lib.api.data.IPosition;
import com.tractrac.model.lib.api.event.IEvent;
import com.tractrac.model.lib.api.event.IRace;
import com.tractrac.model.lib.api.event.IRaceCompetitor;
import com.tractrac.subscription.lib.api.IEventSubscriber;
import com.tractrac.subscription.lib.api.IRaceSubscriber;
import com.tractrac.subscription.lib.api.competitor.IPositionListener;
import java.util.logging.Logger;

public class RawPositionReceiver
extends AbstractReceiverWithQueue<IRaceCompetitor, IPosition, Void> {
    private static final Logger logger = Logger.getLogger(RawPositionReceiver.class.getName());
    private int received;
    private final IPositionListener listener = new IPositionListener(){

        public void gotPosition(IRaceCompetitor controlPoint, IPosition position) {
            RawPositionReceiver.this.enqueue(new Util.Triple((Object)controlPoint, (Object)position, null));
        }
    };

    public RawPositionReceiver(DynamicTrackedRegatta trackedRegatta, IEvent tractracEvent, DomainFactory domainFactory, Simulator simulator, IEventSubscriber eventSubscriber, IRaceSubscriber raceSubscriber, long timeoutInMilliseconds) {
        super(domainFactory, tractracEvent, trackedRegatta, simulator, eventSubscriber, raceSubscriber, timeoutInMilliseconds);
    }

    @Override
    public void subscribe() {
        this.getRaceSubscriber().subscribePositions(this.listener);
        this.startThread();
    }

    @Override
    protected void unsubscribe() {
        this.getRaceSubscriber().unsubscribePositions(this.listener);
    }

    @Override
    protected void handleEvent(Util.Triple<IRaceCompetitor, IPosition, Void> event) {
        if (!((IRaceCompetitor)event.getA()).getCompetitor().isNonCompeting()) {
            IRace race;
            DynamicTrackedRace trackedRace;
            if (this.received++ % 1000 == 0) {
                System.out.print("P");
                if ((this.received / 1000 + 1) % 80 == 0) {
                    System.out.println();
                }
            }
            if ((trackedRace = this.getTrackedRace(race = ((IRaceCompetitor)event.getA()).getRace())) != null) {
                GPSFixMoving fix = this.getDomainFactory().createGPSFixMoving((IPosition)event.getB());
                Competitor competitor = this.getDomainFactory().resolveCompetitor(((IRaceCompetitor)event.getA()).getCompetitor());
                if (this.getSimulator() != null) {
                    this.getSimulator().scheduleCompetitorPosition(competitor, fix);
                } else {
                    trackedRace.recordFix(competitor, fix);
                }
            } else {
                logger.warning("Couldn't find tracked race for race " + race.getName() + ". Dropping raw position event " + event);
            }
        }
    }
}

