/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogEventVisitor;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLogEvent;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLogEventVisitor;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.configuration.DeviceConfiguration;
import com.sap.sailing.domain.base.impl.RegattaImpl;
import com.sap.sailing.domain.common.DataImportProgress;
import com.sap.sailing.domain.common.DataImportSubProgress;
import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.MasterDataImportObjectCreationCount;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.TrackedRaceStatusEnum;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.MasterDataImportObjectCreationCountImpl;
import com.sap.sailing.domain.common.media.MediaTrack;
import com.sap.sailing.domain.common.tracking.impl.GPSFixImpl;
import com.sap.sailing.domain.common.tracking.impl.GPSFixMovingImpl;
import com.sap.sailing.domain.common.tracking.impl.VeryCompactGPSFixImpl;
import com.sap.sailing.domain.common.tracking.impl.VeryCompactGPSFixMovingImpl;
import com.sap.sailing.domain.leaderboard.FlexibleLeaderboard;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.masterdataimport.TopLevelMasterData;
import com.sap.sailing.domain.masterdataimport.WindTrackMasterData;
import com.sap.sailing.domain.persistence.DomainObjectFactory;
import com.sap.sailing.domain.persistence.MongoObjectFactory;
import com.sap.sailing.domain.persistence.MongoRaceLogStoreFactory;
import com.sap.sailing.domain.persistence.MongoRegattaLogStoreFactory;
import com.sap.sailing.domain.racelog.RaceLogIdentifier;
import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.domain.racelog.tracking.SensorFixStore;
import com.sap.sailing.domain.regattalike.HasRegattaLike;
import com.sap.sailing.domain.regattalike.IsRegattaLike;
import com.sap.sailing.domain.regattalike.RegattaLikeIdentifier;
import com.sap.sailing.domain.regattalog.RegattaLogStore;
import com.sap.sailing.domain.tracking.DummyTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.RaceChangeListener;
import com.sap.sailing.domain.tracking.RaceHandle;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParameters;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParametersHandler;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRaceStatus;
import com.sap.sailing.domain.tracking.WindTrack;
import com.sap.sailing.domain.tracking.impl.AbstractRaceChangeListener;
import com.sap.sailing.server.interfaces.DataImportLockWithProgress;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractRacingEventServiceOperation;
import com.sap.sse.common.NoCorrespondingServiceRegisteredException;
import com.sap.sse.common.Timed;
import com.sap.sse.common.Util;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.impl.UserGroup;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImportMasterDataOperation
extends AbstractRacingEventServiceOperation<MasterDataImportObjectCreationCountImpl> {
    private static final long serialVersionUID = 3131715325307370303L;
    private static final Logger logger = Logger.getLogger(ImportMasterDataOperation.class.getName());
    private static final int BATCH_SIZE_FOR_IMPORTING_FIXES = 5000;
    private final TopLevelMasterData masterData;
    private final MasterDataImportObjectCreationCountImpl creationCount = new MasterDataImportObjectCreationCountImpl();
    private final boolean override;
    private final UUID importOperationId;
    private DataImportProgress progress;
    private User user;
    private UserGroup tenant;
    private final Set<RaceTrackingConnectivityParameters> connectivityParametersToRestore;

    public ImportMasterDataOperation(TopLevelMasterData topLevelMasterData, UUID importOperationId, boolean override, User user, UserGroup tenant) {
        this.masterData = topLevelMasterData;
        this.override = override;
        this.importOperationId = importOperationId;
        this.user = user;
        this.tenant = tenant;
        this.connectivityParametersToRestore = this.masterData.getConnectivityParametersToRestore();
    }

    public boolean isRequiresExplicitTransitiveReplication() {
        return false;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public MasterDataImportObjectCreationCountImpl internalApplyTo(RacingEventService toState) throws Exception {
        logger.info("Starting to import master data into " + toState);
        DataImportLockWithProgress dataImportLock = toState.getDataImportLock();
        SecurityService securityService = toState.getSecurityService();
        if (securityService == null) {
            throw new IllegalStateException("Cannot import data, security service could not be resolved");
        }
        this.progress = dataImportLock.getProgress(this.importOperationId);
        this.progress.setCurrentSubProgress(DataImportSubProgress.IMPORT_WAIT);
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)dataImportLock);
        try {
            this.progress.setCurrentSubProgress(DataImportSubProgress.IMPORT_LEADERBOARD_GROUPS);
            this.progress.setCurrentSubProgressPct(0.0);
            int numOfGroupsToImport = this.masterData.getLeaderboardGroups().size();
            int i = 0;
            for (LeaderboardGroup leaderboardGroup : this.masterData.getLeaderboardGroups()) {
                this.createLeaderboardGroupWithAllRelatedObjects(toState, leaderboardGroup, securityService);
                this.progress.setCurrentSubProgressPct((double)(++i) / (double)numOfGroupsToImport);
            }
            this.progress.setCurrentSubProgress(DataImportSubProgress.UPDATE_EVENT_LEADERBOARD_GROUP_LINKS);
            this.progress.setOverAllProgressPct(0.4);
            this.progress.setCurrentSubProgressPct(0.0);
            Iterable allEvents = this.masterData.getAllEvents();
            int numOfEventsToHandle = Util.size((Iterable)allEvents);
            int eventCounter = 0;
            for (Event e : allEvents) {
                this.updateLinksToLeaderboardGroups(toState, e);
                this.progress.setCurrentSubProgressPct((double)(++eventCounter) / (double)numOfEventsToHandle);
            }
            this.progress.setCurrentSubProgress(DataImportSubProgress.IMPORT_WIND_TRACKS);
            this.progress.setOverAllProgressPct(0.5);
            this.progress.setCurrentSubProgressPct(0.0);
            this.createWindTracks(toState);
            this.progress.setCurrentSubProgress(DataImportSubProgress.IMPORT_SENSOR_FIXES);
            this.progress.setOverAllProgressPct(0.7);
            this.progress.setCurrentSubProgressPct(0.0);
            this.importRaceLogTrackingGPSFixes(toState);
            if (this.masterData.getDeviceConfigurations() != null) {
                this.importDeviceConfigurations(toState);
            }
            Collection allMediaTracksToImport = this.masterData.getFilteredMediaTracks();
            for (MediaTrack trackToImport : allMediaTracksToImport) {
                this.ensureOwnership(trackToImport.getIdentifier(), securityService);
            }
            toState.mediaTracksImported(allMediaTracksToImport, this.creationCount, this.override);
            this.progress.setCurrentSubProgress(DataImportSubProgress.IMPORT_TRACKED_RACES);
            this.progress.setOverAllProgressPct(0.8);
            this.progress.setCurrentSubProgressPct(0.0);
            Iterable<TrackedRace> trackedRacesToWaitForLoadingComplete = this.importTrackedRaces(toState, securityService);
            this.progress.setCurrentSubProgress(DataImportSubProgress.WAITING_FOR_TRACKED_RACES_TO_FINISH_LOADING);
            this.progress.setOverAllProgressPct(0.9);
            this.progress.setCurrentSubProgressPct(0.0);
            this.waitForTrackedRacesToFinishLoading(trackedRacesToWaitForLoadingComplete);
            dataImportLock.getProgress(this.importOperationId).setResult((MasterDataImportObjectCreationCount)this.creationCount);
            this.progress.setOverAllProgressPct(1.0);
            logger.info("Done importing master data into " + toState);
            MasterDataImportObjectCreationCountImpl masterDataImportObjectCreationCountImpl = this.creationCount;
            return masterDataImportObjectCreationCountImpl;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error during execution of ImportMasterDataOperation", e);
            throw new RuntimeException("Error during execution of ImportMasterDataOperation", e);
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)dataImportLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForTrackedRacesToFinishLoading(Iterable<TrackedRace> trackedRacesToWaitForLoadingComplete) throws InterruptedException {
        final int toLoad = Util.size(trackedRacesToWaitForLoadingComplete);
        logger.info("Waiting for race loading to complete for " + toLoad + " races...");
        final Set racesStillLoading = Collections.newSetFromMap(new ConcurrentHashMap());
        Util.addAll(trackedRacesToWaitForLoadingComplete, racesStillLoading);
        final Object sync = new Object();
        for (final TrackedRace trackedRace : trackedRacesToWaitForLoadingComplete) {
            trackedRace.addListener((RaceChangeListener)new AbstractRaceChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void statusChanged(TrackedRaceStatus newStatus, TrackedRaceStatus oldStatus) {
                    if ((oldStatus.getStatus() == TrackedRaceStatusEnum.PREPARED || oldStatus.getStatus() == TrackedRaceStatusEnum.LOADING) && newStatus.getStatus().getOrder() > TrackedRaceStatusEnum.LOADING.getOrder()) {
                        logger.info("Race " + trackedRace + " has finished loading");
                        Object object = ImportMasterDataOperation.this.progress;
                        synchronized (object) {
                            ImportMasterDataOperation.this.progress.setCurrentSubProgressPct((double)(toLoad - racesStillLoading.size()) / (double)toLoad);
                        }
                        racesStillLoading.remove(trackedRace);
                        object = sync;
                        synchronized (object) {
                            if (racesStillLoading.isEmpty()) {
                                sync.notifyAll();
                            }
                        }
                        trackedRace.removeListener((RaceChangeListener)this);
                    }
                }
            });
        }
        Iterator i = racesStillLoading.iterator();
        while (i.hasNext()) {
            TrackedRace trackedRace = (TrackedRace)i.next();
            if (trackedRace.getStatus().getStatus().getOrder() <= TrackedRaceStatusEnum.LOADING.getOrder()) continue;
            logger.info("Race " + trackedRace + " has finished loading");
            i.remove();
            this.progress.setCurrentSubProgressPct((double)(toLoad - racesStillLoading.size()) / (double)toLoad);
        }
        Object object = sync;
        synchronized (object) {
            while (!racesStillLoading.isEmpty()) {
                sync.wait();
            }
        }
        logger.info("All races imported have finished loading");
    }

    private void importDeviceConfigurations(RacingEventService toState) {
        if (toState.getMasterDescriptor() == null) {
            Iterable newConfigs = this.masterData.getDeviceConfigurations();
            for (DeviceConfiguration config : newConfigs) {
                if (toState.getDeviceConfigurationById(config.getId()) != null) {
                    if (this.override) {
                        logger.info(String.format("Device configuration [%s] with name \"%s\" already exists. Overwrite because override flag is set.", config.getId(), config.getName()));
                        toState.removeDeviceConfiguration(config.getId());
                        toState.createOrUpdateDeviceConfiguration(config);
                        continue;
                    }
                    logger.info(String.format("Device configuration [%s] with name \"%s\" already exists. Not overwriting because override flag is not set.", config.getId(), config.getName()));
                    continue;
                }
                toState.createOrUpdateDeviceConfiguration(config);
            }
        }
    }

    private void updateLinksToLeaderboardGroups(RacingEventService racingEventService, Event eventReceived) {
        boolean changed = false;
        int positionOfLastLeaderboardGroupFoundInLocalEvent = -1;
        Event eventAfterImport = racingEventService.getEvent(eventReceived.getId());
        Collection leaderboardGroupsReceived = this.masterData.getLeaderboardGroups();
        for (LeaderboardGroup lgInEventReceived : eventReceived.getLeaderboardGroups()) {
            if (!leaderboardGroupsReceived.contains(lgInEventReceived)) continue;
            int pos = 0;
            boolean found = false;
            for (LeaderboardGroup importedLg : eventAfterImport.getLeaderboardGroups()) {
                if (importedLg.getId().equals(lgInEventReceived.getId())) {
                    found = true;
                    if (pos < positionOfLastLeaderboardGroupFoundInLocalEvent) {
                        eventAfterImport.removeLeaderboardGroup(importedLg);
                        eventAfterImport.addLeaderboardGroup(importedLg);
                        positionOfLastLeaderboardGroupFoundInLocalEvent = Util.size((Iterable)eventAfterImport.getLeaderboardGroups()) - 1;
                        changed = true;
                        break;
                    }
                    positionOfLastLeaderboardGroupFoundInLocalEvent = pos;
                    break;
                }
                ++pos;
            }
            if (found) continue;
            eventAfterImport.addLeaderboardGroup(racingEventService.getLeaderboardGroupByID(lgInEventReceived.getId()));
            positionOfLastLeaderboardGroupFoundInLocalEvent = Util.size((Iterable)eventAfterImport.getLeaderboardGroups()) - 1;
            changed = true;
        }
        if (changed) {
            racingEventService.getMongoObjectFactory().storeEvent(eventAfterImport);
        }
    }

    private void createLeaderboardGroupWithAllRelatedObjects(RacingEventService toState, LeaderboardGroup leaderboardGroup, SecurityService securityService) {
        Map<String, Leaderboard> existingLeaderboards = toState.getLeaderboards();
        ArrayList<String> leaderboardNames = new ArrayList<String>();
        this.createCourseAreasAndEvents(toState, leaderboardGroup, securityService);
        this.createRegattas(toState, leaderboardGroup, securityService);
        for (Leaderboard leaderboard : leaderboardGroup.getLeaderboards()) {
            leaderboardNames.add(leaderboard.getName());
            if (existingLeaderboards.containsKey(leaderboard.getName())) {
                if (this.creationCount.alreadyAddedLeaderboardWithName(leaderboard.getName())) continue;
                if (this.override) {
                    for (RaceColumn raceColumn : existingLeaderboards.get(leaderboard.getName()).getRaceColumns()) {
                        for (Fleet fleet : raceColumn.getFleets()) {
                            TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
                            if (trackedRace == null) continue;
                            raceColumn.releaseTrackedRace(fleet);
                        }
                    }
                    if (toState.getLeaderboardByName(leaderboard.getName()) != null) {
                        toState.removeLeaderboard(leaderboard.getName());
                    }
                    logger.info(String.format("Leaderboard with name %1$s already existed and has been overridden.", leaderboard.getName()));
                } else {
                    logger.info(String.format("Leaderboard with name %1$s already exists and hasn't been overridden.", leaderboard.getName()));
                    continue;
                }
            }
            if (leaderboard == null) continue;
            toState.addLeaderboard(leaderboard);
            this.storeRaceLogEvents(leaderboard, toState.getMongoObjectFactory(), toState.getDomainObjectFactory(), this.override);
            this.storeRegattaLogEvents(leaderboard, toState.getMongoObjectFactory(), toState.getDomainObjectFactory(), this.override);
            this.ensureOwnership(leaderboard.getIdentifier(), securityService);
            this.creationCount.addOneLeaderboard(leaderboard.getName());
            this.relinkTrackedRacesIfPossible(toState, leaderboard);
            toState.updateStoredLeaderboard(leaderboard);
        }
        LeaderboardGroup existingLeaderboardGroup = toState.getLeaderboardGroupByID(leaderboardGroup.getId());
        if (existingLeaderboardGroup != null && this.override) {
            logger.info(String.format("Leaderboard Group with ID %1$s already existed and will be overridden.", leaderboardGroup.getId()));
            toState.removeLeaderboardGroup(leaderboardGroup.getId());
            existingLeaderboardGroup = null;
        }
        if (existingLeaderboardGroup == null) {
            toState.addLeaderboardGroupWithoutReplication(leaderboardGroup);
            this.creationCount.addOneLeaderboardGroup(leaderboardGroup.getName());
            if (leaderboardGroup.getOverallLeaderboard() != null) {
                this.ensureOwnership(leaderboardGroup.getOverallLeaderboard().getIdentifier(), securityService);
            }
            this.ensureOwnership(leaderboardGroup.getIdentifier(), securityService);
        } else {
            logger.info(String.format("Leaderboard Group with name %1$s already exists and hasn't been overridden.", leaderboardGroup.getName()));
        }
    }

    private void storeRaceLogEvents(Leaderboard leaderboard, MongoObjectFactory mongoObjectFactory, DomainObjectFactory domainObjectFactory, boolean override) {
        RaceLogStore mongoRaceLogStore = MongoRaceLogStoreFactory.INSTANCE.getMongoRaceLogStore(mongoObjectFactory, domainObjectFactory);
        for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
            for (Fleet fleet : raceColumn.getFleets()) {
                RaceLog log = raceColumn.getRaceLog(fleet);
                if (log == null) continue;
                RaceLogIdentifier identifier = raceColumn.getRaceLogIdentifier(fleet);
                RaceLog currentPersistedLog = mongoRaceLogStore.getRaceLog(identifier, true);
                if (currentPersistedLog.isEmpty()) {
                    this.addAllImportedEvents(mongoObjectFactory, mongoRaceLogStore, log, identifier);
                    continue;
                }
                if (!override) continue;
                mongoRaceLogStore.removeRaceLog(identifier);
                this.addAllImportedEvents(mongoObjectFactory, mongoRaceLogStore, log, identifier);
            }
        }
    }

    private void addAllImportedEvents(MongoObjectFactory mongoObjectFactory, RaceLogStore mongoRaceLogStore, RaceLog log, RaceLogIdentifier identifier) {
        RaceLogEventVisitor storeVisitor = MongoRaceLogStoreFactory.INSTANCE.getMongoRaceLogStoreVisitor(identifier, mongoObjectFactory);
        log.lockForRead();
        try {
            for (RaceLogEvent event : log.getRawFixes()) {
                event.accept((Object)storeVisitor);
            }
        }
        finally {
            log.unlockAfterRead();
        }
        mongoRaceLogStore.addImportedRaceLog(log, identifier);
    }

    private void storeRegattaLogEvents(Leaderboard leaderboard, MongoObjectFactory mongoObjectFactory, DomainObjectFactory domainObjectFactory, boolean override) {
        RegattaLogStore regattaLogStore = MongoRegattaLogStoreFactory.INSTANCE.getMongoRegattaLogStore(mongoObjectFactory, domainObjectFactory);
        if (leaderboard instanceof HasRegattaLike) {
            IsRegattaLike regattaLike = ((HasRegattaLike)leaderboard).getRegattaLike();
            RegattaLog log = regattaLike.getRegattaLog();
            RegattaLikeIdentifier identifier = regattaLike.getRegattaLikeIdentifier();
            RegattaLogEventVisitor storeVisitor = MongoRegattaLogStoreFactory.INSTANCE.getMongoRegattaLogStoreVisitor(identifier, mongoObjectFactory);
            RegattaLog currentPersistedLog = regattaLogStore.getRegattaLog(identifier, true);
            if (currentPersistedLog.isEmpty()) {
                this.addAllImportedRegattaEvents(regattaLogStore, log, identifier, storeVisitor);
            } else if (override) {
                regattaLogStore.removeRegattaLog(identifier);
                this.addAllImportedRegattaEvents(regattaLogStore, log, identifier, storeVisitor);
            }
        }
    }

    private void addAllImportedRegattaEvents(RegattaLogStore regattaLogStore, RegattaLog log, RegattaLikeIdentifier identifier, RegattaLogEventVisitor storeVisitor) {
        log.lockForRead();
        try {
            for (RegattaLogEvent event : log.getRawFixes()) {
                event.accept((Object)storeVisitor);
            }
        }
        finally {
            log.unlockAfterRead();
        }
        regattaLogStore.addImportedRegattaLog(log, identifier);
    }

    private void relinkTrackedRacesIfPossible(RacingEventService toState, Leaderboard newLeaderboard) {
        if (newLeaderboard instanceof FlexibleLeaderboard) {
            for (RaceColumn raceColumn : newLeaderboard.getRaceColumns()) {
                for (Fleet fleet : raceColumn.getFleets()) {
                    RaceIdentifier raceIdentifier = raceColumn.getRaceIdentifier(fleet);
                    if (raceIdentifier == null) continue;
                    DynamicTrackedRace trackedRace = toState.getTrackedRace((RegattaAndRaceIdentifier)raceIdentifier);
                    raceColumn.setTrackedRace(fleet, (TrackedRace)trackedRace);
                    raceColumn.setRaceIdentifier(fleet, raceIdentifier);
                }
            }
        }
    }

    private void createWindTracks(RacingEventService toState) {
        if (toState.getMasterDescriptor() == null) {
            int numOfWindTracks = this.masterData.getWindTrackMasterData().size();
            int i = 0;
            for (WindTrackMasterData windMasterData : this.masterData.getWindTrackMasterData()) {
                DummyTrackedRace trackedRaceWithNameAndId = new DummyTrackedRace(windMasterData.getRaceName(), windMasterData.getRaceId());
                WindTrack windTrackToWriteTo = toState.getWindStore().getWindTrack(windMasterData.getRegattaName(), (TrackedRace)trackedRaceWithNameAndId, windMasterData.getWindSource(), 0L, -1L);
                WindTrack windTrackToReadFrom = windMasterData.getWindTrack();
                ArrayList<Wind> fixesToAdd = new ArrayList<Wind>();
                windTrackToReadFrom.lockForRead();
                try {
                    for (Wind fix : windTrackToReadFrom.getRawFixes()) {
                        Wind existingFix = (Wind)windTrackToWriteTo.getFirstRawFixAtOrAfter(fix.getTimePoint());
                        if (existingFix == null || !existingFix.equals(fix)) {
                            fixesToAdd.add(fix);
                            continue;
                        }
                        logger.fine("Didn't add wind fix in import, because equal fix was already there.");
                    }
                }
                finally {
                    windTrackToReadFrom.unlockAfterRead();
                }
                windTrackToWriteTo.add(fixesToAdd);
                this.progress.setCurrentSubProgressPct((double)(++i) / (double)numOfWindTracks);
                this.progress.setOverAllProgressPct(0.5 + 0.3 * ((double)i / (double)numOfWindTracks));
            }
        }
    }

    private void importRaceLogTrackingGPSFixes(RacingEventService toState) {
        Map raceLogTrackingFixes;
        if (toState.getMasterDescriptor() == null && (raceLogTrackingFixes = this.masterData.getRaceLogTrackingFixes()) != null) {
            SensorFixStore store = toState.getSensorFixStore();
            int i = 0;
            int numberOfDevices = raceLogTrackingFixes.size();
            for (Map.Entry entry : raceLogTrackingFixes.entrySet()) {
                DeviceIdentifier device = (DeviceIdentifier)entry.getKey();
                ArrayList<Timed> fixesToAddAsBatch = new ArrayList<Timed>(5000);
                for (Timed fixToAdd : (Set)entry.getValue()) {
                    VeryCompactGPSFixMovingImpl gpsFix;
                    if (fixToAdd instanceof VeryCompactGPSFixMovingImpl) {
                        gpsFix = (VeryCompactGPSFixMovingImpl)fixToAdd;
                        fixToAdd = new GPSFixMovingImpl(gpsFix.getPosition(), fixToAdd.getTimePoint(), ((VeryCompactGPSFixMovingImpl)fixToAdd).getSpeed(), gpsFix.getOptionalTrueHeading());
                    } else if (fixToAdd instanceof VeryCompactGPSFixImpl) {
                        gpsFix = (VeryCompactGPSFixImpl)fixToAdd;
                        fixToAdd = new GPSFixImpl(gpsFix.getPosition(), fixToAdd.getTimePoint());
                    }
                    fixesToAddAsBatch.add(fixToAdd);
                    if (fixesToAddAsBatch.size() != 5000) continue;
                    this.storeFixes(store, device, fixesToAddAsBatch);
                }
                if (!fixesToAddAsBatch.isEmpty()) {
                    this.storeFixes(store, device, fixesToAddAsBatch);
                }
                this.progress.setCurrentSubProgressPct((double)(++i) / (double)numberOfDevices);
            }
        }
    }

    private void storeFixes(SensorFixStore store, DeviceIdentifier device, Collection<Timed> fixesToAddAsBatch) {
        try {
            store.storeFixes(device, fixesToAddAsBatch, false, false);
            fixesToAddAsBatch.clear();
        }
        catch (NoCorrespondingServiceRegisteredException e) {
            logger.severe("Failed to store race log tracking fixes while importing.");
        }
    }

    private void createRegattas(RacingEventService toState, LeaderboardGroup leaderboardGroup, SecurityService securityService) {
        Iterable leaderboards = leaderboardGroup.getLeaderboards();
        for (Leaderboard leaderboard : leaderboards) {
            Regatta regatta;
            block17: {
                if (!(leaderboard instanceof RegattaLeaderboard)) continue;
                RegattaLeaderboard regattaLeaderboard = (RegattaLeaderboard)leaderboard;
                regatta = regattaLeaderboard.getRegatta();
                Regatta existingRegatta = toState.getRegatta(regatta.getRegattaIdentifier());
                if (existingRegatta != null) {
                    if (this.creationCount.alreadyAddedRegattaWithId(existingRegatta.getId().toString())) continue;
                    if (this.override) {
                        logger.info(String.format("Regatta with name %1$s already existed and has been overridden. All it's tracked races were stopped and removed.", regatta.getRegattaIdentifier()));
                        try {
                            DynamicTrackedRegatta trackedRegatta = toState.getTrackedRegatta(existingRegatta);
                            ArrayList<TrackedRace> toRemove = new ArrayList<TrackedRace>();
                            if (trackedRegatta != null) {
                                trackedRegatta.lockTrackedRacesForRead();
                                try {
                                    for (TrackedRace race : trackedRegatta.getTrackedRaces()) {
                                        toRemove.add(race);
                                    }
                                }
                                finally {
                                    trackedRegatta.unlockTrackedRacesAfterRead();
                                }
                                for (TrackedRace raceToRemove : toRemove) {
                                    trackedRegatta.removeTrackedRace(raceToRemove, Optional.of(toState.getThreadLocalTransporterForCurrentlyFillingFromInitialLoadOrApplyingOperationReceivedFromMaster()));
                                    RaceDefinition race = existingRegatta.getRaceByName(raceToRemove.getRaceIdentifier().getRaceName());
                                    if (race == null) continue;
                                    try {
                                        toState.removeRace(existingRegatta, race);
                                    }
                                    catch (IOException | InterruptedException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                            }
                            toState.stopTrackingAndRemove(existingRegatta);
                            this.creationCount.addOverwrittenRegattaName(existingRegatta.getName());
                            toState.removeRegatta(existingRegatta);
                            break block17;
                        }
                        catch (IOException | InterruptedException e) {
                            logger.warning(String.format("Regatta with name %1$s could not be deleted due to an error.", regatta.getRegattaIdentifier()));
                            e.printStackTrace();
                            continue;
                        }
                    }
                    logger.info(String.format("Regatta with name %1$s already exists and hasn't been overridden.", regatta.getRegattaIdentifier()));
                    continue;
                }
            }
            toState.addRegattaWithoutReplication(regatta);
            Set raceIdStrings = (Set)this.masterData.getRaceIdStringsForRegatta().get(regatta.getRegattaIdentifier());
            if (raceIdStrings != null) {
                for (String raceIdAsString : raceIdStrings) {
                    if (!this.override && toState.getRememberedRegattaForRace((Serializable)((Object)raceIdAsString)) != null) {
                        logger.info(String.format("Persistent regatta wasn't set for race id %1$s, because override was not turned on.", raceIdAsString));
                        continue;
                    }
                    toState.setRegattaForRace(regatta, raceIdAsString);
                }
            }
            this.ensureOwnership(regatta.getIdentifier(), securityService);
            this.creationCount.addOneRegatta(regatta.getId().toString());
        }
    }

    private void createCourseAreasAndEvents(RacingEventService toState, LeaderboardGroup leaderboardGroup, SecurityService securityService) {
        for (Event event : (Set)this.masterData.getEventForLeaderboardGroup().get(leaderboardGroup)) {
            UUID id = event.getId();
            Event existingEvent = toState.getEvent(id);
            if (existingEvent != null && this.override && !this.creationCount.alreadyAddedEventWithId(id.toString())) {
                logger.info(String.format("Event with ID %1$s already existed and will be overridden.", event.getId()));
                toState.removeEvent(existingEvent.getId());
                existingEvent = null;
            }
            if (existingEvent == null) {
                toState.addEventWithoutReplication(event);
                this.ensureOwnership(event.getIdentifier(), securityService);
                this.creationCount.addOneEvent(event.getId().toString());
                continue;
            }
            logger.info(String.format("Event with name %1$s already exists and hasn't been overridden.", event.getName()));
        }
    }

    private void ensureOwnership(QualifiedObjectIdentifier identifier, SecurityService securityService) {
        logger.info("Trying to adopt " + identifier + " from Masterdataimport to " + this.user.getName() + " and group " + (this.tenant == null ? "null" : this.tenant.getName()) + " if orphaned");
        securityService.setOwnershipIfNotSet(identifier, this.user, this.tenant);
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        for (Regatta regatta : this.masterData.getAllRegattas()) {
            RegattaImpl regattaImpl = (RegattaImpl)regatta;
            regattaImpl.initializeSeriesAfterDeserialize();
        }
    }

    private Iterable<TrackedRace> importTrackedRaces(RacingEventService toState, SecurityService securityService) throws Exception {
        HashSet<TrackedRace> result = new HashSet<TrackedRace>();
        if (this.connectivityParametersToRestore != null && toState.getMasterDescriptor() == null) {
            int i = 0;
            int numberOfConnectivityParamsToRestore = this.connectivityParametersToRestore.size();
            for (RaceTrackingConnectivityParameters param : this.connectivityParametersToRestore) {
                if (param != null) {
                    RaceTrackingConnectivityParameters paramToStartTracking = ((RaceTrackingConnectivityParametersHandler)toState.getRaceTrackingConnectivityParamsServiceFinder().findService(param.getTypeIdentifier())).resolve(param);
                    RaceHandle raceHandle = toState.addRace(null, paramToStartTracking, -1L);
                    RaceDefinition race = raceHandle.getRace(60000L);
                    if (race != null) {
                        DynamicTrackedRace trackedRace = raceHandle.getTrackedRegatta().getTrackedRace(race);
                        result.add((TrackedRace)trackedRace);
                        this.ensureOwnership(trackedRace.getIdentifier(), securityService);
                        this.creationCount.addOneTrackedRace(race.getId().toString());
                    } else {
                        logger.severe("Race for handle " + raceHandle + " didn't show in " + 60000L + "ms; ownership not set");
                    }
                }
                this.progress.setCurrentSubProgressPct((double)(++i) / (double)numberOfConnectivityParamsToRestore);
            }
        }
        return result;
    }
}

