/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common.settings.serializer;

import com.sap.sse.common.Util;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.common.settings.generic.CollectionSetting;
import com.sap.sse.common.settings.generic.GenericSerializableSettings;
import com.sap.sse.common.settings.generic.Setting;
import com.sap.sse.common.settings.generic.SettingsListSetting;
import com.sap.sse.common.settings.generic.SettingsMap;
import com.sap.sse.common.settings.generic.ValueCollectionSetting;
import com.sap.sse.common.settings.generic.ValueConverter;
import com.sap.sse.common.settings.generic.ValueSetting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractSettingsToJsonSerializer<OBJECT, ARRAY> {
    private static final Logger LOG = Logger.getLogger(AbstractSettingsToJsonSerializer.class.getName());

    protected abstract OBJECT newOBJECT();

    protected abstract void set(OBJECT var1, String var2, Object var3);

    protected abstract Object get(OBJECT var1, String var2);

    protected abstract boolean hasProperty(OBJECT var1, String var2);

    protected abstract ARRAY ToJsonArray(Iterable<Object> var1);

    protected abstract Iterable<Object> fromJsonArray(ARRAY var1);

    protected abstract OBJECT parseStringToJsonObject(String var1) throws Exception;

    public abstract String jsonObjectToString(OBJECT var1);

    public abstract boolean isArray(Object var1);

    protected OBJECT parseStringToJsonObjectWithExceptionHandling(String jsonString) {
        try {
            return this.parseStringToJsonObject(jsonString);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse settings as JSON: " + jsonString, e);
        }
    }

    public String serializeToString(SettingsMap settings) {
        return this.jsonObjectToString(this.serialize(settings));
    }

    public <T extends SettingsMap> T deserialize(T settings, String jsonString) {
        OBJECT jsonObject;
        if (jsonString != null && !jsonString.isEmpty() && (jsonObject = this.parseStringToJsonObjectWithExceptionHandling(jsonString)) != null) {
            this.deserialize(settings, jsonObject);
        }
        return settings;
    }

    public String serializeToString(GenericSerializableSettings settings) {
        return this.jsonObjectToString(this.serialize(settings));
    }

    public <T extends GenericSerializableSettings> T deserialize(T settings, String jsonString) {
        OBJECT jsonObject;
        if (jsonString != null && !jsonString.isEmpty() && (jsonObject = this.parseStringToJsonObjectWithExceptionHandling(jsonString)) != null) {
            this.deserialize(settings, jsonObject);
        }
        return settings;
    }

    public OBJECT serialize(SettingsMap settingsMap) {
        OBJECT jsonObject = this.newOBJECT();
        this.serializeToObject(settingsMap, jsonObject);
        return jsonObject;
    }

    private void serializeToObject(SettingsMap settingsMap, OBJECT jsonObject) {
        for (Map.Entry<String, Settings> entry : settingsMap.getSettingsPerComponentId().entrySet()) {
            String key = entry.getKey();
            Settings settings = entry.getValue();
            if (key == null) {
                if (settings instanceof SettingsMap) {
                    this.serializeToObject((SettingsMap)settings, jsonObject);
                    continue;
                }
                if (!(settings instanceof GenericSerializableSettings)) continue;
                this.serializeToObject((GenericSerializableSettings)settings, jsonObject);
                continue;
            }
            Object serializedObject = settings instanceof SettingsMap ? this.serialize((SettingsMap)settings) : (settings instanceof GenericSerializableSettings ? this.serialize((GenericSerializableSettings)settings) : null);
            if (serializedObject == null) continue;
            this.set(jsonObject, key.toString(), serializedObject);
        }
    }

    public OBJECT serialize(GenericSerializableSettings settings) {
        OBJECT jsonObject = this.newOBJECT();
        this.serializeToObject(settings, jsonObject);
        return jsonObject;
    }

    private void serializeToObject(GenericSerializableSettings settings, OBJECT jsonObject) {
        for (Map.Entry<String, Setting> entry : settings.getChildSettings().entrySet()) {
            Setting setting = entry.getValue();
            if (setting.isDefaultValue()) continue;
            this.set(jsonObject, entry.getKey(), this.serialize(setting));
        }
    }

    private Object serialize(Setting setting) {
        if (setting instanceof ValueSetting) {
            return this.serializeValueSetting((ValueSetting)setting);
        }
        if (setting instanceof CollectionSetting) {
            return this.serializeListSetting((CollectionSetting)setting);
        }
        if (setting instanceof GenericSerializableSettings) {
            return this.serialize((GenericSerializableSettings)setting);
        }
        throw new IllegalStateException("Unknown Setting type");
    }

    private <T> Object serializeValueSetting(ValueSetting<T> valueSetting) {
        return valueSetting.getValueConverter().toJSONValue(valueSetting.getValue());
    }

    private <T> Object serializeListSetting(CollectionSetting<T> listSetting) {
        if (listSetting instanceof ValueCollectionSetting) {
            ValueCollectionSetting valueListSetting = (ValueCollectionSetting)listSetting;
            return this.serializeValueCollection(valueListSetting);
        }
        if (listSetting instanceof SettingsListSetting) {
            ArrayList<Object> jsonValues = new ArrayList<Object>();
            SettingsListSetting settingsListSetting = (SettingsListSetting)listSetting;
            for (GenericSerializableSettings value : settingsListSetting.getValues()) {
                jsonValues.add(this.serialize(value));
            }
            return this.ToJsonArray(jsonValues);
        }
        throw new IllegalStateException("Unknown ListSetting type");
    }

    private <T> Object serializeValueCollection(ValueCollectionSetting<T> valueListSetting) {
        Iterable<T> removedValues;
        ValueConverter converter = valueListSetting.getValueConverter();
        OBJECT diffDataObject = this.newOBJECT();
        Iterable<T> addedValues = valueListSetting.getAddedValues();
        if (!Util.isEmpty(addedValues)) {
            this.set(diffDataObject, "added", this.serializeMultipleValues(converter, addedValues));
        }
        if (!Util.isEmpty(removedValues = valueListSetting.getRemovedValues())) {
            this.set(diffDataObject, "removed", this.serializeMultipleValues(converter, removedValues));
        }
        return diffDataObject;
    }

    private <T> Object serializeMultipleValues(ValueConverter<T> converter, Iterable<T> values) {
        ArrayList<Object> jsonValues = new ArrayList<Object>();
        for (T value : values) {
            jsonValues.add(converter.toJSONValue(value));
        }
        return this.ToJsonArray(jsonValues);
    }

    public <T extends SettingsMap> T deserialize(T settingsMap, OBJECT json) {
        if (json != null) {
            for (Map.Entry<String, Settings> entry : settingsMap.getSettingsPerComponentId().entrySet()) {
                String key = entry.getKey();
                Settings settings = entry.getValue();
                if (key == null) {
                    if (settings instanceof SettingsMap) {
                        this.deserialize((SettingsMap)settings, json);
                        continue;
                    }
                    if (!(settings instanceof GenericSerializableSettings)) continue;
                    this.deserializeObject((GenericSerializableSettings)settings, json);
                    continue;
                }
                if (!this.hasProperty(json, key)) continue;
                Object serializedObject = this.get(json, key);
                if (settings instanceof SettingsMap) {
                    Object serializedChildObject = serializedObject;
                    this.deserialize((SettingsMap)settings, serializedChildObject);
                    continue;
                }
                if (!(settings instanceof GenericSerializableSettings)) continue;
                this.deserializeObject((GenericSerializableSettings)settings, serializedObject);
            }
        }
        return settingsMap;
    }

    public <T extends GenericSerializableSettings> T deserialize(T settings, OBJECT json) {
        if (json != null) {
            for (Map.Entry<String, Setting> entry : settings.getChildSettings().entrySet()) {
                Setting setting = entry.getValue();
                if (!this.hasProperty(json, entry.getKey())) continue;
                Object jsonValue = this.get(json, entry.getKey());
                this.deserializeSetting(setting, jsonValue);
            }
        }
        return settings;
    }

    private void deserializeSetting(Setting setting, Object jsonValue) {
        if (setting instanceof ValueSetting) {
            this.deserializeValueSetting(jsonValue, (ValueSetting)setting);
        } else if (setting instanceof CollectionSetting) {
            this.deserializeListSetting(jsonValue, (CollectionSetting)setting);
        } else if (setting instanceof GenericSerializableSettings) {
            this.deserializeObject((GenericSerializableSettings)setting, jsonValue);
        } else {
            throw new IllegalStateException("Unknown Setting type");
        }
    }

    private <T extends GenericSerializableSettings> T deserializeObject(T setting, Object jsonValue) {
        return this.deserialize(setting, jsonValue);
    }

    private <T> void deserializeValueSetting(Object jsonValue, ValueSetting<T> valueSetting) {
        ValueConverter converter = valueSetting.getValueConverter();
        try {
            valueSetting.setValue(converter.fromJSONValue(jsonValue));
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Error while converting JSON value \"" + jsonValue + "\" using converter \"" + converter.getClass().getSimpleName() + "\"", e);
        }
    }

    private <T> void deserializeListSetting(Object jsonValue, CollectionSetting<T> listSetting) {
        if (listSetting instanceof ValueCollectionSetting) {
            this.deserializeValueListSetting(listSetting, jsonValue);
        } else {
            Object jsonArray = jsonValue;
            if (listSetting instanceof SettingsListSetting) {
                this.deserializeSettingsListSetting(jsonArray, (SettingsListSetting)listSetting);
            } else {
                throw new IllegalStateException("Unknown ListSetting type");
            }
        }
    }

    private <T> void deserializeValueListSetting(CollectionSetting<T> listSetting, Object jsonValue) {
        ValueCollectionSetting valueListSetting = (ValueCollectionSetting)listSetting;
        ValueConverter converter = valueListSetting.getValueConverter();
        if (this.isArray(jsonValue)) {
            Object jsonArray = jsonValue;
            List values = this.deserializeMultipleValues(jsonArray, converter);
            valueListSetting.setValues(values);
        } else {
            List removedValues;
            List addedValues;
            Object diffDataObject = jsonValue;
            if (this.hasProperty(diffDataObject, "added")) {
                Object addedValuesArray = this.get(diffDataObject, "added");
                addedValues = this.deserializeMultipleValues(addedValuesArray, converter);
            } else {
                addedValues = Collections.emptyList();
            }
            if (this.hasProperty(diffDataObject, "removed")) {
                Object removedValuesArray = this.get(diffDataObject, "removed");
                removedValues = this.deserializeMultipleValues(removedValuesArray, converter);
            } else {
                removedValues = Collections.emptyList();
            }
            valueListSetting.setDiff(removedValues, addedValues);
        }
    }

    private <T> List<T> deserializeMultipleValues(ARRAY jsonArray, ValueConverter<T> converter) {
        ArrayList<T> values = new ArrayList<T>();
        if (jsonArray != null) {
            for (Object value : this.fromJsonArray(jsonArray)) {
                try {
                    values.add(converter.fromJSONValue(value));
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Error while converting JSON value \"" + value + "\" using converter \"" + converter.getClass().getSimpleName() + "\"", e);
                }
            }
        }
        return values;
    }

    private <T extends GenericSerializableSettings> void deserializeSettingsListSetting(ARRAY jsonArray, SettingsListSetting<T> settingsListSetting) {
        ArrayList<GenericSerializableSettings> values = new ArrayList<GenericSerializableSettings>();
        for (Object value : this.fromJsonArray(jsonArray)) {
            values.add(this.deserializeObject((GenericSerializableSettings)settingsListSetting.getSettingsFactory().newInstance(), value));
        }
        settingsListSetting.setValues(values);
    }
}

