/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common.impl;

import com.sap.sse.common.NoCorrespondingServiceRegisteredException;
import com.sap.sse.common.TypeBasedServiceFinder;
import java.util.Collections;
import java.util.Set;

public class SingleTypeBasedServiceFinderImpl<ServiceType>
implements TypeBasedServiceFinder<ServiceType> {
    private final ServiceType service;
    private final String type;
    private ServiceType fallback;

    public SingleTypeBasedServiceFinderImpl(ServiceType service, ServiceType fallback, String type) {
        this.service = service;
        this.type = type;
        this.fallback = fallback;
    }

    public SingleTypeBasedServiceFinderImpl(ServiceType service, String type) {
        this(service, null, type);
    }

    @Override
    public ServiceType findService(String type) throws NoCorrespondingServiceRegisteredException {
        if (this.type.equals(type)) {
            return this.service;
        }
        if (this.fallback != null) {
            return this.fallback;
        }
        throw new NoCorrespondingServiceRegisteredException("Only one service registered", type, this.service.getClass().getSimpleName());
    }

    @Override
    public void applyServiceWhenAvailable(String type, TypeBasedServiceFinder.Callback<ServiceType> callback) {
        ServiceType service = this.findService(type);
        if (service != null) {
            callback.withService(service);
        }
    }

    @Override
    public void setFallbackService(ServiceType fallback) {
        this.fallback = fallback;
    }

    @Override
    public Set<ServiceType> findAllServices() {
        return Collections.singleton(this.service);
    }
}

