/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering.linkage;

public abstract class Linkage {
    int size;
    float[] proximity;

    void init(double[][] proximity) {
        this.size = proximity.length;
        this.proximity = new float[this.size * (this.size + 1) / 2];
        int k = 0;
        for (int j = 0; j < this.size; ++j) {
            int i = j;
            while (i < this.size) {
                this.proximity[k] = (float)proximity[i][j];
                ++i;
                ++k;
            }
        }
    }

    int index(int i, int j) {
        return i > j ? this.proximity.length - (this.size - j) * (this.size - j + 1) / 2 + i - j : this.proximity.length - (this.size - i) * (this.size - i + 1) / 2 + j - i;
    }

    public int size() {
        return this.size;
    }

    public float d(int i, int j) {
        return this.proximity[this.index(i, j)];
    }

    public abstract void merge(int var1, int var2);
}

