/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.mail.impl;

import com.sap.sse.common.TypeBasedServiceFinder;
import com.sap.sse.mail.MailService;
import com.sap.sse.mail.impl.MailServiceImpl;
import com.sap.sse.mail.impl.MailServiceResolverAgainstOsgiRegistryImpl;
import com.sap.sse.osgi.CachedOsgiTypeBasedServiceFinderFactory;
import com.sap.sse.replication.Replicable;
import com.sap.sse.util.ClearStateTestSupport;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(Activator.class.getName());
    private ServiceRegistration<?> registration;

    public void start(BundleContext context) throws Exception {
        String jettyHome = System.getProperty("jetty.home", "configuration");
        File propertiesDir = new File(jettyHome).getParentFile();
        File propertiesfile = new File(propertiesDir, "mail.properties");
        Properties mailProperties = new Properties();
        try {
            mailProperties.load(new FileReader(propertiesfile));
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "Couldn't read mail properties from " + propertiesfile.getCanonicalPath(), ioe);
        }
        MailServiceImpl mailService = new MailServiceImpl(mailProperties, new MailServiceResolverAgainstOsgiRegistryImpl((TypeBasedServiceFinder<MailService>)new CachedOsgiTypeBasedServiceFinderFactory(context).createServiceFinder(MailService.class)));
        this.registration = context.registerService(MailService.class, (Object)mailService, null);
        Hashtable<String, String> replicableServiceProperties = new Hashtable<String, String>();
        ((Dictionary)replicableServiceProperties).put("ID", mailService.getId().toString());
        context.registerService(Replicable.class.getName(), (Object)mailService, replicableServiceProperties);
        context.registerService(ClearStateTestSupport.class.getName(), (Object)mailService, null);
        Logger.getLogger(Activator.class.getName()).info("Mail Service registered.");
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.registration.unregister();
    }
}

