/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.shared;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.NauticalSide;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.gwt.ui.client.NauticalSideFormatter;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.ManeuverLossDTO;
import com.sap.sailing.gwt.ui.shared.SpeedWithBearingDTO;
import java.util.Date;

public class ManeuverDTO
implements IsSerializable {
    private ManeuverType type;
    private Tack newTack;
    private Position position;
    private Date timePoint;
    private Date timePointBefore;
    private SpeedWithBearingDTO speedWithBearingBefore;
    private SpeedWithBearingDTO speedWithBearingAfter;
    private double directionChangeInDegrees;
    private double maxTurningRateInDegreesPerSecond;
    private double avgTurningRateInDegreesPerSecond;
    private double lowestSpeedInKnots;
    private Date markPassingTimePoint;
    private NauticalSide markPassingSide;
    private ManeuverLossDTO maneuverLoss;

    @Deprecated
    ManeuverDTO() {
    }

    public ManeuverDTO(ManeuverType type, Tack newTack, Position position, Date timePoint, Date timePointBefore, SpeedWithBearingDTO speedWithBearingBefore, SpeedWithBearingDTO speedWithBearingAfter, double directionChangeInDegrees, double maxTurningRateInDegreesPerSecond, double avgTurningRateInDegreesPerSecond, double lowestSpeedInKnots, Date markPassingTimePoint, NauticalSide markPassingSide, ManeuverLossDTO maneuverLoss) {
        this.type = type;
        this.newTack = newTack;
        this.position = position;
        this.timePoint = timePoint;
        this.timePointBefore = timePointBefore;
        this.speedWithBearingBefore = speedWithBearingBefore;
        this.speedWithBearingAfter = speedWithBearingAfter;
        this.directionChangeInDegrees = directionChangeInDegrees;
        this.maxTurningRateInDegreesPerSecond = maxTurningRateInDegreesPerSecond;
        this.avgTurningRateInDegreesPerSecond = avgTurningRateInDegreesPerSecond;
        this.lowestSpeedInKnots = lowestSpeedInKnots;
        this.markPassingTimePoint = markPassingTimePoint;
        this.markPassingSide = markPassingSide;
        this.maneuverLoss = maneuverLoss;
    }

    public String toString(StringMessages stringMessages) {
        String maneuverLoss;
        SpeedWithBearingDTO before = this.getSpeedWithBearingBefore();
        SpeedWithBearingDTO after = this.getSpeedWithBearingAfter();
        DateTimeFormat dateTimeFormat = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.TIME_FULL);
        String timeAndManeuver = String.valueOf(dateTimeFormat.format(this.getTimePoint())) + ": " + this.getType().name();
        String timePointBefore = " (started: " + dateTimeFormat.format(this.getTimePointBefore()) + ")";
        String directionChange = String.valueOf(stringMessages.directionChange()) + ": " + (int)Math.round(this.getDirectionChangeInDegrees()) + " " + stringMessages.degreesShort() + " (" + (int)Math.round(before.bearingInDegrees) + " " + stringMessages.degreesShort() + " -> " + (int)Math.round(after.bearingInDegrees) + " " + stringMessages.degreesShort() + ")";
        String speedChange = String.valueOf(stringMessages.speedChange()) + ": " + NumberFormat.getDecimalFormat().format(after.speedInKnots - before.speedInKnots) + " " + stringMessages.knotsUnit() + " (" + NumberFormat.getDecimalFormat().format(before.speedInKnots) + " " + stringMessages.knotsUnit() + " -> " + NumberFormat.getDecimalFormat().format(after.speedInKnots) + " " + stringMessages.knotsUnit() + ")";
        String maxTurningRate = String.valueOf(stringMessages.maxTurningRate()) + ": " + NumberFormat.getDecimalFormat().format(this.getMaxTurningRateInDegreesPerSecond()) + " " + stringMessages.degreesPerSecondUnit();
        String avgTurningRate = String.valueOf(stringMessages.avgTurningRate()) + ": " + NumberFormat.getDecimalFormat().format(this.getAvgTurningRateInDegreesPerSecond()) + " " + stringMessages.degreesPerSecondUnit();
        String lowestSpeed = String.valueOf(stringMessages.lowestSpeed()) + ": " + NumberFormat.getDecimalFormat().format(this.getLowestSpeedInKnots()) + " " + stringMessages.knotsUnit();
        String string = maneuverLoss = this.getManeuverLoss() == null || this.getManeuverLoss().getDistanceLost() == null ? "" : "; " + stringMessages.maneuverLoss() + ": " + NumberFormat.getDecimalFormat().format(this.getManeuverLoss().getDistanceLost().getMeters()) + " " + stringMessages.metersUnit();
        String markPassing = this.getMarkPassingTimePoint() == null ? "" : "; " + stringMessages.markPassedToAt(this.getMarkPassingSide() == null ? "" : NauticalSideFormatter.format((NauticalSide)this.getMarkPassingSide(), (StringMessages)stringMessages), DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.TIME_FULL).format(this.getMarkPassingTimePoint()));
        String maneuverTitle = String.valueOf(timeAndManeuver) + timePointBefore + "; " + directionChange + "; " + speedChange + "; " + maxTurningRate + "; " + avgTurningRate + "; " + lowestSpeed + maneuverLoss + markPassing;
        return maneuverTitle;
    }

    public ManeuverType getType() {
        return this.type;
    }

    public Tack getNewTack() {
        return this.newTack;
    }

    public Position getPosition() {
        return this.position;
    }

    public Date getTimePoint() {
        return this.timePoint;
    }

    public Date getTimePointBefore() {
        return this.timePointBefore;
    }

    public SpeedWithBearingDTO getSpeedWithBearingBefore() {
        return this.speedWithBearingBefore;
    }

    public SpeedWithBearingDTO getSpeedWithBearingAfter() {
        return this.speedWithBearingAfter;
    }

    public double getDirectionChangeInDegrees() {
        return this.directionChangeInDegrees;
    }

    public double getMaxTurningRateInDegreesPerSecond() {
        return this.maxTurningRateInDegreesPerSecond;
    }

    public double getAvgTurningRateInDegreesPerSecond() {
        return this.avgTurningRateInDegreesPerSecond;
    }

    public double getLowestSpeedInKnots() {
        return this.lowestSpeedInKnots;
    }

    public Date getMarkPassingTimePoint() {
        return this.markPassingTimePoint;
    }

    public NauticalSide getMarkPassingSide() {
        return this.markPassingSide;
    }

    public ManeuverLossDTO getManeuverLoss() {
        return this.maneuverLoss;
    }
}

