/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.server;

import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ServerDescription;
import com.sap.sailing.gwt.ui.server.Activator;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.ServerInfo;
import com.sap.sse.mongodb.MongoDBService;
import com.sap.sse.replication.ReplicationService;
import com.sap.sse.replication.ReplicationStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class StatusServlet
extends HttpServlet {
    private static final String WAIT_UNTIL_RACES_LOADED = "waitUntilRacesLoaded";
    private static final long serialVersionUID = -8896724182560416457L;

    protected <T> T getService(Class<T> clazz) {
        BundleContext context = Activator.getDefault();
        ServiceTracker tracker = new ServiceTracker(context, clazz, null);
        tracker.open();
        Object service = tracker.getService();
        tracker.close();
        return (T)service;
    }

    private RacingEventService getService(ServletContext servletContext) {
        return (RacingEventService)this.getService(RacingEventService.class);
    }

    private ReplicationService getReplicationService(ServletContext servletContext) {
        return (ReplicationService)this.getService(ReplicationService.class);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServletContext servletContext = req.getServletContext();
        JSONObject result = new JSONObject();
        RacingEventService service = this.getService(servletContext);
        String waitUntilRacesLoadedString = req.getParameter(WAIT_UNTIL_RACES_LOADED);
        boolean waitUntilRacesLoaded = Boolean.valueOf(waitUntilRacesLoadedString);
        result.put((Object)"servername", (Object)ServerInfo.getName());
        result.put((Object)"serverdirectory", (Object)ServerInfo.getServerDirectory().getAbsolutePath());
        result.put((Object)"buildversion", (Object)ServerInfo.getBuildVersion());
        try {
            boolean available;
            ReplicationStatus replicationStatus;
            JSONObject versionAsJson = ServerInfo.getBuildVersionJson();
            result.putAll((Map)versionAsJson);
            long numberOfTrackedRacesToRestore = service.getNumberOfTrackedRacesToRestore();
            result.put((Object)"numberofracestorestore", (Object)numberOfTrackedRacesToRestore);
            int numberOfTrackedRacesRestored = service.getNumberOfTrackedRacesRestored();
            result.put((Object)"numberofracesrestored", (Object)numberOfTrackedRacesRestored);
            int numberOfTrackedRacesRestoredDoneLoading = service.getNumberOfTrackedRacesRestoredDoneLoading();
            result.put((Object)"numberofracesrestoreddoneloading", (Object)numberOfTrackedRacesRestoredDoneLoading);
            int numberOfTrackedRacesStillLoading = service.getNumberOfTrackedRacesStillLoading();
            result.put((Object)"numberofracesstillloading", (Object)numberOfTrackedRacesStillLoading);
            result.put((Object)"mongoDbConfiguration", (Object)this.getMongoDBReplicaSetNodes());
            ReplicationService replicationService = this.getReplicationService(servletContext);
            ReplicationStatus replicationStatus2 = replicationStatus = replicationService == null ? null : replicationService.getStatus();
            if (replicationStatus != null) {
                result.put((Object)"replication", (Object)replicationStatus.toJSONObject());
            }
            boolean bl = available = (long)numberOfTrackedRacesRestored >= numberOfTrackedRacesToRestore && (replicationStatus == null || replicationStatus.isAvailable());
            if (waitUntilRacesLoaded) {
                available = available && (long)numberOfTrackedRacesRestoredDoneLoading == numberOfTrackedRacesToRestore;
            }
            result.put((Object)"available", (Object)available);
            resp.setStatus(available ? 200 : 503);
            resp.setContentType("application/json;charset=UTF-8");
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)resp.getOutputStream());
            result.writeJSONString((Writer)out);
            out.close();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private JSONObject getMongoDBReplicaSetNodes() {
        JSONObject result = new JSONObject();
        ClusterDescription clusterDescription = MongoDBService.INSTANCE.getMongoClient().getClusterDescription();
        result.put((Object)"connectionMode", (Object)clusterDescription.getConnectionMode().name());
        result.put((Object)"replicaSet", (Object)clusterDescription.getClusterSettings().getRequiredReplicaSetName());
        result.put((Object)"database", (Object)MongoDBService.INSTANCE.getMongoClientURI().getDatabase());
        JSONArray servers = new JSONArray();
        for (ServerDescription serverDescription : clusterDescription.getServerDescriptions()) {
            JSONObject serverHostAndPort = new JSONObject();
            serverHostAndPort.put((Object)"host", (Object)serverDescription.getAddress().getHost());
            serverHostAndPort.put((Object)"port", (Object)serverDescription.getAddress().getPort());
            serverHostAndPort.put((Object)"type", (Object)serverDescription.getType().name());
            servers.add((Object)serverHostAndPort);
        }
        result.put((Object)"servers", (Object)servers);
        return result;
    }
}

