/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.polarmining;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.SimpleLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.datamining.presentation.AbstractSailingResultsPresenter;
import com.sap.sailing.gwt.ui.datamining.presentation.ChartFactory;
import com.sap.sailing.polars.datamining.shared.PolarBackendData;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.datamining.shared.GroupKey;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.QueryResultDTO;
import com.sap.sse.datamining.ui.client.ChartToCsvExporter;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.moxieapps.gwt.highcharts.client.Chart;
import org.moxieapps.gwt.highcharts.client.Series;

public class PolarBackendResultsPresenter
extends AbstractSailingResultsPresenter<Settings> {
    private final DockLayoutPanel dockLayoutPanel;
    private final Chart polarChart = ChartFactory.createPolarChart();
    private final SimpleLayoutPanel polarChartWrapperPanel;
    private final Chart speedChart;
    private final Chart angleChart;
    private final DockLayoutPanel speedAndAngleChart;

    public PolarBackendResultsPresenter(Component<?> parent, ComponentContext<?> context, StringMessages stringMessages) {
        super(parent, context, stringMessages);
        this.polarChart.getYAxis().setMin((Number)0);
        this.polarChartWrapperPanel = new /* Unavailable Anonymous Inner Class!! */;
        this.polarChartWrapperPanel.add((Widget)this.polarChart);
        this.speedChart = ChartFactory.createSpeedChart((StringMessages)stringMessages);
        this.angleChart = ChartFactory.createAngleChart((StringMessages)stringMessages);
        this.speedAndAngleChart = new /* Unavailable Anonymous Inner Class!! */;
        this.speedAndAngleChart.addNorth((Widget)this.speedChart, 50.0);
        this.speedAndAngleChart.addSouth((Widget)this.angleChart, 50.0);
        this.dockLayoutPanel = new DockLayoutPanel(Style.Unit.PCT);
        this.dockLayoutPanel.addWest((Widget)this.polarChartWrapperPanel, 40.0);
        this.dockLayoutPanel.addEast((Widget)this.speedAndAngleChart, 60.0);
        ChartToCsvExporter chartToCsvExporter = new ChartToCsvExporter(stringMessages.csvCopiedToClipboard());
        Button exportStatisticsCurveToCsvButton = new Button(stringMessages.exportStatisticsCurveToCsv(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addControl((Widget)exportStatisticsCurveToCsvButton);
    }

    protected Widget getPresentationWidget() {
        return this.dockLayoutPanel;
    }

    protected void internalShowResults(StatisticQueryDefinitionDTO queryDefinition, QueryResultDTO<?> result) {
        this.polarChart.removeAllSeries(false);
        this.speedChart.removeAllSeries(false);
        this.angleChart.removeAllSeries(false);
        HashSet<Series> seriesToHideAfterRendering = new HashSet<Series>();
        Map results = result.getResults();
        ArrayList sortedNaturally = new ArrayList(results.keySet());
        Collections.sort(sortedNaturally, new /* Unavailable Anonymous Inner Class!! */);
        for (GroupKey key : sortedNaturally) {
            int i;
            PolarBackendData aggregation = (PolarBackendData)results.get(key);
            if (aggregation.hasUpwindSpeedData()) {
                Series upwindSpeedSeries = this.speedChart.createSeries();
                upwindSpeedSeries.setName(String.valueOf(key.asString()) + "-" + this.stringMessages.upWind());
                double[] upwindSpeedOverWindSpeed = aggregation.getUpwindSpeedOverWindSpeed();
                i = 0;
                while (i < 30) {
                    upwindSpeedSeries.addPoint((Number)i, (Number)upwindSpeedOverWindSpeed[i], false, false, false);
                    ++i;
                }
                this.speedChart.addSeries(upwindSpeedSeries, false, false);
            }
            if (aggregation.hasDownwindSpeedData()) {
                Series downwindSpeedSeries = this.speedChart.createSeries();
                downwindSpeedSeries.setName(String.valueOf(key.asString()) + "-" + this.stringMessages.downWind());
                double[] downwindSpeedOverWindSpeed = aggregation.getDownwindSpeedOverWindSpeed();
                i = 0;
                while (i < 30) {
                    downwindSpeedSeries.addPoint((Number)i, (Number)downwindSpeedOverWindSpeed[i], false, false, false);
                    ++i;
                }
                this.speedChart.addSeries(downwindSpeedSeries, false, false);
            }
            if (aggregation.hasUpwindAngleData()) {
                Series upwindAngleSeries = this.speedChart.createSeries();
                upwindAngleSeries.setName(String.valueOf(key.asString()) + "-" + this.stringMessages.upWind());
                double[] upwindAngleOverWindSpeed = aggregation.getUpwindAngleOverWindSpeed();
                i = 0;
                while (i < 30) {
                    upwindAngleSeries.addPoint((Number)i, (Number)upwindAngleOverWindSpeed[i], false, false, false);
                    ++i;
                }
                this.angleChart.addSeries(upwindAngleSeries, false, false);
            }
            if (aggregation.hasDownwindAngleData()) {
                Series downwindAngleSeries = this.speedChart.createSeries();
                downwindAngleSeries.setName(String.valueOf(key.asString()) + "-" + this.stringMessages.downWind());
                double[] downwindAngleOverWindSpeed = aggregation.getDownwindAngleOverWindSpeed();
                i = 0;
                while (i < 30) {
                    downwindAngleSeries.addPoint((Number)i, (Number)downwindAngleOverWindSpeed[i], false, false, false);
                    ++i;
                }
                this.angleChart.addSeries(downwindAngleSeries, false, false);
            }
            boolean[] hasDataForAngle = aggregation.getDataForAngleBooleanArray();
            int i2 = 5;
            while (i2 < 30) {
                Series polarSeries = this.polarChart.createSeries();
                polarSeries.setName(String.valueOf(key.asString()) + "-" + i2 + "kn");
                double[][] data = aggregation.getPolarDataPerWindspeedAndAngle();
                int convertedAngle = -179;
                while (convertedAngle <= 180) {
                    int j = convertedAngle < 0 ? convertedAngle + 360 : convertedAngle;
                    polarSeries.addPoint((Number)convertedAngle, (Number)(hasDataForAngle[j] ? data[j][i2] : 0.0), false, false, false);
                    ++convertedAngle;
                }
                if (i2 != 11) {
                    seriesToHideAfterRendering.add(polarSeries);
                }
                this.polarChart.addSeries(polarSeries, false, false);
                i2 += 3;
            }
        }
        Scheduler.get().scheduleDeferred(() -> {
            this.polarChart.setSizeToMatchContainer();
            this.speedChart.setSizeToMatchContainer();
            this.angleChart.setSizeToMatchContainer();
            for (Series seriesToHide : seriesToHideAfterRendering) {
                seriesToHide.setVisible(false, false);
            }
            this.polarChart.redraw();
            this.angleChart.redraw();
            this.speedChart.redraw();
        });
    }

    public String getLocalizedShortName() {
        return this.stringMessages.polarResultsPresenter();
    }

    public boolean hasSettings() {
        return false;
    }

    public SettingsDialogComponent<Settings> getSettingsDialogComponent(Settings settings) {
        return null;
    }

    public void updateSettings(Settings newSettings) {
    }

    public String getDependentCssClassName() {
        return "polarResultsPresenter";
    }

    public Settings getSettings() {
        return null;
    }

    public String getId() {
        return "PolarBackendResultsPresenter";
    }

    static /* synthetic */ Chart access$0(PolarBackendResultsPresenter polarBackendResultsPresenter) {
        return polarBackendResultsPresenter.polarChart;
    }

    static /* synthetic */ Chart access$1(PolarBackendResultsPresenter polarBackendResultsPresenter) {
        return polarBackendResultsPresenter.speedChart;
    }

    static /* synthetic */ Chart access$2(PolarBackendResultsPresenter polarBackendResultsPresenter) {
        return polarBackendResultsPresenter.angleChart;
    }
}

