/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.leaderboard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safecss.shared.SafeStylesBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.LeaderboardRowDTO;
import com.sap.sailing.gwt.autoplay.client.resources.LeaderboardTableResourcesSixty;
import com.sap.sailing.gwt.ui.leaderboard.LeaderboardPanel;
import com.sap.sailing.gwt.ui.leaderboard.LeaderboardResources;
import com.sap.sailing.gwt.ui.leaderboard.LeaderboardTableResources;
import com.sap.sailing.gwt.ui.leaderboard.SixtyInchLeaderboardStyle;
import com.sap.sse.common.CountryCode;
import com.sap.sse.gwt.client.celltable.FlushableSortedCellTableWithStylableHeaders;
import com.sap.sse.gwt.client.shared.components.ComponentResources;

public class SixtyInchLeaderboardStyle
implements LeaderboardPanel.LeaderBoardStyle {
    private static final LeaderboardResources resources = (LeaderboardResources)GWT.create(LeaderboardResources.class);
    private static final ComponentResources componentResources = (ComponentResources)GWT.create(ComponentResources.class);
    private static final LeaderboardTableResourcesSixty tableResources = (LeaderboardTableResourcesSixty)GWT.create(LeaderboardTableResourcesSixty.class);
    private static final Template FLAG_RENDERER = (Template)GWT.create(Template.class);
    private boolean showRaceColumns;

    public SixtyInchLeaderboardStyle(boolean showRaceColumns) {
        this.showRaceColumns = showRaceColumns;
    }

    public void renderNationalityFlag(ImageResource nationalityFlagImageResource, CountryCode countryCode, SafeHtmlBuilder sb) {
        sb.append(FLAG_RENDERER.imageWithTitle(nationalityFlagImageResource.getSafeUri().asString(), 60, 40, countryCode == null ? "" : countryCode.getName()));
    }

    public void renderFlagImage(String flagImageURL, SafeHtmlBuilder sb, CompetitorDTO competitor) {
        sb.append(FLAG_RENDERER.imageWithTitle(flagImageURL, 60, 40, competitor.getName()));
    }

    public LeaderboardResources getResources() {
        return resources;
    }

    public ComponentResources getComponentresources() {
        return componentResources;
    }

    public LeaderboardTableResources getTableresources() {
        return tableResources;
    }

    public void processStyleForTotalNetPointsColumn(String textColor, SafeStylesBuilder ssb) {
        ssb.trustedColor(textColor);
    }

    public String determineBoatColorDivStyle(String competitorColor) {
        return "border-right: 4px solid " + competitorColor + ";";
    }

    public void processStyleForRaceColumnWithoutReasonForMaxPoints(boolean isDiscarded, SafeStylesBuilder ssb) {
        if (isDiscarded) {
            ssb.opacity(0.5);
        } else {
            ssb.appendTrustedString("font-weight:300;");
        }
    }

    public void afterConstructorHook(LeaderboardPanel<?> leaderboardPanel) {
        Widget toolBar;
        leaderboardPanel.getLeaderboardTable().getElement().getStyle().setMarginTop(0.0, Style.Unit.PX);
        leaderboardPanel.getElement().getStyle().setWidth(100.0, Style.Unit.PCT);
        leaderboardPanel.getElement().getStyle().setHeight(100.0, Style.Unit.PCT);
        if (leaderboardPanel.playPause != null) {
            leaderboardPanel.playPause.setVisible(false);
        }
        if ((toolBar = leaderboardPanel.getToolbarWidget()) != null) {
            Style style = toolBar.getElement().getStyle();
            style.setPosition(Style.Position.ABSOLUTE);
            style.setLeft(0.0, Style.Unit.PX);
            style.setRight(0.0, Style.Unit.PX);
            style.setBottom(0.0, Style.Unit.PX);
        }
    }

    public boolean hasRaceColumns() {
        return this.showRaceColumns;
    }

    public void hookLeaderBoardAttachment(FlowPanel contentPanel, FlushableSortedCellTableWithStylableHeaders<LeaderboardRowDTO> leaderboardTable) {
        SimplePanel wrapper = new SimplePanel(leaderboardTable);
        contentPanel.add((Widget)wrapper);
        contentPanel.getElement().getStyle().setWidth(100.0, Style.Unit.PCT);
        contentPanel.getElement().getStyle().setHeight(100.0, Style.Unit.PCT);
        contentPanel.getElement().getStyle().setPosition(Style.Position.RELATIVE);
        Style style = wrapper.getElement().getStyle();
        style.setOverflow(Style.Overflow.HIDDEN);
        style.setLeft(0.0, Style.Unit.PX);
        style.setRight(0.0, Style.Unit.PX);
        style.setTop(0.0, Style.Unit.PX);
        style.setBottom(70.0, Style.Unit.PX);
        style.setPosition(Style.Position.ABSOLUTE);
    }
}

