/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.leaderboard;

import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.sap.sailing.domain.common.dto.LeaderboardRowDTO;
import com.sap.sailing.gwt.ui.leaderboard.HasStringAndDoubleValue;
import com.sap.sailing.gwt.ui.leaderboard.MinMaxRenderer;
import java.util.Comparator;

public class PitchBearingRender
extends MinMaxRenderer<LeaderboardRowDTO> {
    private double maxAbsDoubleValue = 0.5;

    public PitchBearingRender(HasStringAndDoubleValue<LeaderboardRowDTO> valueProvider, Comparator<LeaderboardRowDTO> comparator) {
        super(valueProvider, comparator);
    }

    protected void render(LeaderboardRowDTO row, String nullSafeValue, String nullSafeTitle, SafeHtmlBuilder sb) {
        Double currentDoubleValue = this.getValueProvider().getDoubleValue((Object)row);
        if (currentDoubleValue != null) {
            double absCurrentDoubleValue = Math.abs(currentDoubleValue);
            this.maxAbsDoubleValue = Math.max(absCurrentDoubleValue, this.maxAbsDoubleValue);
            double percent = absCurrentDoubleValue / this.maxAbsDoubleValue * 100.0 / 2.0;
            if (percent < 0.02) {
                sb.append(TEMPLATES.renderMiddle(nullSafeValue, "minMaxBackgroundBar", nullSafeTitle));
            } else if (currentDoubleValue > 0.0) {
                sb.append(TEMPLATES.renderPositiveFromMiddle(nullSafeValue, "minMaxBackgroundBar", nullSafeTitle, percent));
            } else {
                sb.append(TEMPLATES.renderNegativeFromMiddle(nullSafeValue, "minMaxBackgroundBar", nullSafeTitle, percent));
            }
        }
    }
}

