/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.leaderboard;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Node;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.leaderboard.DialogBoxExt;

public class DialogBoxExt
extends DialogBox {
    private final HorizontalPanel captionPanel;
    private final Widget closeWidget;

    public DialogBoxExt(Widget closeDialogBox, String title, boolean modal) {
        super(false, modal);
        assert (closeDialogBox != null);
        this.captionPanel = new HorizontalPanel();
        this.closeWidget = closeDialogBox;
        this.closeWidget.getElement().addClassName("chartCloseButton");
        this.setHTML(title);
    }

    public void setHTML(String html) {
        this.setCaption(html, this.closeWidget);
    }

    public void setHTML(SafeHtml html) {
        if (this.closeWidget != null) {
            this.setCaption(html.asString(), this.closeWidget);
        } else {
            super.setHTML(html);
        }
    }

    private void setCaption(String txt, Widget w) {
        this.captionPanel.setWidth("100%");
        this.captionPanel.add((Widget)new HTML(txt));
        this.captionPanel.add(w);
        this.captionPanel.setCellHorizontalAlignment(w, HasHorizontalAlignment.ALIGN_RIGHT);
        this.captionPanel.setCellWidth(w, "1%");
        this.captionPanel.addStyleName("Caption");
        Element td = this.getCellElement(0, 1);
        td.setInnerHTML("");
        td.appendChild((Node)this.captionPanel.getElement());
    }

    protected boolean isHeaderCloseControlEvent(NativeEvent event) {
        return this.isWidgetEvent(event, this.closeWidget);
    }

    public void onBrowserEvent(Event event) {
        if (this.isHeaderCloseControlEvent((NativeEvent)event)) {
            switch (event.getTypeInt()) {
                case 1: 
                case 8: {
                    new DialogBoxCloseHandler(this, null).onClick(event);
                    break;
                }
                case 16: {
                    break;
                }
            }
            return;
        }
        super.onBrowserEvent(event);
    }

    protected boolean isWidgetEvent(NativeEvent event, Widget w) {
        EventTarget target = event.getEventTarget();
        if (com.google.gwt.dom.client.Element.is((JavaScriptObject)target)) {
            boolean t = w.getElement().isOrHasChild((Node)com.google.gwt.dom.client.Element.as((JavaScriptObject)target));
            return t;
        }
        return false;
    }
}

