/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.datamining.presentation;

import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.datamining.shared.ManeuverSettings;
import com.sap.sailing.datamining.shared.ManeuverSettingsImpl;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.Duration;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.dialog.DoubleBox;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;

public class ManeuverSettingsDialogComponent
implements SettingsDialogComponent<ManeuverSettings> {
    private ManeuverSettings settings;
    private StringMessages stringMessages;
    private CheckBox mainCurveAnalysisBox;
    private DoubleBox minManeuverDurationInSecondsBox;
    private DoubleBox maxManeuverDurationInSecondsBox;
    private DoubleBox minManeuverEnteringSpeedBox;
    private DoubleBox maxManeuverEnteringSpeedBox;
    private DoubleBox minManeuverExitingSpeedBox;
    private DoubleBox maxManeuverExitingSpeedBox;
    private DoubleBox minManeuverEnteringAbsTWA;
    private DoubleBox maxManeuverEnteringAbsTWA;
    private DoubleBox minManeuverExitingAbsTWA;
    private DoubleBox maxManeuverExitingAbsTWA;
    private DoubleBox minAbsCourseChangeInDegrees;
    private DoubleBox maxAbsCourseChangeInDegrees;
    private DoubleBox minDurationInSecondsFromPrecedingManeuver;
    private DoubleBox maxDurationInSecondsFromPrecedingManeuver;
    private DoubleBox minDurationInSecondsToFollowingManeuver;
    private DoubleBox maxDurationInSecondsToFollowingManeuver;

    public ManeuverSettingsDialogComponent(ManeuverSettings settings) {
        this.settings = settings;
        this.stringMessages = StringMessages.INSTANCE;
    }

    public Widget getAdditionalWidget(DataEntryDialog<?> dialog) {
        VerticalPanel vp = new VerticalPanel();
        Grid grid = new Grid(17, 2);
        grid.setCellPadding(5);
        vp.add((Widget)grid);
        this.setupGrid(grid, dialog);
        return vp;
    }

    private void setupGrid(Grid grid, DataEntryDialog<?> dialog) {
        Label mainCurveAnalysisLabel = dialog.createLabel(this.stringMessages.mainCurveAnalysis());
        grid.setWidget(0, 0, (Widget)mainCurveAnalysisLabel);
        this.mainCurveAnalysisBox = dialog.createCheckbox("");
        this.mainCurveAnalysisBox.setValue(Boolean.valueOf(this.settings.isMainCurveAnalysis()));
        grid.setWidget(0, 1, (Widget)this.mainCurveAnalysisBox);
        Label minManeuverDurationLabel = dialog.createLabel(this.stringMessages.minManeuverDuration());
        grid.setWidget(1, 0, (Widget)minManeuverDurationLabel);
        this.minManeuverDurationInSecondsBox = dialog.createDoubleBox(this.settings.getMinManeuverDuration() == null ? null : Double.valueOf(this.settings.getMinManeuverDuration().asSeconds()), 10);
        grid.setWidget(1, 1, (Widget)this.minManeuverDurationInSecondsBox);
        Label maxManeuverDurationLabel = dialog.createLabel(this.stringMessages.maxManeuverDuration());
        grid.setWidget(2, 0, (Widget)maxManeuverDurationLabel);
        this.maxManeuverDurationInSecondsBox = dialog.createDoubleBox(this.settings.getMaxManeuverDuration() == null ? null : Double.valueOf(this.settings.getMaxManeuverDuration().asSeconds()), 10);
        grid.setWidget(2, 1, (Widget)this.maxManeuverDurationInSecondsBox);
        Label minManeuverEnteringSpeedLabel = dialog.createLabel(this.stringMessages.minManeuverEnteringSpeedInKnots());
        grid.setWidget(3, 0, (Widget)minManeuverEnteringSpeedLabel);
        this.minManeuverEnteringSpeedBox = dialog.createDoubleBox(this.settings.getMinManeuverEnteringSpeedInKnots(), 10);
        grid.setWidget(3, 1, (Widget)this.minManeuverEnteringSpeedBox);
        Label maxManeuverEnteringSpeedLabel = dialog.createLabel(this.stringMessages.maxManeuverEnteringSpeedInKnots());
        grid.setWidget(4, 0, (Widget)maxManeuverEnteringSpeedLabel);
        this.maxManeuverEnteringSpeedBox = dialog.createDoubleBox(this.settings.getMaxManeuverEnteringSpeedInKnots(), 10);
        grid.setWidget(4, 1, (Widget)this.maxManeuverEnteringSpeedBox);
        Label minManeuverExitingSpeedLabel = dialog.createLabel(this.stringMessages.minManeuverExitingSpeedInKnots());
        grid.setWidget(5, 0, (Widget)minManeuverExitingSpeedLabel);
        this.minManeuverExitingSpeedBox = dialog.createDoubleBox(this.settings.getMinManeuverExitingSpeedInKnots(), 10);
        grid.setWidget(5, 1, (Widget)this.minManeuverExitingSpeedBox);
        Label maxManeuverExitingSpeedLabel = dialog.createLabel(this.stringMessages.maxManeuverExitingSpeedInKnots());
        grid.setWidget(6, 0, (Widget)maxManeuverExitingSpeedLabel);
        this.maxManeuverExitingSpeedBox = dialog.createDoubleBox(this.settings.getMaxManeuverExitingSpeedInKnots(), 10);
        grid.setWidget(6, 1, (Widget)this.maxManeuverExitingSpeedBox);
        Label minManeuverEnteringAbsTWALabel = dialog.createLabel(this.stringMessages.minManeuverEnteringAbsTWA());
        grid.setWidget(7, 0, (Widget)minManeuverEnteringAbsTWALabel);
        this.minManeuverEnteringAbsTWA = dialog.createDoubleBox(this.settings.getMinManeuverEnteringAbsTWA(), 10);
        grid.setWidget(7, 1, (Widget)this.minManeuverEnteringAbsTWA);
        Label maxManeuverEnteringAbsTWALabel = dialog.createLabel(this.stringMessages.maxManeuverEnteringAbsTWA());
        grid.setWidget(8, 0, (Widget)maxManeuverEnteringAbsTWALabel);
        this.maxManeuverEnteringAbsTWA = dialog.createDoubleBox(this.settings.getMaxManeuverEnteringAbsTWA(), 10);
        grid.setWidget(8, 1, (Widget)this.maxManeuverEnteringAbsTWA);
        Label minManeuverExitingAbsTWALabel = dialog.createLabel(this.stringMessages.minManeuverExitingAbsTWA());
        grid.setWidget(9, 0, (Widget)minManeuverExitingAbsTWALabel);
        this.minManeuverExitingAbsTWA = dialog.createDoubleBox(this.settings.getMinManeuverExitingAbsTWA(), 10);
        grid.setWidget(9, 1, (Widget)this.minManeuverExitingAbsTWA);
        Label maxManeuverExitingAbsTWALabel = dialog.createLabel(this.stringMessages.maxManeuverExitingAbsTWA());
        grid.setWidget(10, 0, (Widget)maxManeuverExitingAbsTWALabel);
        this.maxManeuverExitingAbsTWA = dialog.createDoubleBox(this.settings.getMaxManeuverExitingAbsTWA(), 10);
        grid.setWidget(10, 1, (Widget)this.maxManeuverExitingAbsTWA);
        Label minAbsCourseChangeInDegreesLabel = dialog.createLabel(this.stringMessages.minAbsCourseChangeInDegrees());
        grid.setWidget(11, 0, (Widget)minAbsCourseChangeInDegreesLabel);
        this.minAbsCourseChangeInDegrees = dialog.createDoubleBox(this.settings.getMinAbsCourseChangeInDegrees(), 10);
        grid.setWidget(11, 1, (Widget)this.minAbsCourseChangeInDegrees);
        Label maxAbsCourseChangeInDegreesLabel = dialog.createLabel(this.stringMessages.maxAbsCourseChangeInDegrees());
        grid.setWidget(12, 0, (Widget)maxAbsCourseChangeInDegreesLabel);
        this.maxAbsCourseChangeInDegrees = dialog.createDoubleBox(this.settings.getMaxAbsCourseChangeInDegrees(), 10);
        grid.setWidget(12, 1, (Widget)this.maxAbsCourseChangeInDegrees);
        Label minDurationInSecondsFromPrecedingManeuverLabel = dialog.createLabel(this.stringMessages.minDurationInSecondsFromPrecedingManeuver());
        grid.setWidget(13, 0, (Widget)minDurationInSecondsFromPrecedingManeuverLabel);
        this.minDurationInSecondsFromPrecedingManeuver = dialog.createDoubleBox(this.settings.getMinDurationFromPrecedingManeuver() == null ? null : Double.valueOf(this.settings.getMinDurationFromPrecedingManeuver().asSeconds()), 10);
        grid.setWidget(13, 1, (Widget)this.minDurationInSecondsFromPrecedingManeuver);
        Label maxDurationInSecondsFromPrecedingManeuverLabel = dialog.createLabel(this.stringMessages.maxDurationInSecondsFromPrecedingManeuver());
        grid.setWidget(14, 0, (Widget)maxDurationInSecondsFromPrecedingManeuverLabel);
        this.maxDurationInSecondsFromPrecedingManeuver = dialog.createDoubleBox(this.settings.getMaxDurationFromPrecedingManeuver() == null ? null : Double.valueOf(this.settings.getMaxDurationFromPrecedingManeuver().asSeconds()), 10);
        grid.setWidget(14, 1, (Widget)this.maxDurationInSecondsFromPrecedingManeuver);
        Label minDurationInSecondsToFollowingManeuverLabel = dialog.createLabel(this.stringMessages.minDurationInSecondsToFollowingManeuver());
        grid.setWidget(15, 0, (Widget)minDurationInSecondsToFollowingManeuverLabel);
        this.minDurationInSecondsToFollowingManeuver = dialog.createDoubleBox(this.settings.getMinDurationToFollowingManeuver() == null ? null : Double.valueOf(this.settings.getMinDurationToFollowingManeuver().asSeconds()), 10);
        grid.setWidget(15, 1, (Widget)this.minDurationInSecondsToFollowingManeuver);
        Label maxDurationInSecondsToFollowingManeuverLabel = dialog.createLabel(this.stringMessages.maxDurationInSecondsToFollowingManeuver());
        grid.setWidget(16, 0, (Widget)maxDurationInSecondsToFollowingManeuverLabel);
        this.maxDurationInSecondsToFollowingManeuver = dialog.createDoubleBox(this.settings.getMaxDurationToFollowingManeuver() == null ? null : Double.valueOf(this.settings.getMaxDurationToFollowingManeuver().asSeconds()), 10);
        grid.setWidget(16, 1, (Widget)this.maxDurationInSecondsToFollowingManeuver);
    }

    public ManeuverSettings getResult() {
        return new ManeuverSettingsImpl(this.getDurationFromSeconds((Double)this.minManeuverDurationInSecondsBox.getValue()), this.getDurationFromSeconds((Double)this.maxManeuverDurationInSecondsBox.getValue()), (Double)this.minManeuverEnteringSpeedBox.getValue(), (Double)this.maxManeuverEnteringSpeedBox.getValue(), (Double)this.minManeuverExitingSpeedBox.getValue(), (Double)this.maxManeuverExitingSpeedBox.getValue(), (Double)this.minManeuverEnteringAbsTWA.getValue(), (Double)this.maxManeuverEnteringAbsTWA.getValue(), (Double)this.minManeuverExitingAbsTWA.getValue(), (Double)this.maxManeuverExitingAbsTWA.getValue(), this.mainCurveAnalysisBox.getValue().booleanValue(), (Double)this.minAbsCourseChangeInDegrees.getValue(), (Double)this.maxAbsCourseChangeInDegrees.getValue(), this.getDurationFromSeconds((Double)this.minDurationInSecondsFromPrecedingManeuver.getValue()), this.getDurationFromSeconds((Double)this.maxDurationInSecondsFromPrecedingManeuver.getValue()), this.getDurationFromSeconds((Double)this.minDurationInSecondsToFollowingManeuver.getValue()), this.getDurationFromSeconds((Double)this.maxDurationInSecondsToFollowingManeuver.getValue()));
    }

    private Duration getDurationFromSeconds(Double seconds) {
        return seconds == null ? null : new MillisecondsDurationImpl((long)(seconds * 1000.0));
    }

    public FocusWidget getFocusWidget() {
        return this.minManeuverDurationInSecondsBox;
    }

    public DataEntryDialog.Validator<ManeuverSettings> getValidator() {
        return null;
    }
}

