/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client;

import com.sap.sailing.domain.common.ColorMap;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.impl.ColorMapImpl;
import com.sap.sailing.gwt.ui.client.CompetitorColorProvider;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMap;
import com.sap.sse.common.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CompetitorColorProviderImpl
implements CompetitorColorProvider {
    private final ColorMap<String> competitorsColorMap = new ColorMapImpl(new Color[]{RaceMap.WATER_COLOR});
    private final Map<RegattaAndRaceIdentifier, Map<CompetitorDTO, Color>> competitorsBoatColorsPerRace = new HashMap();

    public CompetitorColorProviderImpl() {
        this(null, Collections.emptyMap());
    }

    public CompetitorColorProviderImpl(RegattaAndRaceIdentifier raceIdentifier, Map<CompetitorDTO, BoatDTO> competitorsAndTheirBoats) {
        if (raceIdentifier != null) {
            for (Map.Entry<CompetitorDTO, BoatDTO> competitorAndBoat : competitorsAndTheirBoats.entrySet()) {
                Color boatColor;
                if (competitorAndBoat.getValue() == null) continue;
                HashMap<CompetitorDTO, Color> raceColors = (HashMap<CompetitorDTO, Color>)this.competitorsBoatColorsPerRace.get(raceIdentifier);
                if (raceColors == null) {
                    raceColors = new HashMap<CompetitorDTO, Color>();
                    this.competitorsBoatColorsPerRace.put(raceIdentifier, raceColors);
                }
                if ((boatColor = competitorAndBoat.getValue().getColor()) == null) continue;
                raceColors.put(competitorAndBoat.getKey(), boatColor);
                this.addBlockedColor(boatColor);
            }
        }
    }

    public Color getColor(CompetitorDTO competitor) {
        return this.getColor(competitor, null);
    }

    public Color getColor(CompetitorDTO competitor, RegattaAndRaceIdentifier raceIdentfier) {
        Map raceColors;
        Color result = null;
        if (raceIdentfier != null && (raceColors = (Map)this.competitorsBoatColorsPerRace.get(raceIdentfier)) != null) {
            result = (Color)raceColors.get(competitor);
        }
        if (result == null && competitor.getColor() != null) {
            result = competitor.getColor();
        }
        if (result == null) {
            result = this.competitorsColorMap.getColorByID((Object)competitor.getIdAsString());
        }
        return result;
    }

    public void addBlockedColor(Color color) {
        this.competitorsColorMap.addBlockedColor(color);
    }

    public void removeBlockedColor(Color color) {
        this.competitorsColorMap.removeBlockedColor(color);
    }
}

