/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.CourseAreaDTO;
import com.sap.sailing.domain.common.racelog.RacingProcedureType;
import com.sap.sailing.gwt.ui.adminconsole.AdminConsoleResources;
import com.sap.sailing.gwt.ui.adminconsole.ListBoxUtils;
import com.sap.sailing.gwt.ui.adminconsole.SetStartTimeDialog;
import com.sap.sailing.gwt.ui.client.DataEntryDialogWithDateTimeBox;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.RaceLogSetStartTimeAndProcedureDTO;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.controls.IntegerBox;
import com.sap.sse.gwt.client.controls.datetime.DateAndTimeInput;
import com.sap.sse.gwt.client.controls.datetime.DateTimeInput;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class SetStartTimeDialog
extends DataEntryDialogWithDateTimeBox<RaceLogSetStartTimeAndProcedureDTO> {
    private static AdminConsoleResources resources = (AdminConsoleResources)GWT.create(AdminConsoleResources.class);
    private final SailingServiceAsync service;
    private final ErrorReporter errorReporter;
    private final String leaderboardName;
    private final String raceColumnName;
    private final String fleetName;
    private final StringMessages stringMessages;
    private int currentPassId = -1;
    private Label currentStartTimeLabel;
    private Label currentPassIdBox;
    private DateAndTimeInput timeBox;
    private TextBox authorNameBox;
    private IntegerBox authorPriorityBox;
    private ListBox racingProcedureSelection;
    private CheckBox advancePassIdCheckbox;
    private ListBox courseAreaSelection;

    public SetStartTimeDialog(SailingServiceAsync service, ErrorReporter errorReporter, String leaderboardName, String raceColumnName, String fleetName, StringMessages stringMessages, DataEntryDialog.DialogCallback<RaceLogSetStartTimeAndProcedureDTO> callback) {
        super(stringMessages.setStartTime(), stringMessages.setStartTimeDescription(), stringMessages.setStartTime(), stringMessages.cancel(), (DataEntryDialog.Validator)new StartTimeValidator(stringMessages), callback);
        this.service = service;
        this.errorReporter = errorReporter;
        this.stringMessages = stringMessages;
        this.leaderboardName = leaderboardName;
        this.raceColumnName = raceColumnName;
        this.fleetName = fleetName;
        this.ensureDebugId("SetStartTimeDialog");
    }

    protected Widget getAdditionalWidget() {
        VerticalPanel content = new VerticalPanel();
        content.add(this.createCurrentPanel());
        content.add(this.createInputPanel());
        this.refreshCurrentStartTime();
        return content;
    }

    private Widget createCurrentPanel() {
        CaptionPanel current = new CaptionPanel(this.stringMessages.liveData());
        HorizontalPanel currentPanel = new HorizontalPanel();
        currentPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        Grid grid = new Grid(2, 2);
        this.currentStartTimeLabel = new Label("");
        grid.setWidget(0, 0, (Widget)this.createLabel(this.stringMessages.startTime()));
        grid.setWidget(0, 1, (Widget)this.currentStartTimeLabel);
        this.currentPassIdBox = new Label("");
        grid.setWidget(1, 0, (Widget)this.createLabel(this.stringMessages.currentPass()));
        grid.setWidget(1, 1, (Widget)this.currentPassIdBox);
        currentPanel.add((Widget)grid);
        PushButton refreshButton = new PushButton(new Image(resources.reloadIcon()));
        refreshButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        currentPanel.add((Widget)refreshButton);
        current.add((Widget)currentPanel);
        return current;
    }

    private Widget createInputPanel() {
        Grid content = new Grid(6, 2);
        this.timeBox = this.createDateTimeBox(new Date(), DateTimeInput.Accuracy.SECONDS);
        this.timeBox.ensureDebugId("StartTimeTimeBox");
        content.setWidget(0, 0, (Widget)this.createLabel(this.stringMessages.startTime()));
        content.setWidget(0, 1, (Widget)this.timeBox);
        this.authorNameBox = this.createTextBox("Shore");
        this.authorNameBox.ensureDebugId("AuthorNameTextBox");
        content.setWidget(1, 0, (Widget)this.createLabel(this.stringMessages.authorName()));
        content.setWidget(1, 1, (Widget)this.authorNameBox);
        this.authorPriorityBox = this.createIntegerBox(Integer.valueOf(4), 2);
        this.authorPriorityBox.ensureDebugId("AuthorPriorityIntegerBox");
        content.setWidget(2, 0, (Widget)this.createLabel(this.stringMessages.authorPriority()));
        content.setWidget(2, 1, (Widget)this.authorPriorityBox);
        this.racingProcedureSelection = this.createListBox(false);
        ListBoxUtils.setupRacingProcedureTypeListBox((ListBox)this.racingProcedureSelection, (RacingProcedureType)RacingProcedureType.RRS26, (String)this.stringMessages.no());
        int racingCounter = 0;
        RacingProcedureType[] racingProcedureTypeArray = RacingProcedureType.values();
        int n = racingProcedureTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RacingProcedureType racingType = racingProcedureTypeArray[n2];
            this.racingProcedureSelection.setValue(racingCounter++, racingType.name());
            ++n2;
        }
        this.racingProcedureSelection.ensureDebugId("RacingProcedureListBox");
        content.setWidget(3, 0, (Widget)this.createLabel(this.stringMessages.racingProcedure()));
        content.setWidget(3, 1, (Widget)this.racingProcedureSelection);
        this.courseAreaSelection = this.createListBox(false);
        this.courseAreaSelection.ensureDebugId("CourseAreaSelection");
        this.fillCourseAreas();
        content.setWidget(4, 0, (Widget)this.createLabel(this.stringMessages.courseArea()));
        content.setWidget(4, 1, (Widget)this.courseAreaSelection);
        this.advancePassIdCheckbox = this.createCheckbox(this.stringMessages.advancePassId());
        this.advancePassIdCheckbox.setValue(Boolean.valueOf(false));
        this.advancePassIdCheckbox.ensureDebugId("AdvancePassIdCheckBox");
        content.setWidget(5, 1, (Widget)this.advancePassIdCheckbox);
        return content;
    }

    private void fillCourseAreas() {
        this.service.getCourseAreas(this.leaderboardName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void fillCourseAreaSelection(List<CourseAreaDTO> courseAreas) {
        this.courseAreaSelection.clear();
        this.courseAreaSelection.addItem(this.stringMessages.pleaseSelectACourseArea(), "");
        for (CourseAreaDTO courseArea : courseAreas) {
            this.courseAreaSelection.addItem(courseArea.getName(), courseArea.getId().toString());
        }
    }

    protected RaceLogSetStartTimeAndProcedureDTO getResult() {
        RaceLogSetStartTimeAndProcedureDTO dto = new RaceLogSetStartTimeAndProcedureDTO();
        dto.leaderboardName = this.leaderboardName;
        dto.raceColumnName = this.raceColumnName;
        dto.fleetName = this.fleetName;
        dto.authorName = this.authorNameBox.getValue();
        dto.authorPriority = (Integer)this.authorPriorityBox.getValue();
        dto.logicalTimePoint = new Date();
        dto.startTime = this.timeBox.getValue();
        dto.passId = this.advancePassIdCheckbox.getValue() != false ? this.currentPassId + 1 : this.currentPassId;
        dto.racingProcedure = RacingProcedureType.values()[this.racingProcedureSelection.getSelectedIndex()];
        dto.courseAreaId = this.courseAreaSelection.getSelectedIndex() <= 0 ? null : UUID.fromString(this.courseAreaSelection.getSelectedValue());
        return dto;
    }

    private void refreshCurrentStartTime() {
        this.service.getStartTimeAndProcedure(this.leaderboardName, this.raceColumnName, this.fleetName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ void access$1(SetStartTimeDialog setStartTimeDialog) {
        setStartTimeDialog.refreshCurrentStartTime();
    }

    static /* synthetic */ ErrorReporter access$2(SetStartTimeDialog setStartTimeDialog) {
        return setStartTimeDialog.errorReporter;
    }

    static /* synthetic */ StringMessages access$3(SetStartTimeDialog setStartTimeDialog) {
        return setStartTimeDialog.stringMessages;
    }

    static /* synthetic */ void access$4(SetStartTimeDialog setStartTimeDialog, List list) {
        setStartTimeDialog.fillCourseAreaSelection(list);
    }

    static /* synthetic */ Label access$5(SetStartTimeDialog setStartTimeDialog) {
        return setStartTimeDialog.currentStartTimeLabel;
    }

    static /* synthetic */ Label access$6(SetStartTimeDialog setStartTimeDialog) {
        return setStartTimeDialog.currentPassIdBox;
    }

    static /* synthetic */ void access$7(SetStartTimeDialog setStartTimeDialog, int n) {
        setStartTimeDialog.currentPassId = n;
    }

    static /* synthetic */ ListBox access$8(SetStartTimeDialog setStartTimeDialog) {
        return setStartTimeDialog.racingProcedureSelection;
    }
}

