/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.domain.common.orc.ORCCertificate;
import com.sap.sailing.gwt.ui.adminconsole.AbstractBoatCertificatesPanel;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserService;
import java.util.Collection;
import java.util.Map;

public class RaceBoatCertificatesPanel
extends AbstractBoatCertificatesPanel {
    private final String leaderboardName;
    private final String raceColumnName;
    private final String fleetName;

    public RaceBoatCertificatesPanel(SailingServiceWriteAsync sailingServiceWrite, UserService userService, StrippedLeaderboardDTO leaderboard, RaceColumnDTO raceColumn, FleetDTO fleet, StringMessages stringMessages, ErrorReporter errorReporter) {
        super(sailingServiceWrite, userService, (SecuredDTO)leaderboard, stringMessages, errorReporter, () -> userService.hasPermission((SecuredDTO)leaderboard, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE), String.valueOf(leaderboard.getName()) + "/" + raceColumn.getName() + "/" + fleet.getName());
        this.leaderboardName = leaderboard.getName();
        this.raceColumnName = raceColumn.getName();
        this.fleetName = fleet.getName();
        this.refresh();
    }

    protected void assignCertificates(SailingServiceWriteAsync sailingServiceWrite, Map<String, ORCCertificate> certificatesByBoatIdAsString, AsyncCallback<Util.Triple<Integer, Integer, Integer>> callback) {
        sailingServiceWrite.assignORCPerformanceCurveCertificates(this.leaderboardName, this.raceColumnName, this.fleetName, certificatesByBoatIdAsString, callback);
    }

    protected void getORCCertificateAssignemtnsByBoatIdAsString(SailingServiceAsync sailingService, AsyncCallback<Map<String, ORCCertificate>> callbackForGetCertificates) {
        sailingService.getORCCertificateAssignmentsByBoatIdAsString(this.leaderboardName, this.raceColumnName, this.fleetName, callbackForGetCertificates);
    }

    protected void getBoats(SailingServiceAsync sailingService, AsyncCallback<Collection<BoatDTO>> callbackForGetBoats) {
        sailingService.getBoatRegistrationsForLeaderboard(this.leaderboardName, callbackForGetBoats);
    }
}

