/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.adminconsole.AbstractFileImportWidget;
import com.sap.sailing.gwt.ui.adminconsole.AdminConsoleResources;
import com.sap.sailing.gwt.ui.adminconsole.TrackFileImportDeviceIdentifierTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.resulthandling.SensorDataImportResponse;
import com.sap.sailing.gwt.ui.adminconsole.resulthandling.SensorDataImportResultsDialog;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.fileupload.FileUploadUtil;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.Notification;
import java.util.Collection;

public abstract class AbstractFileImportWidget
extends Composite {
    private static AbstractFileImportWidgetUiBinder uiBinder = (AbstractFileImportWidgetUiBinder)GWT.create(AbstractFileImportWidgetUiBinder.class);
    @UiField
    AdminConsoleResources res;
    @UiField
    FileUpload fileUploadUi;
    @UiField
    ListBox preferredImporterUi;
    @UiField
    Button importButtonUi;
    @UiField
    Image loadingImageUi;
    @UiField
    CheckBox downsampleUi;
    @UiField
    FormPanel formPanelUi;
    private final TrackFileImportDeviceIdentifierTableWrapper table;
    protected final SailingServiceWriteAsync sailingService;
    private final ErrorReporter errorReporter;

    protected AbstractFileImportWidget(String formActionUrl, StringMessages stringMessages, TrackFileImportDeviceIdentifierTableWrapper table, SailingServiceWriteAsync sailingService, ErrorReporter errorReporter) {
        this.table = table;
        this.sailingService = sailingService;
        this.errorReporter = errorReporter;
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.importButtonUi.setText(stringMessages.importFixes());
        this.formPanelUi.setAction(formActionUrl);
        this.getImporterTypes((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @UiHandler(value={"importButtonUi"})
    void onImportButtonClick(ClickEvent event) {
        this.showLoadingImage(true);
        this.formPanelUi.submit();
    }

    protected void setDownsampleOptionVisible(boolean visible) {
        this.downsampleUi.setVisible(visible);
    }

    @UiHandler(value={"formPanelUi"})
    void onFileImportComplete(FormPanel.SubmitCompleteEvent event) {
        SensorDataImportResponse importResponse = SensorDataImportResponse.parse((String)FileUploadUtil.getApplicationJsonContentFromHtml((String)event.getResults()));
        if (importResponse == null) {
            Notification.notify((String)StringMessages.INSTANCE.unexpectedErrorDuringFileImport(), (Notification.NotificationType)Notification.NotificationType.ERROR);
        } else {
            SensorDataImportResultsDialog.showResults((SensorDataImportResponse)importResponse);
            if (importResponse.didSucceedImportingAnyFile()) {
                this.sailingService.getTrackFileImportDeviceIds(importResponse.getUploads(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        this.showLoadingImage(false);
    }

    protected void setMultipleFileUploadEnabled(boolean enableMultipleFileUpload) {
        this.fileUploadUi.getElement().setPropertyBoolean("multiple", enableMultipleFileUpload);
    }

    protected void showLoadingImage(boolean show) {
        this.loadingImageUi.setResource(show ? this.res.loaderGif() : this.res.transparentGif());
    }

    protected abstract void getImporterTypes(AsyncCallback<Collection<String>> var1);

    static /* synthetic */ TrackFileImportDeviceIdentifierTableWrapper access$0(AbstractFileImportWidget abstractFileImportWidget) {
        return abstractFileImportWidget.table;
    }

    static /* synthetic */ ErrorReporter access$1(AbstractFileImportWidget abstractFileImportWidget) {
        return abstractFileImportWidget.errorReporter;
    }
}

